/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;

public class OpenSearchLogicalIndexScan
extends LogicalPlan {
    private final String relationName;
    private Expression filter;
    private Set<ReferenceExpression> projectList;
    private List<Pair<Sort.SortOption, Expression>> sortList;
    private Integer offset;
    private Integer limit;

    public OpenSearchLogicalIndexScan(String relationName, Expression filter, Set<ReferenceExpression> projectList, List<Pair<Sort.SortOption, Expression>> sortList, Integer limit, Integer offset) {
        super((List)ImmutableList.of());
        this.relationName = relationName;
        this.filter = filter;
        this.projectList = projectList;
        this.sortList = sortList;
        this.limit = limit;
        this.offset = offset;
    }

    public <R, C> R accept(LogicalPlanNodeVisitor<R, C> visitor, C context) {
        return (R)visitor.visitNode((LogicalPlan)this, context);
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public boolean hasProjects() {
        return this.projectList != null && !this.projectList.isEmpty();
    }

    @Generated
    public static OpenSearchLogicalIndexScanBuilder builder() {
        return new OpenSearchLogicalIndexScanBuilder();
    }

    @Generated
    public String getRelationName() {
        return this.relationName;
    }

    @Generated
    public Expression getFilter() {
        return this.filter;
    }

    @Generated
    public Set<ReferenceExpression> getProjectList() {
        return this.projectList;
    }

    @Generated
    public List<Pair<Sort.SortOption, Expression>> getSortList() {
        return this.sortList;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public String toString() {
        return "OpenSearchLogicalIndexScan(relationName=" + this.getRelationName() + ", filter=" + this.getFilter() + ", projectList=" + this.getProjectList() + ", sortList=" + this.getSortList() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchLogicalIndexScan)) {
            return false;
        }
        OpenSearchLogicalIndexScan other = (OpenSearchLogicalIndexScan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$relationName = this.getRelationName();
        String other$relationName = other.getRelationName();
        if (this$relationName == null ? other$relationName != null : !this$relationName.equals(other$relationName)) {
            return false;
        }
        Expression this$filter = this.getFilter();
        Expression other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Set<ReferenceExpression> this$projectList = this.getProjectList();
        Set<ReferenceExpression> other$projectList = other.getProjectList();
        if (this$projectList == null ? other$projectList != null : !((Object)this$projectList).equals(other$projectList)) {
            return false;
        }
        List<Pair<Sort.SortOption, Expression>> this$sortList = this.getSortList();
        List<Pair<Sort.SortOption, Expression>> other$sortList = other.getSortList();
        return !(this$sortList == null ? other$sortList != null : !((Object)this$sortList).equals(other$sortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchLogicalIndexScan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $relationName = this.getRelationName();
        result = result * 59 + ($relationName == null ? 43 : $relationName.hashCode());
        Expression $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Set<ReferenceExpression> $projectList = this.getProjectList();
        result = result * 59 + ($projectList == null ? 43 : ((Object)$projectList).hashCode());
        List<Pair<Sort.SortOption, Expression>> $sortList = this.getSortList();
        result = result * 59 + ($sortList == null ? 43 : ((Object)$sortList).hashCode());
        return result;
    }

    @Generated
    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    @Generated
    public void setProjectList(Set<ReferenceExpression> projectList) {
        this.projectList = projectList;
    }

    @Generated
    public void setSortList(List<Pair<Sort.SortOption, Expression>> sortList) {
        this.sortList = sortList;
    }

    @Generated
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public static class OpenSearchLogicalIndexScanBuilder {
        @Generated
        private String relationName;
        @Generated
        private Expression filter;
        @Generated
        private Set<ReferenceExpression> projectList;
        @Generated
        private List<Pair<Sort.SortOption, Expression>> sortList;
        @Generated
        private Integer limit;
        @Generated
        private Integer offset;

        @Generated
        OpenSearchLogicalIndexScanBuilder() {
        }

        @Generated
        public OpenSearchLogicalIndexScanBuilder relationName(String relationName) {
            this.relationName = relationName;
            return this;
        }

        @Generated
        public OpenSearchLogicalIndexScanBuilder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        @Generated
        public OpenSearchLogicalIndexScanBuilder projectList(Set<ReferenceExpression> projectList) {
            this.projectList = projectList;
            return this;
        }

        @Generated
        public OpenSearchLogicalIndexScanBuilder sortList(List<Pair<Sort.SortOption, Expression>> sortList) {
            this.sortList = sortList;
            return this;
        }

        @Generated
        public OpenSearchLogicalIndexScanBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public OpenSearchLogicalIndexScanBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public OpenSearchLogicalIndexScan build() {
            return new OpenSearchLogicalIndexScan(this.relationName, this.filter, this.projectList, this.sortList, this.limit, this.offset);
        }

        @Generated
        public String toString() {
            return "OpenSearchLogicalIndexScan.OpenSearchLogicalIndexScanBuilder(relationName=" + this.relationName + ", filter=" + this.filter + ", projectList=" + this.projectList + ", sortList=" + this.sortList + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

