/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.sql.catalog.CatalogService;
import org.opensearch.sql.catalog.model.Catalog;
import org.opensearch.sql.catalog.model.CatalogMetadata;
import org.opensearch.sql.catalog.model.ConnectorType;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.plugin.catalog.CatalogSettings;
import org.opensearch.sql.prometheus.storage.PrometheusStorageFactory;
import org.opensearch.sql.storage.StorageEngine;
import org.opensearch.sql.storage.StorageEngineFactory;

public class CatalogServiceImpl
implements CatalogService {
    private static final CatalogServiceImpl INSTANCE = new CatalogServiceImpl();
    private static final String CATALOG_NAME_REGEX = "[@*A-Za-z]+?[*a-zA-Z_\\-0-9]*";
    private static final Logger LOG = LogManager.getLogger();
    private Map<String, Catalog> catalogMap = new HashMap<String, Catalog>();
    private final Map<ConnectorType, StorageEngineFactory> connectorTypeStorageEngineFactoryMap = new HashMap<ConnectorType, StorageEngineFactory>();

    public static CatalogServiceImpl getInstance() {
        return INSTANCE;
    }

    private CatalogServiceImpl() {
        PrometheusStorageFactory prometheusStorageFactory = new PrometheusStorageFactory();
        this.connectorTypeStorageEngineFactoryMap.put(prometheusStorageFactory.getConnectorType(), (StorageEngineFactory)prometheusStorageFactory);
    }

    public void loadConnectors(Settings settings) {
        this.doPrivileged(() -> {
            InputStream inputStream = (InputStream)CatalogSettings.CATALOG_CONFIG.get(settings);
            if (inputStream != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                try {
                    List catalogs = (List)objectMapper.readValue(inputStream, (TypeReference)new TypeReference<List<CatalogMetadata>>(){});
                    this.validateCatalogs(catalogs);
                    this.constructConnectors(catalogs);
                }
                catch (IOException e) {
                    LOG.error("Catalog Configuration File uploaded is malformed. Verify and re-upload.", (Throwable)e);
                }
                catch (Throwable e) {
                    LOG.error("Catalog construction failed.", e);
                }
            }
            return null;
        });
    }

    public Set<Catalog> getCatalogs() {
        return new HashSet<Catalog>(this.catalogMap.values());
    }

    public Catalog getCatalog(String catalogName) {
        if (!this.catalogMap.containsKey(catalogName)) {
            throw new IllegalArgumentException(String.format("Catalog with name %s doesn't exist.", catalogName));
        }
        return this.catalogMap.get(catalogName);
    }

    public void registerDefaultOpenSearchCatalog(StorageEngine storageEngine) {
        if (storageEngine == null) {
            throw new IllegalArgumentException("Default storage engine can't be null");
        }
        this.catalogMap.put("@opensearch", new Catalog("@opensearch", ConnectorType.OPENSEARCH, storageEngine));
    }

    private <T> T doPrivileged(PrivilegedExceptionAction<T> action) {
        try {
            return (T)SecurityAccess.doPrivileged(action);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to perform privileged action", e);
        }
    }

    private StorageEngine createStorageEngine(CatalogMetadata catalog) {
        ConnectorType connector = catalog.getConnector();
        switch (connector) {
            case PROMETHEUS: {
                return this.connectorTypeStorageEngineFactoryMap.get(catalog.getConnector()).getStorageEngine(catalog.getName(), catalog.getProperties());
            }
        }
        throw new IllegalStateException(String.format("Unsupported Connector: %s", connector.name()));
    }

    private void constructConnectors(List<CatalogMetadata> catalogs) {
        this.catalogMap = new HashMap<String, Catalog>();
        for (CatalogMetadata catalog : catalogs) {
            try {
                String catalogName = catalog.getName();
                StorageEngine storageEngine = this.createStorageEngine(catalog);
                this.catalogMap.put(catalogName, new Catalog(catalog.getName(), catalog.getConnector(), storageEngine));
            }
            catch (Throwable e) {
                LOG.error("Catalog : {} storage engine creation failed with the following message: {}", (Object)catalog.getName(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void validateCatalogs(List<CatalogMetadata> catalogs) {
        HashSet<String> reviewedCatalogs = new HashSet<String>();
        for (CatalogMetadata catalog : catalogs) {
            if (StringUtils.isEmpty((CharSequence)catalog.getName())) {
                throw new IllegalArgumentException("Missing Name Field from a catalog. Name is a required parameter.");
            }
            if (!catalog.getName().matches(CATALOG_NAME_REGEX)) {
                throw new IllegalArgumentException(String.format("Catalog Name: %s contains illegal characters. Allowed characters: a-zA-Z0-9_-*@ ", catalog.getName()));
            }
            String catalogName = catalog.getName();
            if (reviewedCatalogs.contains(catalogName)) {
                throw new IllegalArgumentException("Catalogs with same name are not allowed.");
            }
            reviewedCatalogs.add(catalogName);
            if (!Objects.isNull(catalog.getProperties())) continue;
            throw new IllegalArgumentException("Missing properties field in catalog configuration. Properties are required parameters");
        }
    }
}

