/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.FileNotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.HeadlessBootstrap;

class DaemonBootstrap
extends HeadlessBootstrap {
    private final Logger logger = LogManager.getLogger(DaemonBootstrap.class);

    public DaemonBootstrap(CommandLine cmdLineArgs) {
        super(cmdLineArgs);
    }

    @Override
    public int start() {
        int rc = super.start();
        if (rc != 0) {
            return rc;
        }
        View.setDaemon(true);
        this.logger.info(DaemonBootstrap.getStartingMessage());
        try {
            this.initModel();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println(Constant.messages.getString("start.db.error"));
                System.out.println(e.getLocalizedMessage());
            }
            this.logger.fatal(e.getMessage(), (Throwable)e);
            return 1;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Control control = DaemonBootstrap.this.initControl();
                DaemonBootstrap.this.warnAddOnsAndExtensionsNoLongerRunnable();
                if (!DaemonBootstrap.this.handleCmdLineSessionArgsSynchronously(control)) {
                    return;
                }
                try {
                    control.getExtensionLoader().hookCommandLineListener(DaemonBootstrap.this.getArgs());
                    control.runCommandLine();
                }
                catch (Exception e) {
                    DaemonBootstrap.this.logger.error(e.getMessage(), (Throwable)e);
                }
                if (!control.getProxy().startServer()) {
                    return;
                }
                ProxyParam proxyParams = Model.getSingleton().getOptionsParam().getProxyParam();
                String message = "ZAP is now listening on " + proxyParams.getRawProxyIP() + ":" + proxyParams.getProxyPort();
                DaemonBootstrap.this.logger.info(message);
                if (DaemonBootstrap.this.getArgs().isNoStdOutLog()) {
                    System.out.println(message);
                }
                HeadlessBootstrap.checkForUpdates();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(100000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        });
        t.setName("ZAP-daemon");
        t.start();
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }
}

