/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import org.openide.awt.HtmlLabelUI;
import org.openide.awt.HtmlRenderer;

class HtmlRendererImpl
extends JLabel
implements HtmlRenderer.Renderer {
    private static final Rectangle bounds = new Rectangle();
    private static final boolean swingRendering = Boolean.getBoolean("nb.useSwingHtmlRendering");
    private final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static boolean noCacheGraphics = Boolean.getBoolean("nb.renderer.nocache");
    private ScratchGraphics cachedScratchGraphics = null;
    private boolean centered = false;
    private boolean parentFocused = false;
    private Boolean html = null;
    private int indent = 0;
    private Border border = null;
    private boolean selected = false;
    private boolean leadSelection = false;
    private Dimension prefSize = null;
    private Type type = Type.UNKNOWN;
    private int renderStyle = 0;
    private boolean enabled = true;
    private final boolean cellRenderer;

    HtmlRendererImpl(boolean bl) {
        this.cellRenderer = bl;
    }

    Type type() {
        return this.type;
    }

    @Override
    public void reset() {
        assert (SwingUtilities.isEventDispatchThread());
        this.parentFocused = false;
        this.setCentered(false);
        this.html = null;
        this.indent = 0;
        this.border = null;
        this.setIcon(null);
        this.setOpaque(false);
        this.selected = false;
        this.leadSelection = false;
        this.prefSize = null;
        this.type = Type.UNKNOWN;
        this.renderStyle = 0;
        this.setFont(UIManager.getFont("controlFont"));
        this.setIconTextGap(3);
        this.setEnabled(true);
        this.border = null;
        this.EMPTY_INSETS.top = 0;
        this.EMPTY_INSETS.left = 0;
        this.EMPTY_INSETS.right = 0;
        this.EMPTY_INSETS.bottom = 0;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        this.configureFrom(object, jTable, bl, bl2);
        this.type = Type.TABLE;
        if (swingRendering && bl) {
            this.setBackground(jTable.getSelectionBackground());
            this.setForeground(jTable.getSelectionForeground());
            this.setOpaque(true);
        }
        return this;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.reset();
        this.configureFrom(object, jTree, bl, bl4);
        this.type = Type.TREE;
        if (swingRendering && bl) {
            if (HtmlLabelUI.isGTK()) {
                this.setBackground(HtmlLabelUI.getBackgroundFor(this));
                this.setForeground(HtmlLabelUI.getForegroundFor(this));
            }
            this.setOpaque(true);
        }
        return this;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.reset();
        this.configureFrom(object, jList, bl, bl2);
        this.type = Type.LIST;
        if (swingRendering && bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
            this.setOpaque(true);
        }
        if (HtmlLabelUI.isGTK()) {
            if (n == -1) {
                Color color = UIManager.getColor("controlShadow");
                color = color == null ? Color.GRAY : color;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), BorderFactory.createEmptyBorder(3, 2, 3, 2)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
        }
        return this;
    }

    private void configureFrom(Object object, JComponent jComponent, boolean bl, boolean bl2) {
        this.setText(object == null ? "" : object.toString());
        this.setSelected(bl);
        if (bl) {
            this.setParentFocused(this.checkFocused(jComponent));
        } else {
            this.setParentFocused(false);
        }
        this.setEnabled(jComponent.isEnabled());
        this.setLeadSelection(bl2);
        this.setFont(jComponent.getFont());
    }

    private boolean checkFocused(JComponent jComponent) {
        boolean bl;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = bl = jComponent == component;
        if (!bl) {
            bl = jComponent.isAncestorOf(component);
        }
        return bl;
    }

    @Override
    public void addNotify() {
        if (swingRendering || !this.cellRenderer) {
            super.addNotify();
        }
    }

    @Override
    public void removeNotify() {
        if (swingRendering || !this.cellRenderer) {
            super.removeNotify();
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public void setParentFocused(boolean bl) {
        this.parentFocused = bl;
    }

    public void setLeadSelection(boolean bl) {
        this.leadSelection = bl;
    }

    @Override
    public void setCentered(boolean bl) {
        this.centered = bl;
        if (bl) {
            this.setIconTextGap(5);
        }
        if (swingRendering) {
            if (bl) {
                this.setVerticalTextPosition(3);
                this.setHorizontalAlignment(0);
                this.setHorizontalTextPosition(0);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalAlignment(10);
                this.setHorizontalTextPosition(11);
            }
        }
    }

    @Override
    public void setIndent(int n) {
        this.indent = n;
        if (!this.cellRenderer || swingRendering) {
            this.invalidate();
        }
    }

    @Override
    public void setHtml(boolean bl) {
        Boolean bl2 = this.html;
        String string = this.getText();
        Boolean bl3 = this.html = bl ? Boolean.TRUE : Boolean.FALSE;
        if (this.html != bl2 || swingRendering || !this.cellRenderer) {
            this.firePropertyChange("text", string, this.getText());
        }
    }

    @Override
    public void setRenderStyle(int n) {
        this.renderStyle = n;
    }

    int getRenderStyle() {
        return this.renderStyle;
    }

    boolean isLeadSelection() {
        return this.leadSelection;
    }

    boolean isCentered() {
        return this.centered;
    }

    boolean isParentFocused() {
        return this.parentFocused;
    }

    boolean isHtml() {
        Boolean bl = this.html;
        if (bl == null) {
            String string = this.getText();
            this.html = bl = this.checkHtml(string);
        }
        return bl;
    }

    private Boolean checkHtml(String string) {
        Boolean bl = string == null ? Boolean.FALSE : (string.startsWith("<html") || string.startsWith("<HTML") ? Boolean.TRUE : Boolean.FALSE);
        return bl;
    }

    boolean isSelected() {
        return this.selected;
    }

    int getIndent() {
        return this.indent;
    }

    Type getType() {
        return this.type;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!swingRendering) {
            if (this.prefSize == null) {
                this.prefSize = this.getUI().getPreferredSize(this);
            }
            return this.prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public String getText() {
        String string = super.getText();
        if (swingRendering && Boolean.TRUE.equals(this.html)) {
            string = this.ensureHtmlTags(string);
        } else if (swingRendering && this.html == null) {
            this.html = this.checkHtml(super.getText());
            if (Boolean.TRUE.equals(this.html)) {
                string = this.ensureHtmlTags(string);
            }
        }
        return string;
    }

    private String ensureHtmlTags(String string) {
        if (!(string = HtmlRendererImpl.ensureLegalFontColorTags(string)).startsWith("<HTML") && !string.startsWith("<html")) {
            string = "<html>" + string + "</html>";
        }
        return string;
    }

    private static String ensureLegalFontColorTags(String string) {
        String string2 = string.toUpperCase();
        int n = 0;
        int n2 = string2.indexOf("<FONT", n);
        StringBuffer stringBuffer = null;
        if (n2 != -1 && n2 <= string.length()) {
            while (n2 != -1 && n2 <= string.length()) {
                int n3;
                int n4;
                int n5 = string2.indexOf("COLOR", n);
                int n6 = string2.indexOf(62, n);
                n = n6 + 1;
                if (n6 == -1) break;
                if (n5 != -1 && n5 < n6 && (n4 = string2.indexOf(61, n5)) != -1 && (n3 = string2.indexOf(33, n4)) != -1 && n3 < n6) {
                    int n7 = n3 + 1;
                    int n8 = n6;
                    for (int i = n7; i < n6; ++i) {
                        char c = string.charAt(i);
                        if (Character.isLetter(c)) continue;
                        n8 = i;
                        break;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string);
                    }
                    String string3 = string.substring(n7, n8);
                    String string4 = HtmlRendererImpl.convertToStandardColor(string3);
                    stringBuffer.replace(n3, n8, string4);
                    string = stringBuffer.toString();
                    string2 = string.toUpperCase();
                }
                n = n2 = string2.indexOf("<FONT", n);
            }
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static String convertToStandardColor(String string) {
        Color color = UIManager.getColor(string);
        if (color == null) {
            color = Color.BLACK;
        }
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append('#');
        stringBuffer.append(HtmlRendererImpl.hexString(color.getRed()));
        stringBuffer.append(HtmlRendererImpl.hexString(color.getGreen()));
        stringBuffer.append(HtmlRendererImpl.hexString(color.getBlue()));
        return stringBuffer.toString();
    }

    private static String hexString(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = '0' + string;
        }
        return string;
    }

    @Override
    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (swingRendering || !this.cellRenderer) {
            if ("text".equals(string) && this.isHtml()) {
                object2 = this.getText();
            }
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public Border getBorder() {
        Border border = this.indent != 0 && (swingRendering || !this.cellRenderer) ? BorderFactory.createEmptyBorder(0, this.indent, 0, 0) : this.border;
        return border;
    }

    @Override
    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        if (swingRendering || !this.cellRenderer) {
            this.firePropertyChange("border", border2, border);
        }
    }

    @Override
    public Insets getInsets() {
        return this.getInsets(null);
    }

    @Override
    public Insets getInsets(Insets insets) {
        Insets insets2;
        Border border = this.getBorder();
        if (border == null) {
            insets2 = this.cellRenderer ? this.EMPTY_INSETS : new Insets(0, 0, 0, 0);
        } else {
            try {
                insets2 = border.getBorderInsets(this);
            }
            catch (NullPointerException nullPointerException) {
                Logger.getLogger(HtmlRendererImpl.class.getName()).log(Level.FINE, null, nullPointerException);
                Insets insets3 = insets2 = this.cellRenderer ? this.EMPTY_INSETS : new Insets(0, 0, 0, 0);
            }
        }
        if (null != insets) {
            insets.set(insets2.top, insets2.left, insets2.bottom, insets2.right);
            return insets;
        }
        return insets2;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (swingRendering || !this.cellRenderer) {
            super.setEnabled(bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void updateUI() {
        if (swingRendering) {
            super.updateUI();
        } else {
            this.setUI(HtmlLabelUI.createUI(this));
        }
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = null;
        if (this.isDisplayable()) {
            graphics = super.getGraphics();
        }
        if (graphics == null) {
            graphics = this.scratchGraphics();
        }
        return graphics;
    }

    private final Graphics2D scratchGraphics() {
        ScratchGraphics scratchGraphics;
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if ((scratchGraphics = this.cachedScratchGraphics) != null && scratchGraphics.isConfigurationCompatible(graphicsConfiguration)) {
            return scratchGraphics.getGraphics();
        }
        scratchGraphics = new ScratchGraphics(graphicsConfiguration);
        if (!noCacheGraphics) {
            this.cachedScratchGraphics = scratchGraphics;
        }
        return scratchGraphics.getGraphics();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        if (swingRendering || !this.cellRenderer) {
            super.reshape(n, n2, n3, n4);
        }
        bounds.setBounds(n, n2, n3, n4);
    }

    @Override
    public int getWidth() {
        return HtmlRendererImpl.bounds.width;
    }

    @Override
    public int getHeight() {
        return HtmlRendererImpl.bounds.height;
    }

    @Override
    public Point getLocation() {
        return bounds.getLocation();
    }

    @Override
    public void validate() {
        if (!this.cellRenderer) {
            super.validate();
        }
    }

    @Override
    public void setText(String string) {
        if (!this.cellRenderer) {
            this.prefSize = null;
        }
        super.setText(string);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this.cellRenderer) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    @Override
    public void repaint() {
        if (!this.cellRenderer) {
            super.repaint();
        }
    }

    @Override
    public void invalidate() {
        if (!this.cellRenderer) {
            super.invalidate();
        }
    }

    @Override
    public void revalidate() {
        if (!this.cellRenderer) {
            super.revalidate();
        }
    }

    @Override
    public void addAncestorListener(AncestorListener ancestorListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addAncestorListener(ancestorListener);
        }
    }

    @Override
    public void addComponentListener(ComponentListener componentListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addComponentListener(componentListener);
        }
    }

    @Override
    public void addContainerListener(ContainerListener containerListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addContainerListener(containerListener);
        }
    }

    @Override
    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addHierarchyListener(hierarchyListener);
        }
    }

    @Override
    public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addHierarchyBoundsListener(hierarchyBoundsListener);
        }
    }

    @Override
    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addInputMethodListener(inputMethodListener);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addFocusListener(focusListener);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addMouseWheelListener(mouseWheelListener);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addMouseMotionListener(mouseMotionListener);
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (swingRendering || !this.cellRenderer) {
            super.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private static final class ScratchGraphics {
        private final GraphicsConfiguration configuration;
        private Reference<Graphics2D> graphics = new SoftReference<Object>(null);

        public ScratchGraphics(GraphicsConfiguration graphicsConfiguration) {
            if (graphicsConfiguration == null) {
                throw new NullPointerException();
            }
            this.configuration = graphicsConfiguration;
        }

        public boolean isConfigurationCompatible(GraphicsConfiguration graphicsConfiguration) {
            return this.configuration.getColorModel().equals(graphicsConfiguration.getColorModel()) && this.configuration.getDefaultTransform().equals(graphicsConfiguration.getDefaultTransform());
        }

        public Graphics2D getGraphics() {
            Graphics2D graphics2D = this.graphics.get();
            if (graphics2D == null) {
                ColorModel colorModel = this.configuration.getColorModel();
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                graphics2D = bufferedImage.createGraphics();
                this.graphics = new SoftReference<Graphics2D>(graphics2D);
            }
            graphics2D.setClip(null);
            graphics2D.setTransform(this.configuration.getDefaultTransform());
            return graphics2D;
        }
    }

    static enum Type {
        UNKNOWN,
        TREE,
        LIST,
        TABLE;

    }
}

