"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pageStyles = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.UI_DATE_FORMAT = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DEFAULT_CHART_STYLES = exports.BarOrientation = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// Client route
const PPL_BASE = '/api/ppl';
exports.PPL_BASE = PPL_BASE;
const PPL_SEARCH = '/search';
exports.PPL_SEARCH = PPL_SEARCH;
const DSL_BASE = '/api/dsl';
exports.DSL_BASE = DSL_BASE;
const DSL_SEARCH = '/search';
exports.DSL_SEARCH = DSL_SEARCH;
const DSL_CAT = '/cat.indices';
exports.DSL_CAT = DSL_CAT;
const DSL_MAPPING = '/indices.getFieldMapping';
exports.DSL_MAPPING = DSL_MAPPING;
const OBSERVABILITY_BASE = '/api/observability';
exports.OBSERVABILITY_BASE = OBSERVABILITY_BASE;
const EVENT_ANALYTICS = '/event_analytics';
exports.EVENT_ANALYTICS = EVENT_ANALYTICS;
const SAVED_OBJECTS = '/saved_objects';
exports.SAVED_OBJECTS = SAVED_OBJECTS;
const SAVED_QUERY = '/query';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = '/vis'; // Server route

exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const PPL_ENDPOINT = '/_plugins/_ppl';
exports.PPL_ENDPOINT = PPL_ENDPOINT;
const SQL_ENDPOINT = '/_plugins/_sql';
exports.SQL_ENDPOINT = SQL_ENDPOINT;
const DSL_ENDPOINT = '/_plugins/_dsl';
exports.DSL_ENDPOINT = DSL_ENDPOINT;
const observabilityID = 'observability-dashboards';
exports.observabilityID = observabilityID;
const observabilityTitle = 'Observability';
exports.observabilityTitle = observabilityTitle;
const observabilityPluginOrder = 6000; // Shared Constants

exports.observabilityPluginOrder = observabilityPluginOrder;
const SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
exports.SQL_DOCUMENTATION_URL = SQL_DOCUMENTATION_URL;
const PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/ppl/commands/';
exports.PPL_DOCUMENTATION_URL = PPL_DOCUMENTATION_URL;
const PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
exports.PPL_PATTERNS_DOCUMENTATION_URL = PPL_PATTERNS_DOCUMENTATION_URL;
const UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
exports.UI_DATE_FORMAT = UI_DATE_FORMAT;
const PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
exports.PPL_DATE_FORMAT = PPL_DATE_FORMAT;
const SPAN_REGEX = /span/;
exports.SPAN_REGEX = SPAN_REGEX;
const PPL_SPAN_REGEX = /by\s*span/i;
exports.PPL_SPAN_REGEX = PPL_SPAN_REGEX;
const PPL_STATS_REGEX = /\|\s*stats/i;
exports.PPL_STATS_REGEX = PPL_STATS_REGEX;
const PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
exports.PPL_INDEX_INSERT_POINT_REGEX = PPL_INDEX_INSERT_POINT_REGEX;
const PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
exports.PPL_INDEX_REGEX = PPL_INDEX_REGEX;
const PPL_NEWLINE_REGEX = /[\n\r]+/g; // Observability plugin URI

exports.PPL_NEWLINE_REGEX = PPL_NEWLINE_REGEX;
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
}; // Saved Objects

exports.OPENSEARCH_PANELS_API = OPENSEARCH_PANELS_API;
const SAVED_OBJECT = '/object'; // Color Constants

exports.SAVED_OBJECT = SAVED_OBJECT;
const PLOTLY_COLOR = ['#3CA1C7', '#8C55A3', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
exports.PLOTLY_COLOR = PLOTLY_COLOR;
const LONG_CHART_COLOR = PLOTLY_COLOR[1];
exports.LONG_CHART_COLOR = LONG_CHART_COLOR;
const pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
exports.pageStyles = pageStyles;
let VIS_CHART_TYPES;
exports.VIS_CHART_TYPES = VIS_CHART_TYPES;

(function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
})(VIS_CHART_TYPES || (exports.VIS_CHART_TYPES = VIS_CHART_TYPES = {}));

const NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
exports.NUMERICAL_FIELDS = NUMERICAL_FIELDS;
const ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text]; // Live tail constants

exports.ENABLED_VIS_TYPES = ENABLED_VIS_TYPES;
const LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
exports.LIVE_OPTIONS = LIVE_OPTIONS;
const LIVE_END_TIME = 'now';
exports.LIVE_END_TIME = LIVE_END_TIME;
const DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 2,
  FillOpacity: 70,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
exports.DEFAULT_CHART_STYLES = DEFAULT_CHART_STYLES;
const FILLOPACITY_DIV_FACTOR = 200;
exports.FILLOPACITY_DIV_FACTOR = FILLOPACITY_DIV_FACTOR;
const SLIDER_MIN_VALUE = 0;
exports.SLIDER_MIN_VALUE = SLIDER_MIN_VALUE;
const SLIDER_MAX_VALUE = 100;
exports.SLIDER_MAX_VALUE = SLIDER_MAX_VALUE;
const SLIDER_STEP = 1;
exports.SLIDER_STEP = SLIDER_STEP;
const THRESHOLD_LINE_WIDTH = 3;
exports.THRESHOLD_LINE_WIDTH = THRESHOLD_LINE_WIDTH;
const THRESHOLD_LINE_OPACITY = 0.7;
exports.THRESHOLD_LINE_OPACITY = THRESHOLD_LINE_OPACITY;
const MAX_BUCKET_LENGTH = 16;
exports.MAX_BUCKET_LENGTH = MAX_BUCKET_LENGTH;
let BarOrientation;
exports.BarOrientation = BarOrientation;

(function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
})(BarOrientation || (exports.BarOrientation = BarOrientation = {}));

const PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
exports.PLOT_MARGIN = PLOT_MARGIN;
const WAITING_TIME_ON_USER_ACTIONS = 300;
exports.WAITING_TIME_ON_USER_ACTIONS = WAITING_TIME_ON_USER_ACTIONS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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