"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLSyntaxParser = void 0;

var _antlr4ts = require("antlr4ts");

var _case_insensitive_char_stream = require("./adaptors/case_insensitive_char_stream");

var _OpenSearchPPLLexer = require("./output/OpenSearchPPLLexer");

var _OpenSearchPPLParser = require("./output/OpenSearchPPLParser");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * PPL Syntax Parser.
 */
class PPLSyntaxParser {
  /**
   * Analyze the query syntax.
   */
  parse(query) {
    return this.createParser(this.createLexer(query));
  }

  createLexer(query) {
    return new _OpenSearchPPLLexer.OpenSearchPPLLexer(new _case_insensitive_char_stream.CaseInsensitiveCharStream(_antlr4ts.CharStreams.fromString(query)));
  }

  createParser(lexer) {
    return new _OpenSearchPPLParser.OpenSearchPPLParser(new _antlr4ts.CommonTokenStream(lexer));
  }

}

exports.PPLSyntaxParser = PPLSyntaxParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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