"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEventAnalyticsRouter = void 0;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const registerEventAnalyticsRouter = ({
  router,
  savedObjectFacet
}) => {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}`,
    validate: {}
  }, async (context, req, res) => {
    var _savedRes$data, _savedRes$data2;

    const savedRes = await savedObjectFacet.getSavedObject(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data = savedRes.data) === null || _savedRes$data === void 0 ? void 0 : _savedRes$data.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data2 = savedRes.data) === null || _savedRes$data2 === void 0 ? void 0 : _savedRes$data2.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectId}`,
    validate: {
      params: _configSchema.schema.object({
        objectId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data3, _savedRes$data4;

    const savedRes = await savedObjectFacet.getSavedObjectById(req, req.params.objectId);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data3 = savedRes.data) === null || _savedRes$data3 === void 0 ? void 0 : _savedRes$data3.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data4 = savedRes.data) === null || _savedRes$data4 === void 0 ? void 0 : _savedRes$data4.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data5;

    const savedRes = await savedObjectFacet.createSavedQuery(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data5 = savedRes.data) === null || _savedRes$data5 === void 0 ? void 0 : _savedRes$data5.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          user_configs: _configSchema.schema.string(),
          sub_type: _configSchema.schema.string(),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            label: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data6;

    const savedRes = await savedObjectFacet.createSavedVisualization(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data6 = savedRes.data) === null || _savedRes$data6 === void 0 ? void 0 : _savedRes$data6.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data7;

    const savedRes = await savedObjectFacet.updateSavedQuery(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data7 = savedRes.data) === null || _savedRes$data7 === void 0 ? void 0 : _savedRes$data7.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          user_configs: _configSchema.schema.string(),
          sub_type: _configSchema.schema.string(),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            labels: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _updateRes$data;

    const updateRes = await savedObjectFacet.updateSavedVisualization(req);
    const result = {
      body: { ...updateRes.data
      }
    };
    if (updateRes.success) return res.ok(result);
    result.statusCode = (updateRes === null || updateRes === void 0 ? void 0 : (_updateRes$data = updateRes.data) === null || _updateRes$data === void 0 ? void 0 : _updateRes$data.statusCode) || 500;
    result.message = (updateRes === null || updateRes === void 0 ? void 0 : updateRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        index: _configSchema.schema.string(),
        type: _configSchema.schema.string(),
        dsl_type: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data8;

    const savedRes = await savedObjectFacet.createSavedTimestamp(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data8 = savedRes.data) === null || _savedRes$data8 === void 0 ? void 0 : _savedRes$data8.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        objectId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.object({
          name: _configSchema.schema.string(),
          index: _configSchema.schema.string(),
          type: _configSchema.schema.string(),
          dsl_type: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data9;

    const savedRes = await savedObjectFacet.updateSavedTimestamp(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data9 = savedRes.data) === null || _savedRes$data9 === void 0 ? void 0 : _savedRes$data9.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.delete({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectIdList}`,
    validate: {
      params: _configSchema.schema.object({
        objectIdList: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _deleteResponse$data;

    const deleteResponse = await savedObjectFacet.deleteSavedObject(req);
    const result = {
      body: { ...deleteResponse.data
      }
    };
    if (deleteResponse.success) return res.ok(result);
    result.statusCode = (deleteResponse === null || deleteResponse === void 0 ? void 0 : (_deleteResponse$data = deleteResponse.data) === null || _deleteResponse$data === void 0 ? void 0 : _deleteResponse$data.statusCode) || 500;
    result.message = (deleteResponse === null || deleteResponse === void 0 ? void 0 : deleteResponse.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/addSampleSavedObjects/{sampleRequestor}`,
    validate: {
      params: _configSchema.schema.object({
        sampleRequestor: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data10;

    const savedRes = await savedObjectFacet.createSampleSavedObjects(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data10 = savedRes.data) === null || _savedRes$data10 === void 0 ? void 0 : _savedRes$data10.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
};

exports.registerEventAnalyticsRouter = registerEventAnalyticsRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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