/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import org.opensearch.client.node.NodeClient;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.client.OpenSearchNodeClient;
import org.opensearch.sql.opensearch.executor.OpenSearchExecutionEngine;
import org.opensearch.sql.opensearch.executor.protector.ExecutionProtector;
import org.opensearch.sql.opensearch.executor.protector.OpenSearchExecutionProtector;
import org.opensearch.sql.opensearch.monitor.OpenSearchMemoryHealthy;
import org.opensearch.sql.opensearch.monitor.OpenSearchResourceMonitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenSearchPluginConfig {
    @Autowired
    private NodeClient nodeClient;
    @Autowired
    private Settings settings;

    @Bean
    public OpenSearchClient client() {
        return new OpenSearchNodeClient(this.nodeClient);
    }

    @Bean
    public ExecutionEngine executionEngine() {
        return new OpenSearchExecutionEngine(this.client(), this.protector());
    }

    @Bean
    public ResourceMonitor resourceMonitor() {
        return new OpenSearchResourceMonitor(this.settings, new OpenSearchMemoryHealthy());
    }

    @Bean
    public ExecutionProtector protector() {
        return new OpenSearchExecutionProtector(this.resourceMonitor());
    }
}

