/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical.catalog;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.sql.catalog.CatalogService;
import org.opensearch.sql.catalog.model.Catalog;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.storage.TableScanOperator;

public class CatalogTableScan
extends TableScanOperator {
    private final CatalogService catalogService;
    private Iterator<ExprValue> iterator;

    public CatalogTableScan(CatalogService catalogService) {
        this.catalogService = catalogService;
        this.iterator = Collections.emptyIterator();
    }

    @Override
    public String explain() {
        return "GetCatalogRequestRequest{}";
    }

    @Override
    public void open() {
        ArrayList<ExprTupleValue> exprValues = new ArrayList<ExprTupleValue>();
        Set<Catalog> catalogs = this.catalogService.getCatalogs();
        for (Catalog catalog : catalogs) {
            exprValues.add(new ExprTupleValue(new LinkedHashMap<String, ExprValue>((Map<String, ExprValue>)ImmutableMap.of((Object)"DATASOURCE_NAME", (Object)ExprValueUtils.stringValue(catalog.getName()), (Object)"CONNECTOR_TYPE", (Object)ExprValueUtils.stringValue(catalog.getConnectorType().name())))));
        }
        this.iterator = exprValues.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.iterator.next();
    }
}

