/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.util.LongObjectPagedHashMap;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGrid;
import org.opensearch.geo.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;

public abstract class InternalGeoGrid<B extends InternalGeoGridBucket>
extends InternalMultiBucketAggregation<InternalGeoGrid, InternalGeoGridBucket>
implements GeoGrid {
    protected final int requiredSize;
    protected final List<InternalGeoGridBucket> buckets;

    protected InternalGeoGrid(String name, int requiredSize, List<InternalGeoGridBucket> buckets, Map<String, Object> metadata) {
        super(name, metadata);
        this.requiredSize = requiredSize;
        this.buckets = buckets;
    }

    protected abstract Writeable.Reader<B> getBucketReader();

    public InternalGeoGrid(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalGeoGrid.readSize((StreamInput)in);
        this.buckets = in.readList(this.getBucketReader());
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalGeoGrid.writeSize((int)this.requiredSize, (StreamOutput)out);
        out.writeList(this.buckets);
    }

    protected abstract InternalGeoGrid create(String var1, int var2, List<InternalGeoGridBucket> var3, Map<String, Object> var4);

    public List<InternalGeoGridBucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    public InternalGeoGrid reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        LongObjectPagedHashMap buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoGrid grid = (InternalGeoGrid)aggregation;
            if (buckets == null) {
                buckets = new LongObjectPagedHashMap((long)grid.buckets.size(), reduceContext.bigArrays());
            }
            for (InternalGeoGridBucket obj : grid.buckets) {
                InternalGeoGridBucket bucket = obj;
                ArrayList<InternalGeoGridBucket> existingBuckets = (ArrayList<InternalGeoGridBucket>)buckets.get(bucket.hashAsLong());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<InternalGeoGridBucket>(aggregations.size());
                    buckets.put(bucket.hashAsLong(), existingBuckets);
                }
                existingBuckets.add(bucket);
            }
        }
        int size = Math.toIntExact(!reduceContext.isFinalReduce() ? buckets.size() : Math.min((long)this.requiredSize, buckets.size()));
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        for (LongObjectPagedHashMap.Cursor cursor : buckets) {
            List sameCellBuckets = (List)cursor.value;
            ordered.insertWithOverflow(this.reduceBucket(sameCellBuckets, reduceContext));
        }
        buckets.close();
        InternalGeoGridBucket[] list = new InternalGeoGridBucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (InternalGeoGridBucket)ordered.pop();
        }
        reduceContext.consumeBucketsAndMaybeBreak(list.length);
        return this.create(this.getName(), this.requiredSize, Arrays.asList(list), this.getMetadata());
    }

    protected InternalGeoGridBucket reduceBucket(List<InternalGeoGridBucket> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        long docCount = 0L;
        for (InternalGeoGridBucket bucket : buckets) {
            docCount += bucket.docCount;
            aggregationsList.add(bucket.aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, (InternalAggregation.ReduceContext)context);
        return this.createBucket(buckets.get((int)0).hashAsLong, docCount, aggs);
    }

    protected abstract B createBucket(long var1, long var3, InternalAggregations var5);

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalGeoGridBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    int getRequiredSize() {
        return this.requiredSize;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.requiredSize, this.buckets);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoGrid other = (InternalGeoGrid)obj;
        return Objects.equals(this.requiredSize, other.requiredSize) && Objects.equals(this.buckets, other.buckets);
    }
}

