from collections.abc import Generator
from typing import Any

from openpyxl.descriptors import Strict
from openpyxl.descriptors.serialisable import Serialisable

class CellRange(Serialisable):  # type: ignore[misc]
    min_col: Any
    min_row: Any
    max_col: Any
    max_row: Any
    title: Any
    def __init__(
        self,
        range_string: Any | None = ...,
        min_col: Any | None = ...,
        min_row: Any | None = ...,
        max_col: Any | None = ...,
        max_row: Any | None = ...,
        title: Any | None = ...,
    ) -> None: ...
    @property
    def bounds(self): ...
    @property
    def coord(self): ...
    @property
    def rows(self) -> Generator[Any, None, None]: ...
    @property
    def cols(self) -> Generator[Any, None, None]: ...
    @property
    def cells(self): ...
    def __copy__(self): ...
    def shift(self, col_shift: int = ..., row_shift: int = ...) -> None: ...
    def __ne__(self, other): ...
    def __eq__(self, other): ...
    def issubset(self, other): ...
    __le__: Any
    def __lt__(self, other): ...
    def issuperset(self, other): ...
    __ge__: Any
    def __contains__(self, coord): ...
    def __gt__(self, other): ...
    def isdisjoint(self, other): ...
    def intersection(self, other): ...
    __and__: Any
    def union(self, other): ...
    __or__: Any
    def __iter__(self): ...
    def expand(self, right: int = ..., down: int = ..., left: int = ..., up: int = ...) -> None: ...
    def shrink(self, right: int = ..., bottom: int = ..., left: int = ..., top: int = ...) -> None: ...
    @property
    def size(self): ...
    @property
    def top(self): ...
    @property
    def bottom(self): ...
    @property
    def left(self): ...
    @property
    def right(self): ...

class MultiCellRange(Strict):
    ranges: Any
    def __init__(self, ranges=...) -> None: ...
    def __contains__(self, coord): ...
    def add(self, coord) -> None: ...
    def __iadd__(self, coord): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __bool__(self) -> bool: ...
    def remove(self, coord) -> None: ...
    def __iter__(self): ...
    def __copy__(self): ...
