/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

public final class Arity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, Arity> arities = new HashMap<Integer, Arity>();
    private final int value;
    public static final Arity NO_ARGUMENTS = Arity.newArity(0);
    public static final Arity ONE_ARGUMENT = Arity.newArity(1);
    public static final Arity TWO_ARGUMENTS = Arity.newArity(2);
    public static final Arity THREE_ARGUMENTS = Arity.newArity(3);
    public static final Arity OPTIONAL = Arity.newArity(-1);
    public static final Arity ONE_REQUIRED = Arity.newArity(-2);
    public static final Arity TWO_REQUIRED = Arity.newArity(-3);
    public static final Arity THREE_REQUIRED = Arity.newArity(-4);
    public static final int UNLIMITED_ARGUMENTS = -1;

    private Arity(int value2) {
        this.value = value2;
    }

    private static Arity createArity(int required, int optional, boolean rest) {
        return Arity.createArity(optional > 0 || rest ? -(required + 1) : required);
    }

    public static Arity createArity(int value2) {
        switch (value2) {
            case -4: {
                return THREE_REQUIRED;
            }
            case -3: {
                return TWO_REQUIRED;
            }
            case -2: {
                return ONE_REQUIRED;
            }
            case -1: {
                return OPTIONAL;
            }
            case 0: {
                return NO_ARGUMENTS;
            }
            case 1: {
                return ONE_ARGUMENT;
            }
            case 2: {
                return TWO_ARGUMENTS;
            }
            case 3: {
                return THREE_ARGUMENTS;
            }
        }
        return Arity.newArity(value2);
    }

    public static Arity fromAnnotation(JRubyMethod anno) {
        return Arity.createArity(anno.required(), anno.optional(), anno.rest());
    }

    public static Arity fromAnnotation(JRubyMethod anno, int required) {
        return Arity.createArity(required, anno.optional(), anno.rest());
    }

    public static Arity fromAnnotation(JRubyMethod anno, Class[] parameterTypes, boolean isStatic) {
        int required;
        if (anno.optional() == 0 && !anno.rest() && anno.required() == 0) {
            int i2 = parameterTypes.length;
            if (isStatic) {
                --i2;
            }
            if (parameterTypes.length > 0) {
                if (parameterTypes[0] == ThreadContext.class) {
                    --i2;
                }
                if (parameterTypes[parameterTypes.length - 1] == Block.class) {
                    --i2;
                }
            }
            required = i2;
        } else {
            required = anno.required();
        }
        return Arity.createArity(required, anno.optional(), anno.rest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Arity newArity(int value2) {
        Arity result2 = arities.get(value2);
        if (result2 == null) {
            Map<Integer, Arity> map2 = arities;
            synchronized (map2) {
                result2 = arities.get(value2);
                if (result2 == null) {
                    result2 = new Arity(value2);
                    arities.put(value2, result2);
                }
            }
        }
        return result2;
    }

    public static Arity fixed(int arity2) {
        assert (arity2 >= 0);
        return Arity.createArity(arity2);
    }

    public static Arity optional() {
        return OPTIONAL;
    }

    public static Arity required(int minimum) {
        assert (minimum >= 0);
        return Arity.createArity(-(1 + minimum));
    }

    public static Arity noArguments() {
        return NO_ARGUMENTS;
    }

    public static Arity singleArgument() {
        return ONE_ARGUMENT;
    }

    public static Arity twoArguments() {
        return TWO_ARGUMENTS;
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(Ruby runtime2, IRubyObject[] args2) {
        this.checkArity(runtime2, args2.length);
    }

    public void checkArity(Ruby runtime2, int length2) {
        if (this.isFixed() ? length2 != this.required() : length2 < this.required()) {
            throw runtime2.newArgumentError(length2, this.required());
        }
    }

    public boolean isFixed() {
        return this.value >= 0;
    }

    public int required() {
        return this.value < 0 ? -(1 + this.value) : this.value;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.isFixed() ? "Fixed" + this.required() : "Opt";
    }

    public static int checkArgumentCount(Ruby runtime2, IRubyObject[] args2, int min2, int max2) {
        return Arity.checkArgumentCount(runtime2, args2.length, min2, max2);
    }

    public static int checkArgumentCount(ThreadContext context, IRubyObject[] args2, int min2, int max2) {
        return Arity.checkArgumentCount(context, args2.length, min2, max2);
    }

    public static int checkArgumentCount(ThreadContext context, String name2, IRubyObject[] args2, int min2, int max2) {
        return Arity.checkArgumentCount(context.runtime, name2, args2.length, min2, max2);
    }

    public static int checkArgumentCount(Ruby runtime2, String name2, IRubyObject[] args2, int min2, int max2) {
        return Arity.checkArgumentCount(runtime2, name2, args2.length, min2, max2);
    }

    public static int checkArgumentCount(Ruby runtime2, int length2, int min2, int max2) {
        Arity.raiseArgumentError(runtime2, length2, min2, max2);
        return length2;
    }

    public static int checkArgumentCount(ThreadContext context, int length2, int min2, int max2) {
        Arity.raiseArgumentError(context, length2, min2, max2);
        return length2;
    }

    public static int checkArgumentCount(Ruby runtime2, int length2, int min2, int max2, boolean hasKwargs) {
        Arity.raiseArgumentError(runtime2, length2, min2, max2, hasKwargs);
        return length2;
    }

    public static int checkArgumentCount(Ruby runtime2, String name2, int length2, int min2, int max2) {
        Arity.raiseArgumentError(runtime2, name2, length2, min2, max2);
        return length2;
    }

    public static int checkArgumentCount(Ruby runtime2, String name2, int length2, int min2, int max2, boolean hasKwargs) {
        Arity.raiseArgumentError(runtime2, name2, length2, min2, max2, hasKwargs);
        return length2;
    }

    public static void raiseArgumentError(Ruby runtime2, IRubyObject[] args2, int min2, int max2) {
        Arity.raiseArgumentError(runtime2, args2.length, min2, max2);
    }

    public static void raiseArgumentError(Ruby runtime2, int length2, int min2, int max2) {
        if (length2 < min2 || max2 > -1 && length2 > max2) {
            throw runtime2.newArgumentError(length2, min2, max2);
        }
    }

    public static void raiseArgumentError(ThreadContext context, int length2, int min2, int max2) {
        Arity.raiseArgumentError(context.runtime, length2, min2, max2);
    }

    public static void raiseArgumentError(Ruby runtime2, int length2, int min2, int max2, boolean hasKwargs) {
        if (length2 < min2) {
            throw runtime2.newArgumentError(length2, min2, max2);
        }
        if (max2 > -1 && length2 > max2) {
            if (hasKwargs && length2 == max2 + 1) {
                return;
            }
            throw runtime2.newArgumentError(length2, min2, max2);
        }
    }

    public static void raiseArgumentError(Ruby runtime2, String name2, int length2, int min2, int max2) {
        if (length2 < min2 || max2 > -1 && length2 > max2) {
            throw runtime2.newArgumentError(name2, length2, min2, max2);
        }
    }

    public static void raiseArgumentError(Ruby runtime2, String name2, int length2, int min2, int max2, boolean hasKwargs) {
        if (length2 < min2) {
            throw runtime2.newArgumentError(name2, length2, min2, max2);
        }
        if (max2 > -1 && length2 > max2) {
            if (hasKwargs && length2 == max2 + 1) {
                return;
            }
            throw runtime2.newArgumentError(name2, length2, min2, max2);
        }
    }

    public static IRubyObject[] scanArgs(Ruby runtime2, IRubyObject[] args2, int required, int optional) {
        int total2 = required + optional;
        int len = Arity.checkArgumentCount(runtime2, args2, required, total2);
        args2 = ArraySupport.newCopy(args2, total2);
        for (int i2 = len; i2 < total2; ++i2) {
            args2[i2] = runtime2.getNil();
        }
        return args2;
    }
}

