/**
 * Helpers for converting FROM LanguageServer types language-server ts types
 */
import * as lsp from 'vscode-languageserver-protocol';
import type { tsp } from '../ts-protocol.js';
export declare namespace Range {
    const fromTextSpan: (span: tsp.TextSpan) => lsp.Range;
    const toTextSpan: (range: lsp.Range) => tsp.TextSpan;
    const fromLocations: (start: tsp.Location, end: tsp.Location) => lsp.Range;
    const toFileRangeRequestArgs: (file: string, range: lsp.Range) => tsp.FileRangeRequestArgs;
    const toFormattingRequestArgs: (file: string, range: lsp.Range) => tsp.FormatRequestArgs;
    function intersection(one: lsp.Range, other: lsp.Range): lsp.Range | undefined;
}
export declare namespace Position {
    const fromLocation: (tslocation: tsp.Location) => lsp.Position;
    const toLocation: (position: lsp.Position) => tsp.Location;
    const toFileLocationRequestArgs: (file: string, position: lsp.Position) => tsp.FileLocationRequestArgs;
    function Min(): undefined;
    function Min(...positions: lsp.Position[]): lsp.Position;
    function isBefore(one: lsp.Position, other: lsp.Position): boolean;
    function Max(): undefined;
    function Max(...positions: lsp.Position[]): lsp.Position;
    function isAfter(one: lsp.Position, other: lsp.Position): boolean;
    function isBeforeOrEqual(one: lsp.Position, other: lsp.Position): boolean;
}
export declare namespace Location {
    const fromTextSpan: (resource: lsp.DocumentUri, tsTextSpan: tsp.TextSpan) => lsp.Location;
}
//# sourceMappingURL=typeConverters.d.ts.map