/* contacts-persona-filter.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-persona-filter.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contacts.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <folks/folks.h>

enum  {
	CONTACTS_PERSONA_FILTER_0_PROPERTY,
	CONTACTS_PERSONA_FILTER_IGNORED_STORE_TYPES_PROPERTY,
	CONTACTS_PERSONA_FILTER_NUM_PROPERTIES
};
static GParamSpec* contacts_persona_filter_properties[CONTACTS_PERSONA_FILTER_NUM_PROPERTIES];

struct _ContactsPersonaFilterPrivate {
	gchar** _ignored_store_types;
	gint _ignored_store_types_length1;
	gint __ignored_store_types_size_;
};

static gint ContactsPersonaFilter_private_offset;
static gpointer contacts_persona_filter_parent_class = NULL;

static gboolean contacts_persona_filter_real_match (GtkFilter* base,
                                             GObject* item);
static gboolean contacts_persona_filter_match_persona_store_type (ContactsPersonaFilter* self,
                                                           FolksPersona* persona);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static GtkFilterMatch contacts_persona_filter_real_get_strictness (GtkFilter* base);
static void contacts_persona_filter_finalize (GObject * obj);
static GType contacts_persona_filter_get_type_once (void);
static void _vala_contacts_persona_filter_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_contacts_persona_filter_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_persona_filter_get_instance_private (ContactsPersonaFilter* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsPersonaFilter_private_offset);
}

static gboolean
contacts_persona_filter_real_match (GtkFilter* base,
                                    GObject* item)
{
	ContactsPersonaFilter * self;
	FolksPersona* persona = NULL;
	gboolean result;
	self = (ContactsPersonaFilter*) base;
	persona = G_TYPE_CHECK_INSTANCE_TYPE (item, FOLKS_TYPE_PERSONA) ? ((FolksPersona*) item) : NULL;
	g_return_val_if_fail (persona != NULL, FALSE);
	result = contacts_persona_filter_match_persona_store_type (self, persona);
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
contacts_persona_filter_match_persona_store_type (ContactsPersonaFilter* self,
                                                  FolksPersona* persona)
{
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = folks_persona_get_store (persona);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_persona_store_get_type_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_persona_filter_get_ignored_store_types (self, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	result = !_vala_string_array_contains (_tmp6_, _tmp6__length1, _tmp3_);
	return result;
}

static GtkFilterMatch
contacts_persona_filter_real_get_strictness (GtkFilter* base)
{
	ContactsPersonaFilter * self;
	GtkFilterMatch result;
	self = (ContactsPersonaFilter*) base;
	result = GTK_FILTER_MATCH_SOME;
	return result;
}

ContactsPersonaFilter*
contacts_persona_filter_construct (GType object_type)
{
	ContactsPersonaFilter * self = NULL;
	self = (ContactsPersonaFilter*) g_object_new (object_type, NULL);
	return self;
}

ContactsPersonaFilter*
contacts_persona_filter_new (void)
{
	return contacts_persona_filter_construct (CONTACTS_TYPE_PERSONA_FILTER);
}

gchar**
contacts_persona_filter_get_ignored_store_types (ContactsPersonaFilter* self,
                                                 gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ignored_store_types;
	_tmp0__length1 = self->priv->_ignored_store_types_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

void
contacts_persona_filter_set_ignored_store_types (ContactsPersonaFilter* self,
                                                 gchar** value,
                                                 gint value_length1)
{
	gboolean _tmp0_ = FALSE;
	GEqualFunc _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		gint _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp1_ = contacts_persona_filter_get_ignored_store_types (self, &_tmp2_);
		_tmp1__length1 = _tmp2_;
		_tmp3_ = _tmp1_;
		_tmp3__length1 = _tmp1__length1;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = ((GEqualFunc) g_strv_equal);
	_tmp5_ = self->priv->_ignored_store_types;
	_tmp5__length1 = self->priv->_ignored_store_types_length1;
	if (_tmp4_ (_tmp5_, value)) {
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, contacts_persona_filter_properties[CONTACTS_PERSONA_FILTER_IGNORED_STORE_TYPES_PROPERTY]);
}

static void
contacts_persona_filter_class_init (ContactsPersonaFilterClass * klass,
                                    gpointer klass_data)
{
	contacts_persona_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsPersonaFilter_private_offset);
	((GtkFilterClass *) klass)->match = (gboolean (*) (GtkFilter*, GObject*)) contacts_persona_filter_real_match;
	((GtkFilterClass *) klass)->get_strictness = (GtkFilterMatch (*) (GtkFilter*)) contacts_persona_filter_real_get_strictness;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_persona_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_persona_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_persona_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_PERSONA_FILTER_IGNORED_STORE_TYPES_PROPERTY, contacts_persona_filter_properties[CONTACTS_PERSONA_FILTER_IGNORED_STORE_TYPES_PROPERTY] = g_param_spec_boxed ("ignored-store-types", "ignored-store-types", "ignored-store-types", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_persona_filter_instance_init (ContactsPersonaFilter * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	self->priv = contacts_persona_filter_get_instance_private (self);
	_tmp0_ = g_strdup ("key-file");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	self->priv->_ignored_store_types = _tmp1_;
	self->priv->_ignored_store_types_length1 = 1;
	self->priv->__ignored_store_types_size_ = self->priv->_ignored_store_types_length1;
}

static void
contacts_persona_filter_finalize (GObject * obj)
{
	ContactsPersonaFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_PERSONA_FILTER, ContactsPersonaFilter);
	self->priv->_ignored_store_types = (_vala_array_free (self->priv->_ignored_store_types, self->priv->_ignored_store_types_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (contacts_persona_filter_parent_class)->finalize (obj);
}

/**
 * A custom GtkFilter to filter out {@link Folks.Persona}s, for example to
 * exclude certain types of persona stores.
 */
 G_GNUC_NO_INLINE static GType
contacts_persona_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsPersonaFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_persona_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsPersonaFilter), 0, (GInstanceInitFunc) contacts_persona_filter_instance_init, NULL };
	GType contacts_persona_filter_type_id;
	contacts_persona_filter_type_id = g_type_register_static (gtk_filter_get_type (), "ContactsPersonaFilter", &g_define_type_info, 0);
	ContactsPersonaFilter_private_offset = g_type_add_instance_private (contacts_persona_filter_type_id, sizeof (ContactsPersonaFilterPrivate));
	return contacts_persona_filter_type_id;
}

GType
contacts_persona_filter_get_type (void)
{
	static volatile gsize contacts_persona_filter_type_id__once = 0;
	if (g_once_init_enter (&contacts_persona_filter_type_id__once)) {
		GType contacts_persona_filter_type_id;
		contacts_persona_filter_type_id = contacts_persona_filter_get_type_once ();
		g_once_init_leave (&contacts_persona_filter_type_id__once, contacts_persona_filter_type_id);
	}
	return contacts_persona_filter_type_id__once;
}

static void
_vala_contacts_persona_filter_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ContactsPersonaFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PERSONA_FILTER, ContactsPersonaFilter);
	switch (property_id) {
		case CONTACTS_PERSONA_FILTER_IGNORED_STORE_TYPES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, contacts_persona_filter_get_ignored_store_types (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_persona_filter_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ContactsPersonaFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_PERSONA_FILTER, ContactsPersonaFilter);
	switch (property_id) {
		case CONTACTS_PERSONA_FILTER_IGNORED_STORE_TYPES_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			contacts_persona_filter_set_ignored_store_types (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

