
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "qzsettings_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QzSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QzSettings >()))
        return -1;

    ::QzSettings *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzSettings.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QzSettings()
            cptr = new ::QzSettings();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QzSettings >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QzSettingsFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzSettings.loadSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loadSettings()
            cppSelf->loadSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QzSettingsFunc_saveSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.QzSettings.saveSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saveSettings()
            cppSelf->saveSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QzSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QzSettings_methods[] = {
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_QzSettingsFunc_loadSettings), METH_NOARGS},
    {"saveSettings", reinterpret_cast<PyCFunction>(Sbk_QzSettingsFunc_saveSettings), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QzSettings_get_selectAllOnDoubleClick(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->selectAllOnDoubleClick;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_selectAllOnDoubleClick(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectAllOnDoubleClick' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectAllOnDoubleClick', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->selectAllOnDoubleClick;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectAllOnDoubleClick = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_selectAllOnClick(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->selectAllOnClick;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_selectAllOnClick(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectAllOnClick' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectAllOnClick', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->selectAllOnClick;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectAllOnClick = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showLoadingProgress(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showLoadingProgress;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_showLoadingProgress(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'showLoadingProgress' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showLoadingProgress', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->showLoadingProgress;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showLoadingProgress = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showLocationSuggestions(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->showLocationSuggestions;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_showLocationSuggestions(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'showLocationSuggestions' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showLocationSuggestions', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->showLocationSuggestions;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showLocationSuggestions = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showSwitchTab(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showSwitchTab;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_showSwitchTab(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'showSwitchTab' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showSwitchTab', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->showSwitchTab;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showSwitchTab = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_alwaysShowGoIcon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->alwaysShowGoIcon;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_alwaysShowGoIcon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'alwaysShowGoIcon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'alwaysShowGoIcon', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->alwaysShowGoIcon;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->alwaysShowGoIcon = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_useInlineCompletion(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->useInlineCompletion;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_useInlineCompletion(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'useInlineCompletion' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'useInlineCompletion', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->useInlineCompletion;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->useInlineCompletion = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_searchOnEngineChange(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->searchOnEngineChange;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_searchOnEngineChange(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'searchOnEngineChange' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'searchOnEngineChange', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->searchOnEngineChange;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchOnEngineChange = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_searchFromAddressBar(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->searchFromAddressBar;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_searchFromAddressBar(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'searchFromAddressBar' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'searchFromAddressBar', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->searchFromAddressBar;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchFromAddressBar = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_searchWithDefaultEngine(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->searchWithDefaultEngine;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_searchWithDefaultEngine(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'searchWithDefaultEngine' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'searchWithDefaultEngine', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->searchWithDefaultEngine;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->searchWithDefaultEngine = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showABSearchSuggestions(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showABSearchSuggestions;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_showABSearchSuggestions(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'showABSearchSuggestions' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showABSearchSuggestions', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->showABSearchSuggestions;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showABSearchSuggestions = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_showWSBSearchSuggestions(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showWSBSearchSuggestions;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_showWSBSearchSuggestions(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'showWSBSearchSuggestions' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showWSBSearchSuggestions', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->showWSBSearchSuggestions;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showWSBSearchSuggestions = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_defaultZoomLevel(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->defaultZoomLevel;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_defaultZoomLevel(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'defaultZoomLevel' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'defaultZoomLevel', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->defaultZoomLevel;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->defaultZoomLevel = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_loadTabsOnActivation(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->loadTabsOnActivation;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_loadTabsOnActivation(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'loadTabsOnActivation' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'loadTabsOnActivation', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->loadTabsOnActivation;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->loadTabsOnActivation = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_autoOpenProtocols(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppSelf->autoOpenProtocols);
    return pyOut;
}
static int Sbk_QzSettings_set_autoOpenProtocols(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'autoOpenProtocols' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'autoOpenProtocols', 'QStringList' or convertible type expected");
        return -1;
    }

    ::QStringList& cppOut_ptr = cppSelf->autoOpenProtocols;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_blockedProtocols(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppSelf->blockedProtocols);
    return pyOut;
}
static int Sbk_QzSettings_set_blockedProtocols(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'blockedProtocols' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'blockedProtocols', 'QStringList' or convertible type expected");
        return -1;
    }

    ::QStringList& cppOut_ptr = cppSelf->blockedProtocols;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QzSettings_get_newTabPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_QFLAGS_QZ_NEWTABPOSITIONFLAG_IDX])->converter, &cppSelf->newTabPosition);
    return pyOut;
}
static int Sbk_QzSettings_set_newTabPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'newTabPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QFLAGS_QZ_NEWTABPOSITIONFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'newTabPosition', 'NewTabPositionFlags' or convertible type expected");
        return -1;
    }

    ::QFlags<Qz::NewTabPositionFlag> cppOut_local = cppSelf->newTabPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->newTabPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_tabsOnTop(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->tabsOnTop;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_tabsOnTop(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'tabsOnTop' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tabsOnTop', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->tabsOnTop;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->tabsOnTop = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_openPopupsInTabs(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->openPopupsInTabs;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_openPopupsInTabs(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'openPopupsInTabs' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'openPopupsInTabs', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->openPopupsInTabs;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->openPopupsInTabs = cppOut_local;

    return 0;
}

static PyObject *Sbk_QzSettings_get_alwaysSwitchTabsWithWheel(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->alwaysSwitchTabsWithWheel;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QzSettings_set_alwaysSwitchTabsWithWheel(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QzSettings *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_QZSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'alwaysSwitchTabsWithWheel' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'alwaysSwitchTabsWithWheel', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->alwaysSwitchTabsWithWheel;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->alwaysSwitchTabsWithWheel = cppOut_local;

    return 0;
}

// Getters and Setters for QzSettings
static PyGetSetDef Sbk_QzSettings_getsetlist[] = {
    {const_cast<char *>("selectAllOnDoubleClick"), Sbk_QzSettings_get_selectAllOnDoubleClick, Sbk_QzSettings_set_selectAllOnDoubleClick},
    {const_cast<char *>("selectAllOnClick"), Sbk_QzSettings_get_selectAllOnClick, Sbk_QzSettings_set_selectAllOnClick},
    {const_cast<char *>("showLoadingProgress"), Sbk_QzSettings_get_showLoadingProgress, Sbk_QzSettings_set_showLoadingProgress},
    {const_cast<char *>("showLocationSuggestions"), Sbk_QzSettings_get_showLocationSuggestions, Sbk_QzSettings_set_showLocationSuggestions},
    {const_cast<char *>("showSwitchTab"), Sbk_QzSettings_get_showSwitchTab, Sbk_QzSettings_set_showSwitchTab},
    {const_cast<char *>("alwaysShowGoIcon"), Sbk_QzSettings_get_alwaysShowGoIcon, Sbk_QzSettings_set_alwaysShowGoIcon},
    {const_cast<char *>("useInlineCompletion"), Sbk_QzSettings_get_useInlineCompletion, Sbk_QzSettings_set_useInlineCompletion},
    {const_cast<char *>("searchOnEngineChange"), Sbk_QzSettings_get_searchOnEngineChange, Sbk_QzSettings_set_searchOnEngineChange},
    {const_cast<char *>("searchFromAddressBar"), Sbk_QzSettings_get_searchFromAddressBar, Sbk_QzSettings_set_searchFromAddressBar},
    {const_cast<char *>("searchWithDefaultEngine"), Sbk_QzSettings_get_searchWithDefaultEngine, Sbk_QzSettings_set_searchWithDefaultEngine},
    {const_cast<char *>("showABSearchSuggestions"), Sbk_QzSettings_get_showABSearchSuggestions, Sbk_QzSettings_set_showABSearchSuggestions},
    {const_cast<char *>("showWSBSearchSuggestions"), Sbk_QzSettings_get_showWSBSearchSuggestions, Sbk_QzSettings_set_showWSBSearchSuggestions},
    {const_cast<char *>("defaultZoomLevel"), Sbk_QzSettings_get_defaultZoomLevel, Sbk_QzSettings_set_defaultZoomLevel},
    {const_cast<char *>("loadTabsOnActivation"), Sbk_QzSettings_get_loadTabsOnActivation, Sbk_QzSettings_set_loadTabsOnActivation},
    {const_cast<char *>("autoOpenProtocols"), Sbk_QzSettings_get_autoOpenProtocols, Sbk_QzSettings_set_autoOpenProtocols},
    {const_cast<char *>("blockedProtocols"), Sbk_QzSettings_get_blockedProtocols, Sbk_QzSettings_set_blockedProtocols},
    {const_cast<char *>("newTabPosition"), Sbk_QzSettings_get_newTabPosition, Sbk_QzSettings_set_newTabPosition},
    {const_cast<char *>("tabsOnTop"), Sbk_QzSettings_get_tabsOnTop, Sbk_QzSettings_set_tabsOnTop},
    {const_cast<char *>("openPopupsInTabs"), Sbk_QzSettings_get_openPopupsInTabs, Sbk_QzSettings_set_openPopupsInTabs},
    {const_cast<char *>("alwaysSwitchTabsWithWheel"), Sbk_QzSettings_get_alwaysSwitchTabsWithWheel, Sbk_QzSettings_set_alwaysSwitchTabsWithWheel},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QzSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QzSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QzSettings_Type = nullptr;
static SbkObjectType *Sbk_QzSettings_TypeF(void)
{
    return _Sbk_QzSettings_Type;
}

static PyType_Slot Sbk_QzSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QzSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QzSettings_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QzSettings_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QzSettings_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QzSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QzSettings_spec = {
    "1:PyFalkon.QzSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QzSettings_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QzSettings_PythonToCpp_QzSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QzSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QzSettings_PythonToCpp_QzSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QzSettings_TypeF())))
        return QzSettings_PythonToCpp_QzSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QzSettings_PTR_CppToPython_QzSettings(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QzSettings *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QzSettings_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QzSettings_SignatureStrings[] = {
    "PyFalkon.QzSettings(self)",
    "PyFalkon.QzSettings.loadSettings(self)",
    "PyFalkon.QzSettings.saveSettings(self)",
    nullptr}; // Sentinel

void init_QzSettings(PyObject *module)
{
    _Sbk_QzSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QzSettings",
        "QzSettings*",
        &Sbk_QzSettings_spec,
        &Shiboken::callCppDestructor< ::QzSettings >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QzSettings_Type);
    InitSignatureStrings(pyType, QzSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QzSettings_Type), Sbk_QzSettings_PropertyStrings);
    SbkPyFalkonTypes[SBK_QZSETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QzSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QzSettings_TypeF(),
        QzSettings_PythonToCpp_QzSettings_PTR,
        is_QzSettings_PythonToCpp_QzSettings_PTR_Convertible,
        QzSettings_PTR_CppToPython_QzSettings);

    Shiboken::Conversions::registerConverterName(converter, "QzSettings");
    Shiboken::Conversions::registerConverterName(converter, "QzSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QzSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QzSettings).name());


}
