/* phone-details.c generated by valac 0.56.0, the Vala compiler
 * generated from phone-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011, 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

enum  {
	FOLKS_PHONE_FIELD_DETAILS_0_PROPERTY,
	FOLKS_PHONE_FIELD_DETAILS_ID_PROPERTY,
	FOLKS_PHONE_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_phone_field_details_properties[FOLKS_PHONE_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _FolksPhoneDetailsChangePhoneNumbersData FolksPhoneDetailsChangePhoneNumbersData;

struct _FolksPhoneFieldDetailsPrivate {
	gchar* _id;
};

struct _FolksPhoneDetailsChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPhoneDetails* self;
	GeeSet* phone_numbers;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksPhoneFieldDetails_private_offset;
static gpointer folks_phone_field_details_parent_class = NULL;

static gboolean folks_phone_field_details_real_equal (FolksAbstractFieldDetails* base,
                                               FolksAbstractFieldDetails* that);
static gboolean folks_phone_field_details_real_values_equal (FolksAbstractFieldDetails* base,
                                                      FolksAbstractFieldDetails* that);
VALA_EXTERN gchar* _folks_phone_field_details_drop_extension (const gchar* number);
static guint folks_phone_field_details_real_hash (FolksAbstractFieldDetails* base);
static gboolean _vala_char_array_contains (gchar * stack,
                                    gssize stack_length,
                                    const gchar needle);
static void folks_phone_field_details_finalize (GObject * obj);
static GType folks_phone_field_details_get_type_once (void);
static void _vala_folks_phone_field_details_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_folks_phone_field_details_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void folks_phone_details_real_change_phone_numbers_data_free (gpointer _data);
static void folks_phone_details_real_change_phone_numbers (FolksPhoneDetails* self,
                                                    GeeSet* phone_numbers,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean folks_phone_details_real_change_phone_numbers_co (FolksPhoneDetailsChangePhoneNumbersData* _data_);
static GType folks_phone_details_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar FOLKS_PHONE_FIELD_DETAILS__extension_chars[6] = {'p', 'P', 'w', 'W', 'x', 'X'};
static const gchar FOLKS_PHONE_FIELD_DETAILS__common_delimiters[8] = {',', '.', '(', ')', '-', ' ', '\t', '/'};
static const gchar FOLKS_PHONE_FIELD_DETAILS__valid_digits[12] = {'#', '*', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

static inline gpointer
folks_phone_field_details_get_instance_private (FolksPhoneFieldDetails* self)
{
	return G_STRUCT_MEMBER_P (self, FolksPhoneFieldDetails_private_offset);
}

/**
   * Create a new PhoneFieldDetails.
   *
   * @param value the value of the field, which should be a non-empty phone
   * number (no particular format is mandated)
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   * @return a new PhoneFieldDetails
   *
   * @since 0.6.0
   */
FolksPhoneFieldDetails*
folks_phone_field_details_construct (GType object_type,
                                     const gchar* value,
                                     GeeMultiMap* parameters)
{
	FolksPhoneFieldDetails * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	if (g_strcmp0 (value, "") == 0) {
		g_warning ("phone-details.vala:72: Empty phone number passed to PhoneFieldDetails.");
	}
	self = (FolksPhoneFieldDetails*) g_object_new (object_type, "t-type", G_TYPE_STRING, "t-dup-func", (GBoxedCopyFunc) g_strdup, "t-destroy-func", (GDestroyNotify) g_free, "value", value, "parameters", parameters, NULL);
	return self;
}

FolksPhoneFieldDetails*
folks_phone_field_details_new (const gchar* value,
                               GeeMultiMap* parameters)
{
	return folks_phone_field_details_construct (FOLKS_TYPE_PHONE_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_phone_field_details_real_equal (FolksAbstractFieldDetails* base,
                                      FolksAbstractFieldDetails* that)
{
	FolksPhoneFieldDetails * self;
	gboolean result;
	self = (FolksPhoneFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_phone_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that);
	return result;
}

/**
   * {@inheritDoc}
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
folks_phone_field_details_real_values_equal (FolksAbstractFieldDetails* base,
                                             FolksAbstractFieldDetails* that)
{
	FolksPhoneFieldDetails * self;
	FolksPhoneFieldDetails* _that_fd = NULL;
	FolksPhoneFieldDetails* _tmp0_;
	FolksPhoneFieldDetails* _tmp1_;
	FolksPhoneFieldDetails* that_fd = NULL;
	FolksPhoneFieldDetails* _tmp2_;
	FolksPhoneFieldDetails* _tmp3_;
	gchar* n1 = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* n2 = NULL;
	FolksPhoneFieldDetails* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gboolean result;
	self = (FolksPhoneFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (FOLKS_IS_PHONE_FIELD_DETAILS (that) ? ((FolksPhoneFieldDetails*) that) : NULL);
	_that_fd = _tmp0_;
	_tmp1_ = _that_fd;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (_that_fd);
		return result;
	}
	_tmp2_ = _that_fd;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails));
	that_fd = _tmp3_;
	_tmp4_ = folks_phone_field_details_get_normalised (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _folks_phone_field_details_drop_extension (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	n1 = _tmp7_;
	_tmp8_ = that_fd;
	_tmp9_ = folks_phone_field_details_get_normalised (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _folks_phone_field_details_drop_extension (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	n2 = _tmp12_;
	_tmp14_ = n1;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ >= 7) {
		const gchar* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp17_ = n2;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_ >= 7;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* n1_reduced = NULL;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_;
		gchar* n2_reduced = NULL;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp20_ = n1;
		_tmp21_ = n1;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_slice (_tmp20_, (glong) -7, (glong) _tmp23_);
		n1_reduced = _tmp24_;
		_tmp25_ = n2;
		_tmp26_ = n2;
		_tmp27_ = strlen (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = string_slice (_tmp25_, (glong) -7, (glong) _tmp28_);
		n2_reduced = _tmp29_;
		_tmp30_ = n1_reduced;
		_tmp31_ = n2_reduced;
		g_debug ("phone-details.vala:108: [PhoneDetails.equal] Comparing %s with %s", _tmp30_, _tmp31_);
		_tmp32_ = n1_reduced;
		_tmp33_ = n2_reduced;
		result = g_strcmp0 (_tmp32_, _tmp33_) == 0;
		_g_free0 (n2_reduced);
		_g_free0 (n1_reduced);
		_g_free0 (n2);
		_g_free0 (n1);
		_g_object_unref0 (that_fd);
		_g_object_unref0 (_that_fd);
		return result;
	}
	_tmp34_ = n1;
	_tmp35_ = n2;
	result = g_strcmp0 (_tmp34_, _tmp35_) == 0;
	_g_free0 (n2);
	_g_free0 (n1);
	_g_object_unref0 (that_fd);
	_g_object_unref0 (_that_fd);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_phone_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksPhoneFieldDetails * self;
	guint result;
	self = (FolksPhoneFieldDetails*) base;
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_phone_field_details_parent_class)->hash (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	return result;
}

/**
   * Return this object's normalised phone number.
   *
   * Typical normalisations:
   *
   *  - ``1-800-123-4567`` → ``18001234567``
   *  - ``+1-800-123-4567`` → ``+18001234567``
   *  - ``+1-800-123-4567P123`` → ``+18001234567P123``
   *
   * @return the normalised form of ``number``
   *
   * @since 0.6.0
   */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
_vala_char_array_contains (gchar * stack,
                           gssize stack_length,
                           const gchar needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

gchar*
folks_phone_field_details_get_normalised (FolksPhoneFieldDetails* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gconstpointer _tmp3_;
				gconstpointer _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gchar digit = '\0';
				gconstpointer _tmp7_;
				gconstpointer _tmp8_;
				GString* _tmp21_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = strlen ((const gchar*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < ((guint) _tmp6_))) {
					break;
				}
				_tmp7_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
				_tmp8_ = _tmp7_;
				digit = string_get ((const gchar*) _tmp8_, (glong) i);
				if (_vala_char_array_contains (FOLKS_PHONE_FIELD_DETAILS__extension_chars, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__extension_chars), digit)) {
					digit = g_ascii_toupper (digit);
				} else {
					if (digit == '+') {
						gboolean _tmp9_ = FALSE;
						gboolean _tmp10_ = FALSE;
						GString* _tmp11_;
						const gchar* _tmp12_;
						_tmp11_ = builder;
						_tmp12_ = _tmp11_->str;
						if (g_strcmp0 (_tmp12_, "") != 0) {
							GString* _tmp13_;
							const gchar* _tmp14_;
							_tmp13_ = builder;
							_tmp14_ = _tmp13_->str;
							_tmp10_ = g_strcmp0 (_tmp14_, "*31#") != 0;
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							GString* _tmp15_;
							const gchar* _tmp16_;
							_tmp15_ = builder;
							_tmp16_ = _tmp15_->str;
							_tmp9_ = g_strcmp0 (_tmp16_, "#31#") != 0;
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							gconstpointer _tmp17_;
							gconstpointer _tmp18_;
							_tmp17_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
							_tmp18_ = _tmp17_;
							g_debug ("phone-details.vala:164: [PhoneDetails.get_normalised] Wrong '+' in %s", (const gchar*) _tmp18_);
							continue;
						}
					} else {
						if (_vala_char_array_contains (FOLKS_PHONE_FIELD_DETAILS__common_delimiters, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__common_delimiters), digit)) {
							continue;
						} else {
							if (_vala_char_array_contains (FOLKS_PHONE_FIELD_DETAILS__valid_digits, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__valid_digits), digit)) {
							} else {
								gconstpointer _tmp19_;
								gconstpointer _tmp20_;
								_tmp19_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
								_tmp20_ = _tmp19_;
								g_debug ("phone-details.vala:181: [PhoneDetails.get_normalised] Unknown characte" \
"r '%c' in '%s'", (gint) digit, (const gchar*) _tmp20_);
							}
						}
					}
				}
				_tmp21_ = builder;
				g_string_append_c (_tmp21_, digit);
			}
		}
	}
	_tmp22_ = builder;
	_tmp23_ = _tmp22_->str;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	_g_string_free0 (builder);
	return result;
}

/**
   * Returns the given number without its extension (if any).
   *
   * @param number the phone number to process
   * @return the number without its extension; if the number didn't have an
   * extension in the first place, the number is returned unmodified
   *
   * @since 0.6.0
   */
gchar*
_folks_phone_field_details_drop_extension (const gchar* number)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gchar digit = '\0';
				GString* _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = strlen (number);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				digit = string_get (number, (glong) i);
				if (_vala_char_array_contains (FOLKS_PHONE_FIELD_DETAILS__extension_chars, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__extension_chars), digit)) {
					break;
				}
				_tmp5_ = builder;
				g_string_append_c (_tmp5_, digit);
			}
		}
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_string_free0 (builder);
	return result;
}

static const gchar*
folks_phone_field_details_real_get_id (FolksAbstractFieldDetails* base)
{
	const gchar* result;
	FolksPhoneFieldDetails* self;
	const gchar* _tmp0_;
	self = (FolksPhoneFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
folks_phone_field_details_real_set_id (FolksAbstractFieldDetails* base,
                                       const gchar* value)
{
	FolksPhoneFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (FolksPhoneFieldDetails*) base;
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_phone_field_details_properties[FOLKS_PHONE_FIELD_DETAILS_ID_PROPERTY]);
}

static void
folks_phone_field_details_class_init (FolksPhoneFieldDetailsClass * klass,
                                      gpointer klass_data)
{
	folks_phone_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksPhoneFieldDetails_private_offset);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_phone_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->values_equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_phone_field_details_real_values_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_phone_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = folks_phone_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = folks_phone_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_phone_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_phone_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_phone_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PHONE_FIELD_DETAILS_ID_PROPERTY, folks_phone_field_details_properties[FOLKS_PHONE_FIELD_DETAILS_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
folks_phone_field_details_instance_init (FolksPhoneFieldDetails * self,
                                         gpointer klass)
{
	self->priv = folks_phone_field_details_get_instance_private (self);
}

static void
folks_phone_field_details_finalize (GObject * obj)
{
	FolksPhoneFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_phone_field_details_parent_class)->finalize (obj);
}

/**
 * Object representing a phone number that can have some parameters associated
 * with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
static GType
folks_phone_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPhoneFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_phone_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPhoneFieldDetails), 0, (GInstanceInitFunc) folks_phone_field_details_instance_init, NULL };
	GType folks_phone_field_details_type_id;
	folks_phone_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksPhoneFieldDetails", &g_define_type_info, 0);
	FolksPhoneFieldDetails_private_offset = g_type_add_instance_private (folks_phone_field_details_type_id, sizeof (FolksPhoneFieldDetailsPrivate));
	return folks_phone_field_details_type_id;
}

GType
folks_phone_field_details_get_type (void)
{
	static volatile gsize folks_phone_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_phone_field_details_type_id__once)) {
		GType folks_phone_field_details_type_id;
		folks_phone_field_details_type_id = folks_phone_field_details_get_type_once ();
		g_once_init_leave (&folks_phone_field_details_type_id__once, folks_phone_field_details_type_id);
	}
	return folks_phone_field_details_type_id__once;
}

static void
_vala_folks_phone_field_details_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	FolksPhoneFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails);
	switch (property_id) {
		case FOLKS_PHONE_FIELD_DETAILS_ID_PROPERTY:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_phone_field_details_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	FolksPhoneFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails);
	switch (property_id) {
		case FOLKS_PHONE_FIELD_DETAILS_ID_PROPERTY:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
folks_phone_details_real_change_phone_numbers_data_free (gpointer _data)
{
	FolksPhoneDetailsChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPhoneDetailsChangePhoneNumbersData, _data_);
}

static void
folks_phone_details_real_change_phone_numbers (FolksPhoneDetails* self,
                                               GeeSet* phone_numbers,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	FolksPhoneDetailsChangePhoneNumbersData* _data_;
	FolksPhoneDetails* _tmp0_;
	GeeSet* _tmp1_;
	g_return_if_fail (phone_numbers != NULL);
	_data_ = g_slice_new0 (FolksPhoneDetailsChangePhoneNumbersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_phone_details_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (phone_numbers);
	_g_object_unref0 (_data_->phone_numbers);
	_data_->phone_numbers = _tmp1_;
	folks_phone_details_real_change_phone_numbers_co (_data_);
}

static void
folks_phone_details_real_change_phone_numbers_finish (FolksPhoneDetails* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	FolksPhoneDetailsChangePhoneNumbersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's phone numbers.
   *
   * It's preferred to call this rather than setting
   * {@link PhoneDetails.phone_numbers} directly, as this method gives error
   * notification and will only return once the phone numbers have been written
   * to the relevant backing store (or the operation's failed).
   *
   * @param phone_numbers the set of phone numbers
   * @throws PropertyError if setting the phone numbers failed
   * @since 0.6.2
   */
static gboolean
folks_phone_details_real_change_phone_numbers_co (FolksPhoneDetailsChangePhoneNumbersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Phone numbers are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_phone_details_change_phone_numbers (FolksPhoneDetails* self,
                                          GeeSet* phone_numbers,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	FolksPhoneDetailsIface* _iface_;
	_iface_ = FOLKS_PHONE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_phone_numbers) {
		_iface_->change_phone_numbers (self, phone_numbers, _callback_, _user_data_);
	}
}

void
folks_phone_details_change_phone_numbers_finish (FolksPhoneDetails* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	FolksPhoneDetailsIface* _iface_;
	_iface_ = FOLKS_PHONE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_phone_numbers_finish) {
		_iface_->change_phone_numbers_finish (self, _res_, error);
	}
}

GeeSet*
folks_phone_details_get_phone_numbers (FolksPhoneDetails* self)
{
	FolksPhoneDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_PHONE_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_phone_numbers) {
		return _iface_->get_phone_numbers (self);
	}
	return NULL;
}

void
folks_phone_details_set_phone_numbers (FolksPhoneDetails* self,
                                       GeeSet* value)
{
	FolksPhoneDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_PHONE_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_phone_numbers) {
		_iface_->set_phone_numbers (self, value);
	}
}

static void
folks_phone_details_default_init (FolksPhoneDetailsIface * iface,
                                  gpointer iface_data)
{
	/**
	   * The phone numbers of the contact.
	   *
	   * A list of phone numbers associated to the contact.
	   *
	   * @since 0.6.0
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_phone_numbers = folks_phone_details_real_change_phone_numbers;
	iface->change_phone_numbers_finish = folks_phone_details_real_change_phone_numbers_finish;
}

/**
 * Interface for classes that can provide a phone number, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
static GType
folks_phone_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPhoneDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_phone_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_phone_details_type_id;
	folks_phone_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPhoneDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_phone_details_type_id, G_TYPE_OBJECT);
	return folks_phone_details_type_id;
}

GType
folks_phone_details_get_type (void)
{
	static volatile gsize folks_phone_details_type_id__once = 0;
	if (g_once_init_enter (&folks_phone_details_type_id__once)) {
		GType folks_phone_details_type_id;
		folks_phone_details_type_id = folks_phone_details_get_type_once ();
		g_once_init_leave (&folks_phone_details_type_id__once, folks_phone_details_type_id);
	}
	return folks_phone_details_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

