<?php

namespace Drupal\Core\Routing;

use Symfony\Component\Routing\RouteCollection;

/**
 * Does not dump Route information.
 */
class NullMatcherDumper implements MatcherDumperInterface {

  /**
   * The routes to be dumped.
   *
   * @var \Symfony\Component\Routing\RouteCollection
   */
  protected $routes;

  /**
   * {@inheritdoc}
   */
  public function addRoutes(RouteCollection $routes) {
    if (empty($this->routes)) {
      $this->routes = $routes;
    }
    else {
      $this->routes->addCollection($routes);
    }
  }

  /**
   * Dumps a set of routes to the router table in the database.
   *
   * Available options:
   * - provider: The route grouping that is being dumped. All existing
   *   routes with this provider will be deleted on dump.
   * - base_class: The base class name.
   *
   * @param array $options
   *   An array of options.
   */
  public function dump(array $options = []): string {
    // The dumper is reused for multiple providers, so reset the queued routes.
    $this->routes = NULL;
    return '';
  }

  /**
   * Gets the routes to match.
   *
   * @return \Symfony\Component\Routing\RouteCollection
   *   A RouteCollection instance representing all routes currently in the
   *   dumper.
   */
  public function getRoutes(): RouteCollection {
    return $this->routes;
  }

}
