/* plugin-folder-store.c generated by valac 0.56.3, the Vala compiler
 * generated from plugin-folder-store.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	PLUGIN_FOLDER_STORE_FOLDERS_AVAILABLE_SIGNAL,
	PLUGIN_FOLDER_STORE_FOLDERS_UNAVAILABLE_SIGNAL,
	PLUGIN_FOLDER_STORE_FOLDERS_TYPE_CHANGED_SIGNAL,
	PLUGIN_FOLDER_STORE_FOLDER_SELECTED_SIGNAL,
	PLUGIN_FOLDER_STORE_NUM_SIGNALS
};
static guint plugin_folder_store_signals[PLUGIN_FOLDER_STORE_NUM_SIGNALS] = {0};

static GType plugin_folder_store_get_type_once (void);

const GVariantType*
plugin_folder_store_get_folder_variant_type (PluginFolderStore* self)
{
	PluginFolderStoreIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER_STORE (self), NULL);
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->get_folder_variant_type) {
		return _iface_->get_folder_variant_type (self);
	}
	return NULL;
}

/** Returns a read-only set of all known folders. */
GeeCollection*
plugin_folder_store_get_folders (PluginFolderStore* self)
{
	PluginFolderStoreIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER_STORE (self), NULL);
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->get_folders) {
		return _iface_->get_folders (self);
	}
	return NULL;
}

void
plugin_folder_store_list_containing_folders (PluginFolderStore* self,
                                             PluginEmailIdentifier* target,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	PluginFolderStoreIface* _iface_;
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->list_containing_folders) {
		_iface_->list_containing_folders (self, target, cancellable, _callback_, _user_data_);
	}
}

GeeCollection*
plugin_folder_store_list_containing_folders_finish (PluginFolderStore* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	PluginFolderStoreIface* _iface_;
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->list_containing_folders_finish) {
		return _iface_->list_containing_folders_finish (self, _res_, error);
	}
	return NULL;
}

void
plugin_folder_store_create_personal_folder (PluginFolderStore* self,
                                            PluginAccount* target,
                                            const gchar* name,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	PluginFolderStoreIface* _iface_;
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->create_personal_folder) {
		_iface_->create_personal_folder (self, target, name, cancellable, _callback_, _user_data_);
	}
}

PluginFolder*
plugin_folder_store_create_personal_folder_finish (PluginFolderStore* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	PluginFolderStoreIface* _iface_;
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->create_personal_folder_finish) {
		return _iface_->create_personal_folder_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Returns the folder specified by the given variant, if any.
     *
     * @see Folder.to_variant
     * @see folder_variant_type
     */
PluginFolder*
plugin_folder_store_get_folder_for_variant (PluginFolderStore* self,
                                            GVariant* id)
{
	PluginFolderStoreIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_FOLDER_STORE (self), NULL);
	_iface_ = PLUGIN_FOLDER_STORE_GET_INTERFACE (self);
	if (_iface_->get_folder_for_variant) {
		return _iface_->get_folder_for_variant (self, id);
	}
	return NULL;
}

static void
plugin_folder_store_default_init (PluginFolderStoreIface * iface,
                                  gpointer iface_data)
{
	/**
	     * The type of variant folder identifiers.
	     *
	     * @see Folder.to_variant
	     * @see get_folder_for_variant
	     */
	g_object_interface_install_property (iface, g_param_spec_boxed ("folder-variant-type", "folder-variant-type", "folder-variant-type", G_TYPE_VARIANT_TYPE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Emitted when new folders are available. */
	plugin_folder_store_signals[PLUGIN_FOLDER_STORE_FOLDERS_AVAILABLE_SIGNAL] = g_signal_new ("folders-available", PLUGIN_TYPE_FOLDER_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/** Emitted when existing folders have become unavailable. */
	plugin_folder_store_signals[PLUGIN_FOLDER_STORE_FOLDERS_UNAVAILABLE_SIGNAL] = g_signal_new ("folders-unavailable", PLUGIN_TYPE_FOLDER_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/** Emitted when existing folders have become unavailable. */
	plugin_folder_store_signals[PLUGIN_FOLDER_STORE_FOLDERS_TYPE_CHANGED_SIGNAL] = g_signal_new ("folders-type-changed", PLUGIN_TYPE_FOLDER_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/** Emitted when a folder has been selected in any main window. */
	plugin_folder_store_signals[PLUGIN_FOLDER_STORE_FOLDER_SELECTED_SIGNAL] = g_signal_new ("folder-selected", PLUGIN_TYPE_FOLDER_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLUGIN_TYPE_FOLDER);
}

/**
 * Provides plugins with access to folders.
 *
 * Plugins that implement the {@link FolderExtension} interface may
 * obtain instances of this object by calling {@link
 * FolderContext.get_folder_store} on their {@link
 * FolderExtension.folders} property.
 */
static GType
plugin_folder_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginFolderStoreIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_folder_store_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_folder_store_type_id;
	plugin_folder_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginFolderStore", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_folder_store_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_folder_store_type_id;
}

GType
plugin_folder_store_get_type (void)
{
	static volatile gsize plugin_folder_store_type_id__once = 0;
	if (g_once_init_enter (&plugin_folder_store_type_id__once)) {
		GType plugin_folder_store_type_id;
		plugin_folder_store_type_id = plugin_folder_store_get_type_once ();
		g_once_init_leave (&plugin_folder_store_type_id__once, plugin_folder_store_type_id);
	}
	return plugin_folder_store_type_id__once;
}

