/* imap-fetched-data.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-fetched-data.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_FETCHED_DATA_0_PROPERTY,
	GEARY_IMAP_FETCHED_DATA_SEQ_NUM_PROPERTY,
	GEARY_IMAP_FETCHED_DATA_DATA_MAP_PROPERTY,
	GEARY_IMAP_FETCHED_DATA_BODY_DATA_MAP_PROPERTY,
	GEARY_IMAP_FETCHED_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _GearyImapFetchedDataPrivate {
	GearyImapSequenceNumber* _seq_num;
	GeeMap* _data_map;
	GeeMap* _body_data_map;
};

static gint GearyImapFetchedData_private_offset;
static gpointer geary_imap_fetched_data_parent_class = NULL;

static void geary_imap_fetched_data_set_seq_num (GearyImapFetchedData* self,
                                          GearyImapSequenceNumber* value);
static void geary_imap_fetched_data_set_data_map (GearyImapFetchedData* self,
                                           GeeMap* value);
static void geary_imap_fetched_data_set_body_data_map (GearyImapFetchedData* self,
                                                GeeMap* value);
static void geary_imap_fetched_data_finalize (GObject * obj);
static GType geary_imap_fetched_data_get_type_once (void);
static void _vala_geary_imap_fetched_data_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_imap_fetched_data_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
geary_imap_fetched_data_get_instance_private (GearyImapFetchedData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapFetchedData_private_offset);
}

GearyImapSequenceNumber*
geary_imap_fetched_data_get_seq_num (GearyImapFetchedData* self)
{
	GearyImapSequenceNumber* result;
	GearyImapSequenceNumber* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self), NULL);
	_tmp0_ = self->priv->_seq_num;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_fetched_data_set_seq_num (GearyImapFetchedData* self,
                                     GearyImapSequenceNumber* value)
{
	GearyImapSequenceNumber* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self));
	old_value = geary_imap_fetched_data_get_seq_num (self);
	if (old_value != value) {
		GearyImapSequenceNumber* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_seq_num);
		self->priv->_seq_num = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_SEQ_NUM_PROPERTY]);
	}
}

GeeMap*
geary_imap_fetched_data_get_data_map (GearyImapFetchedData* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self), NULL);
	_tmp0_ = self->priv->_data_map;
	result = _tmp0_;
	return result;
}

static void
geary_imap_fetched_data_set_data_map (GearyImapFetchedData* self,
                                      GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self));
	old_value = geary_imap_fetched_data_get_data_map (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_map);
		self->priv->_data_map = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_DATA_MAP_PROPERTY]);
	}
}

GeeMap*
geary_imap_fetched_data_get_body_data_map (GearyImapFetchedData* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self), NULL);
	_tmp0_ = self->priv->_body_data_map;
	result = _tmp0_;
	return result;
}

static void
geary_imap_fetched_data_set_body_data_map (GearyImapFetchedData* self,
                                           GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self));
	old_value = geary_imap_fetched_data_get_body_data_map (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_body_data_map);
		self->priv->_body_data_map = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_BODY_DATA_MAP_PROPERTY]);
	}
}

GearyImapFetchedData*
geary_imap_fetched_data_construct (GType object_type,
                                   GearyImapSequenceNumber* seq_num)
{
	GearyImapFetchedData * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (seq_num), NULL);
	self = (GearyImapFetchedData*) g_object_new (object_type, NULL);
	geary_imap_fetched_data_set_seq_num (self, seq_num);
	return self;
}

GearyImapFetchedData*
geary_imap_fetched_data_new (GearyImapSequenceNumber* seq_num)
{
	return geary_imap_fetched_data_construct (GEARY_IMAP_TYPE_FETCHED_DATA, seq_num);
}

/**
     * Decodes {@link ServerData} into a FetchedData representation.
     *
     * The ServerData must be the response to a FETCH or STORE command.
     *
     * @see FetchCommand
     * @see StoreCommand
     * @see ServerData.get_fetch
     */
GearyImapFetchedData*
geary_imap_fetched_data_decode (GearyImapServerData* server_data,
                                GError** error)
{
	GearyImapStringParameter* _tmp0_ = NULL;
	GearyImapStringParameter* _tmp1_;
	GearyImapStringParameter* _tmp6_ = NULL;
	GearyImapStringParameter* _tmp7_;
	gint64 _tmp8_ = 0LL;
	GearyImapSequenceNumber* _tmp9_ = NULL;
	GearyImapSequenceNumber* _tmp10_;
	GearyImapFetchedData* fetched_data = NULL;
	GearyImapFetchedData* _tmp11_;
	GearyImapListParameter* list = NULL;
	GearyImapListParameter* _tmp12_;
	GError* _inner_error0_ = NULL;
	GearyImapFetchedData* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (server_data), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_imap_string_parameter_equals_ci (_tmp0_, GEARY_IMAP_FETCH_COMMAND_NAME)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Not FETCH data: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_string_parameter_as_int64 (_tmp6_, G_MININT64, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = geary_imap_sequence_number_new_checked (_tmp8_, &_inner_error0_);
	_tmp9_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = geary_imap_fetched_data_new (_tmp9_);
	fetched_data = _tmp11_;
	_tmp12_ = geary_imap_list_parameter_get_as_list (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 3, &_inner_error0_);
	list = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (fetched_data);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (fetched_data);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GearyImapListParameter* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				GearyImapStringParameter* data_item_param = NULL;
				GearyImapListParameter* _tmp17_;
				GearyImapStringParameter* _tmp18_;
				gboolean has_value = FALSE;
				GearyImapListParameter* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				GearyImapStringParameter* _tmp22_;
				if (!_tmp13_) {
					ctr += 2;
				}
				_tmp13_ = FALSE;
				_tmp14_ = list;
				_tmp15_ = geary_imap_list_parameter_get_size (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(ctr < _tmp16_)) {
					break;
				}
				_tmp17_ = list;
				_tmp18_ = geary_imap_list_parameter_get_as_string (_tmp17_, ctr, &_inner_error0_);
				data_item_param = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (list);
						_g_object_unref0 (fetched_data);
						_g_object_unref0 (_tmp9_);
						_g_object_unref0 (_tmp6_);
						_g_object_unref0 (_tmp0_);
						return NULL;
					} else {
						_g_object_unref0 (list);
						_g_object_unref0 (fetched_data);
						_g_object_unref0 (_tmp9_);
						_g_object_unref0 (_tmp6_);
						_g_object_unref0 (_tmp0_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp19_ = list;
				_tmp20_ = geary_imap_list_parameter_get_size (_tmp19_);
				_tmp21_ = _tmp20_;
				has_value = ctr < (_tmp21_ - 1);
				_tmp22_ = data_item_param;
				if (geary_imap_fetch_body_data_specifier_is_fetch_body_data_specifier (_tmp22_)) {
					GearyImapFetchBodyDataSpecifier* specifier = NULL;
					GearyImapStringParameter* _tmp23_;
					GearyImapFetchBodyDataSpecifier* _tmp24_;
					_tmp23_ = data_item_param;
					_tmp24_ = geary_imap_fetch_body_data_specifier_deserialize_response (_tmp23_, &_inner_error0_);
					specifier = _tmp24_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (data_item_param);
							_g_object_unref0 (list);
							_g_object_unref0 (fetched_data);
							_g_object_unref0 (_tmp9_);
							_g_object_unref0 (_tmp6_);
							_g_object_unref0 (_tmp0_);
							return NULL;
						} else {
							_g_object_unref0 (data_item_param);
							_g_object_unref0 (list);
							_g_object_unref0 (fetched_data);
							_g_object_unref0 (_tmp9_);
							_g_object_unref0 (_tmp6_);
							_g_object_unref0 (_tmp0_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (has_value) {
						GearyMemoryBuffer* _tmp25_ = NULL;
						GearyImapListParameter* _tmp26_;
						GearyMemoryBuffer* _tmp27_;
						GearyImapFetchedData* _tmp28_;
						GeeMap* _tmp29_;
						GearyImapFetchBodyDataSpecifier* _tmp30_;
						_tmp26_ = list;
						_tmp27_ = geary_imap_list_parameter_get_as_empty_buffer (_tmp26_, ctr + 1, &_inner_error0_);
						_tmp25_ = _tmp27_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (specifier);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								return NULL;
							} else {
								_g_object_unref0 (specifier);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp28_ = fetched_data;
						_tmp29_ = _tmp28_->priv->_body_data_map;
						_tmp30_ = specifier;
						gee_map_set (_tmp29_, _tmp30_, _tmp25_);
						_g_object_unref0 (_tmp25_);
					} else {
						GearyImapFetchedData* _tmp31_;
						GeeMap* _tmp32_;
						GearyImapFetchBodyDataSpecifier* _tmp33_;
						GearyMemoryEmptyBuffer* _tmp34_;
						GearyMemoryEmptyBuffer* _tmp35_;
						_tmp31_ = fetched_data;
						_tmp32_ = _tmp31_->priv->_body_data_map;
						_tmp33_ = specifier;
						_tmp34_ = geary_memory_empty_buffer_get_instance ();
						_tmp35_ = _tmp34_;
						gee_map_set (_tmp32_, _tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
					}
					_g_object_unref0 (specifier);
				} else {
					GearyImapFetchDataSpecifier data_item = 0;
					GearyImapStringParameter* _tmp36_;
					GearyImapFetchDataDecoder* decoder = NULL;
					GearyImapQuirks* _tmp37_;
					GearyImapQuirks* _tmp38_;
					GearyImapFetchDataDecoder* _tmp39_;
					GearyImapFetchDataDecoder* _tmp40_;
					_tmp36_ = data_item_param;
					data_item = geary_imap_fetch_data_specifier_from_parameter (_tmp36_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (data_item_param);
							_g_object_unref0 (list);
							_g_object_unref0 (fetched_data);
							_g_object_unref0 (_tmp9_);
							_g_object_unref0 (_tmp6_);
							_g_object_unref0 (_tmp0_);
							return NULL;
						} else {
							_g_object_unref0 (data_item_param);
							_g_object_unref0 (list);
							_g_object_unref0 (fetched_data);
							_g_object_unref0 (_tmp9_);
							_g_object_unref0 (_tmp6_);
							_g_object_unref0 (_tmp0_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp37_ = geary_imap_server_response_get_quirks (G_TYPE_CHECK_INSTANCE_CAST (server_data, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse));
					_tmp38_ = _tmp37_;
					_tmp39_ = geary_imap_fetch_data_specifier_get_decoder (data_item, _tmp38_);
					decoder = _tmp39_;
					_tmp40_ = decoder;
					if (_tmp40_ == NULL) {
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp41_ = geary_imap_fetch_data_specifier_to_string (data_item);
						_tmp42_ = _tmp41_;
						g_debug ("imap-fetched-data.vala:78: Unable to decode fetch response for \"%s\":" \
" No decoder available", _tmp42_);
						_g_free0 (_tmp42_);
						_g_object_unref0 (decoder);
						_g_object_unref0 (data_item_param);
						continue;
					}
					if (has_value) {
						GearyImapParameter* _tmp43_ = NULL;
						GearyImapListParameter* _tmp44_;
						GearyImapParameter* _tmp45_;
						GearyImapMessageData* _tmp46_ = NULL;
						GearyImapFetchDataDecoder* _tmp47_;
						GearyImapMessageData* _tmp48_;
						GearyImapFetchedData* _tmp49_;
						GeeMap* _tmp50_;
						_tmp44_ = list;
						_tmp45_ = geary_imap_list_parameter_get_required (_tmp44_, ctr + 1, &_inner_error0_);
						_tmp43_ = _tmp45_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (decoder);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								return NULL;
							} else {
								_g_object_unref0 (decoder);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp47_ = decoder;
						_tmp48_ = geary_imap_fetch_data_decoder_decode (_tmp47_, _tmp43_, &_inner_error0_);
						_tmp46_ = _tmp48_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (_tmp43_);
								_g_object_unref0 (decoder);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								return NULL;
							} else {
								_g_object_unref0 (_tmp43_);
								_g_object_unref0 (decoder);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp49_ = fetched_data;
						_tmp50_ = _tmp49_->priv->_data_map;
						gee_map_set (_tmp50_, (gpointer) ((gintptr) data_item), _tmp46_);
						_g_object_unref0 (_tmp46_);
						_g_object_unref0 (_tmp43_);
					} else {
						GearyImapMessageData* _tmp51_ = NULL;
						GearyImapFetchDataDecoder* _tmp52_;
						GearyImapNilParameter* _tmp53_;
						GearyImapNilParameter* _tmp54_;
						GearyImapMessageData* _tmp55_;
						GearyImapFetchedData* _tmp56_;
						GeeMap* _tmp57_;
						_tmp52_ = decoder;
						_tmp53_ = geary_imap_nil_parameter_get_instance ();
						_tmp54_ = _tmp53_;
						_tmp55_ = geary_imap_fetch_data_decoder_decode (_tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter), &_inner_error0_);
						_tmp51_ = _tmp55_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (decoder);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								return NULL;
							} else {
								_g_object_unref0 (decoder);
								_g_object_unref0 (data_item_param);
								_g_object_unref0 (list);
								_g_object_unref0 (fetched_data);
								_g_object_unref0 (_tmp9_);
								_g_object_unref0 (_tmp6_);
								_g_object_unref0 (_tmp0_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp56_ = fetched_data;
						_tmp57_ = _tmp56_->priv->_data_map;
						gee_map_set (_tmp57_, (gpointer) ((gintptr) data_item), _tmp51_);
						_g_object_unref0 (_tmp51_);
					}
					_g_object_unref0 (decoder);
				}
				_g_object_unref0 (data_item_param);
			}
		}
	}
	result = fetched_data;
	_g_object_unref0 (list);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Returns the merge of this {@link FetchedData} and the supplied one.
     *
     * The results are undefined if both FetchData objects contain the same
     * {@link FetchDataSpecifier} or {@link FetchBodyDataSpecifier}s.
     *
     * See warnings at {@link body_data_map} for dealing with multiple FetchBodyDataSpecifiers.
     *
     * @return null if the FetchedData do not have the same {@link seq_num}.
     */
GearyImapFetchedData*
geary_imap_fetched_data_combine (GearyImapFetchedData* self,
                                 GearyImapFetchedData* other)
{
	GearyImapSequenceNumber* _tmp0_;
	GearyImapSequenceNumber* _tmp1_;
	GearyImapFetchedData* combined = NULL;
	GearyImapSequenceNumber* _tmp2_;
	GearyImapFetchedData* _tmp3_;
	GearyImapFetchedData* _tmp4_;
	GeeMap* _tmp5_;
	GeeMap* _tmp6_;
	GearyImapFetchedData* _tmp7_;
	GeeMap* _tmp8_;
	GeeMap* _tmp9_;
	GearyImapFetchedData* _tmp10_;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GearyImapFetchedData* _tmp13_;
	GeeMap* _tmp14_;
	GeeMap* _tmp15_;
	GearyImapFetchedData* result;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (other), NULL);
	_tmp0_ = self->priv->_seq_num;
	_tmp1_ = other->priv->_seq_num;
	if (!geary_message_data_int64_message_data_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData))) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->_seq_num;
	_tmp3_ = geary_imap_fetched_data_new (_tmp2_);
	combined = _tmp3_;
	_tmp4_ = combined;
	_tmp5_ = _tmp4_->priv->_data_map;
	_tmp6_ = self->priv->_data_map;
	geary_collection_map_set_all (GEARY_IMAP_TYPE_FETCH_DATA_SPECIFIER, NULL, NULL, GEARY_IMAP_TYPE_MESSAGE_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_, _tmp6_);
	_tmp7_ = combined;
	_tmp8_ = _tmp7_->priv->_data_map;
	_tmp9_ = other->priv->_data_map;
	geary_collection_map_set_all (GEARY_IMAP_TYPE_FETCH_DATA_SPECIFIER, NULL, NULL, GEARY_IMAP_TYPE_MESSAGE_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp8_, _tmp9_);
	_tmp10_ = combined;
	_tmp11_ = _tmp10_->priv->_body_data_map;
	_tmp12_ = self->priv->_body_data_map;
	geary_collection_map_set_all (GEARY_IMAP_TYPE_FETCH_BODY_DATA_SPECIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp11_, _tmp12_);
	_tmp13_ = combined;
	_tmp14_ = _tmp13_->priv->_body_data_map;
	_tmp15_ = other->priv->_body_data_map;
	geary_collection_map_set_all (GEARY_IMAP_TYPE_FETCH_BODY_DATA_SPECIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp14_, _tmp15_);
	result = combined;
	return result;
}

gchar*
geary_imap_fetched_data_to_string (GearyImapFetchedData* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GearyImapSequenceNumber* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_FETCHED_DATA (self), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = self->priv->_seq_num;
	_tmp3_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp1_, "[%s] ", _tmp4_);
	_g_free0 (_tmp4_);
	{
		GeeIterator* _data_type_it = NULL;
		GeeMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp5_ = self->priv->_data_map;
		_tmp6_ = gee_map_get_keys (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_data_type_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			GearyImapFetchDataSpecifier data_type = 0;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			GString* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GeeMap* _tmp17_;
			gpointer _tmp18_;
			GearyImapMessageData* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp11_ = _data_type_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _data_type_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			data_type = (GearyImapFetchDataSpecifier) ((gintptr) _tmp13_);
			_tmp14_ = builder;
			_tmp15_ = geary_imap_fetch_data_specifier_to_string (data_type);
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->_data_map;
			_tmp18_ = gee_map_get (_tmp17_, (gpointer) ((gintptr) data_type));
			_tmp19_ = (GearyImapMessageData*) _tmp18_;
			_tmp20_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
			_tmp21_ = _tmp20_;
			g_string_append_printf (_tmp14_, "%s=%s ", _tmp16_, _tmp21_);
			_g_free0 (_tmp21_);
			_g_object_unref0 (_tmp19_);
			_g_free0 (_tmp16_);
		}
		_g_object_unref0 (_data_type_it);
	}
	{
		GeeIterator* _specifier_it = NULL;
		GeeMap* _tmp22_;
		GeeSet* _tmp23_;
		GeeSet* _tmp24_;
		GeeSet* _tmp25_;
		GeeIterator* _tmp26_;
		GeeIterator* _tmp27_;
		_tmp22_ = self->priv->_body_data_map;
		_tmp23_ = gee_map_get_keys (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp27_ = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_specifier_it = _tmp27_;
		while (TRUE) {
			GeeIterator* _tmp28_;
			GearyImapFetchBodyDataSpecifier* specifier = NULL;
			GeeIterator* _tmp29_;
			gpointer _tmp30_;
			GString* _tmp31_;
			GearyImapFetchBodyDataSpecifier* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GeeMap* _tmp35_;
			GearyImapFetchBodyDataSpecifier* _tmp36_;
			gpointer _tmp37_;
			GearyMemoryBuffer* _tmp38_;
			gsize _tmp39_;
			gsize _tmp40_;
			_tmp28_ = _specifier_it;
			if (!gee_iterator_next (_tmp28_)) {
				break;
			}
			_tmp29_ = _specifier_it;
			_tmp30_ = gee_iterator_get (_tmp29_);
			specifier = (GearyImapFetchBodyDataSpecifier*) _tmp30_;
			_tmp31_ = builder;
			_tmp32_ = specifier;
			_tmp33_ = geary_imap_fetch_body_data_specifier_to_string (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->_body_data_map;
			_tmp36_ = specifier;
			_tmp37_ = gee_map_get (_tmp35_, _tmp36_);
			_tmp38_ = (GearyMemoryBuffer*) _tmp37_;
			_tmp39_ = geary_memory_buffer_get_size (_tmp38_);
			_tmp40_ = _tmp39_;
			g_string_append_printf (_tmp31_, "%s=%lu ", _tmp34_, (gulong) _tmp40_);
			_g_object_unref0 (_tmp38_);
			_g_free0 (_tmp34_);
			_g_object_unref0 (specifier);
		}
		_g_object_unref0 (_specifier_it);
	}
	_tmp41_ = builder;
	_tmp42_ = _tmp41_->str;
	_tmp43_ = g_strdup (_tmp42_);
	result = _tmp43_;
	_g_string_free0 (builder);
	return result;
}

static void
geary_imap_fetched_data_class_init (GearyImapFetchedDataClass * klass,
                                    gpointer klass_data)
{
	geary_imap_fetched_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapFetchedData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_fetched_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_fetched_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_fetched_data_finalize;
	/**
	     * The positional address of the email in the mailbox.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FETCHED_DATA_SEQ_NUM_PROPERTY, geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_SEQ_NUM_PROPERTY] = g_param_spec_object ("seq-num", "seq-num", "seq-num", GEARY_IMAP_TYPE_SEQUENCE_NUMBER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A Map of {@link FetchDataSpecifier}s to their {@link Imap.MessageData} for this email.
	     *
	     * MessageData should be cast to their appropriate class depending on their FetchDataSpecifier.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FETCHED_DATA_DATA_MAP_PROPERTY, geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_DATA_MAP_PROPERTY] = g_param_spec_object ("data-map", "data-map", "data-map", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * List of {@link FetchBodyDataSpecifier} responses.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FETCHED_DATA_BODY_DATA_MAP_PROPERTY, geary_imap_fetched_data_properties[GEARY_IMAP_FETCHED_DATA_BODY_DATA_MAP_PROPERTY] = g_param_spec_object ("body-data-map", "body-data-map", "body-data-map", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_fetched_data_instance_init (GearyImapFetchedData * self,
                                       gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = geary_imap_fetched_data_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (GEARY_IMAP_TYPE_FETCH_DATA_SPECIFIER, NULL, NULL, GEARY_IMAP_TYPE_MESSAGE_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_data_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_hash_map_new (GEARY_IMAP_TYPE_FETCH_BODY_DATA_SPECIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_body_data_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
}

static void
geary_imap_fetched_data_finalize (GObject * obj)
{
	GearyImapFetchedData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FETCHED_DATA, GearyImapFetchedData);
	_g_object_unref0 (self->priv->_seq_num);
	_g_object_unref0 (self->priv->_data_map);
	_g_object_unref0 (self->priv->_body_data_map);
	G_OBJECT_CLASS (geary_imap_fetched_data_parent_class)->finalize (obj);
}

/**
 * The deserialized representation of a FETCH response.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.4.2]]
 *
 * @see FetchCommand
 * @see StoreCommand
 */
 G_GNUC_NO_INLINE static GType
geary_imap_fetched_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFetchedDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_fetched_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFetchedData), 0, (GInstanceInitFunc) geary_imap_fetched_data_instance_init, NULL };
	GType geary_imap_fetched_data_type_id;
	geary_imap_fetched_data_type_id = g_type_register_static (G_TYPE_OBJECT, "GearyImapFetchedData", &g_define_type_info, 0);
	GearyImapFetchedData_private_offset = g_type_add_instance_private (geary_imap_fetched_data_type_id, sizeof (GearyImapFetchedDataPrivate));
	return geary_imap_fetched_data_type_id;
}

GType
geary_imap_fetched_data_get_type (void)
{
	static gsize geary_imap_fetched_data_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_fetched_data_type_id__once)) {
		GType geary_imap_fetched_data_type_id;
		geary_imap_fetched_data_type_id = geary_imap_fetched_data_get_type_once ();
		g_once_init_leave (&geary_imap_fetched_data_type_id__once, geary_imap_fetched_data_type_id);
	}
	return geary_imap_fetched_data_type_id__once;
}

static void
_vala_geary_imap_fetched_data_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapFetchedData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FETCHED_DATA, GearyImapFetchedData);
	switch (property_id) {
		case GEARY_IMAP_FETCHED_DATA_SEQ_NUM_PROPERTY:
		g_value_set_object (value, geary_imap_fetched_data_get_seq_num (self));
		break;
		case GEARY_IMAP_FETCHED_DATA_DATA_MAP_PROPERTY:
		g_value_set_object (value, geary_imap_fetched_data_get_data_map (self));
		break;
		case GEARY_IMAP_FETCHED_DATA_BODY_DATA_MAP_PROPERTY:
		g_value_set_object (value, geary_imap_fetched_data_get_body_data_map (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_fetched_data_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyImapFetchedData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FETCHED_DATA, GearyImapFetchedData);
	switch (property_id) {
		case GEARY_IMAP_FETCHED_DATA_SEQ_NUM_PROPERTY:
		geary_imap_fetched_data_set_seq_num (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_FETCHED_DATA_DATA_MAP_PROPERTY:
		geary_imap_fetched_data_set_data_map (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_FETCHED_DATA_BODY_DATA_MAP_PROPERTY:
		geary_imap_fetched_data_set_body_data_map (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

