/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.desktop.datalab.AvailableColumnsModel;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class AvailableColumnsPanel
extends JPanel {
    private final Table table;
    private final AvailableColumnsModel availableColumnsModel;
    private final Column[] columns;
    private JCheckBox[] columnsCheckBoxes;
    private AvailableColumnsValidator validator;
    private JPanel contentPanel;
    private JLabel descriptionLabel;
    private JScrollPane scroll;

    public AvailableColumnsPanel(Table table, AvailableColumnsModel availableColumnsModel) {
        this.initComponents();
        this.table = table;
        this.availableColumnsModel = availableColumnsModel;
        this.columns = table.toArray();
        this.refreshColumns();
        this.refreshAvailableColumnsControls();
    }

    public ValidationPanel getValidationPanel() {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = validationPanel.getValidationGroup();
        this.validator = new AvailableColumnsValidator();
        group.add((ValidationListener)this.validator);
        this.refreshAvailableColumnsControls();
        return validationPanel;
    }

    private void refreshColumns() {
        this.columnsCheckBoxes = new JCheckBox[this.columns.length];
        this.contentPanel.removeAll();
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        for (int i = 0; i < this.columns.length; ++i) {
            this.columnsCheckBoxes[i] = new JCheckBox(this.columns[i].getTitle(), this.availableColumnsModel.isColumnAvailable(this.columns[i]));
            this.columnsCheckBoxes[i].addActionListener(new ColumnCheckBoxListener(i));
            this.contentPanel.add((Component)this.columnsCheckBoxes[i], "wrap");
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void refreshAvailableColumnsControls() {
        boolean enabled = this.availableColumnsModel.canAddAvailableColumn();
        for (JCheckBox cb : this.columnsCheckBoxes) {
            if (cb.isSelected()) continue;
            cb.setEnabled(enabled);
        }
        if (this.validator != null) {
            this.validator.event();
        }
    }

    private void initComponents() {
        this.scroll = new JScrollPane();
        this.contentPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.contentPanel.setLayout(new GridLayout());
        this.scroll.setViewportView(this.contentPanel);
        this.descriptionLabel.setText(NbBundle.getMessage(AvailableColumnsPanel.class, (String)"AvailableColumnsPanel.descriptionLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING, -1, 341, Short.MAX_VALUE).addComponent(this.scroll, GroupLayout.Alignment.LEADING, -1, 341, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -1, 29, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scroll, -2, 238, -2).addContainerGap()));
    }

    class AvailableColumnsValidator
    extends ValidationListener {
        AvailableColumnsValidator() {
        }

        protected boolean validate(Problems prblms) {
            if (!AvailableColumnsPanel.this.availableColumnsModel.canAddAvailableColumn()) {
                prblms.add(NbBundle.getMessage(AvailableColumnsPanel.class, (String)"AvailableColumnsPanel.maximum-available-columns.info"), Severity.INFO);
                return false;
            }
            return true;
        }

        public void event() {
            this.validate();
        }
    }

    class ColumnCheckBoxListener
    implements ActionListener {
        private final int index;

        public ColumnCheckBoxListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AvailableColumnsPanel.this.columnsCheckBoxes[this.index].isSelected()) {
                AvailableColumnsPanel.this.availableColumnsModel.addAvailableColumn(AvailableColumnsPanel.this.columns[this.index]);
            } else {
                AvailableColumnsPanel.this.availableColumnsModel.removeAvailableColumn(AvailableColumnsPanel.this.columns[this.index]);
            }
            AvailableColumnsPanel.this.refreshAvailableColumnsControls();
        }
    }
}

