/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.layout.api.LayoutModel;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.gephi.project.api.Workspace;
import org.gephi.utils.Serialization;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class LayoutModelImpl
implements LayoutModel {
    private final List<PropertyChangeListener> listeners;
    private final Map<LayoutPropertyKey, Object> savedProperties;
    private final Workspace workspace;
    private final LongTaskExecutor executor;
    private Layout selectedLayout;
    private LayoutBuilder selectedBuilder;

    public LayoutModelImpl(Workspace workspace) {
        this.workspace = workspace;
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.savedProperties = new HashMap<LayoutPropertyKey, Object>();
        this.executor = new LongTaskExecutor(true, "layout", 5);
        this.executor.setLongTaskListener(new LongTaskListener(){

            public void taskFinished(LongTask task) {
                LayoutModelImpl.this.setRunning(false);
            }
        });
        this.executor.setDefaultErrorHandler(new LongTaskErrorHandler(){

            public void fatalError(Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        });
    }

    @Override
    public Layout getSelectedLayout() {
        return this.selectedLayout;
    }

    protected void setSelectedLayout(Layout selectedLayout) {
        Layout oldValue = this.selectedLayout;
        this.selectedLayout = selectedLayout;
        LayoutBuilder layoutBuilder = this.selectedBuilder = selectedLayout != null ? selectedLayout.getBuilder() : null;
        if (oldValue != null) {
            this.saveProperties(oldValue);
        }
        this.injectGraph();
        if (selectedLayout != null) {
            this.loadProperties(selectedLayout);
        }
        this.firePropertyChangeEvent("selectedLayout", oldValue, selectedLayout);
    }

    @Override
    public LayoutBuilder getSelectedBuilder() {
        return this.selectedBuilder;
    }

    @Override
    public Layout getLayout(LayoutBuilder layoutBuilder) {
        Layout layout = layoutBuilder.buildLayout();
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel(this.workspace);
        layout.setGraphModel(graphModel);
        this.selectedBuilder = layoutBuilder;
        layout.resetPropertiesValues();
        return layout;
    }

    public void injectGraph() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (this.selectedLayout != null && graphController.getGraphModel(this.workspace) != null) {
            this.selectedLayout.setGraphModel(graphController.getGraphModel(this.workspace));
        }
    }

    @Override
    public boolean isRunning() {
        return this.executor.isRunning();
    }

    protected void setRunning(boolean running) {
        this.firePropertyChangeEvent("running", !running, running);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = null;
        if (propertyName.equals("selectedLayout")) {
            evt = new PropertyChangeEvent(this, "selectedLayout", oldValue, newValue);
        } else if (propertyName.equals("running")) {
            evt = new PropertyChangeEvent(this, "running", oldValue, newValue);
        } else {
            return;
        }
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    public LongTaskExecutor getExecutor() {
        return this.executor;
    }

    public void saveProperties(Layout layout) {
        for (LayoutProperty p : layout.getProperties()) {
            try {
                Object value = p.getProperty().getValue();
                if (value == null) continue;
                this.savedProperties.put(new LayoutPropertyKey(p.getCanonicalName(), layout.getClass().getName()), value);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public void loadProperties(Layout layout) {
        ArrayList<LayoutPropertyKey> layoutValues = new ArrayList<LayoutPropertyKey>();
        for (LayoutPropertyKey val : this.savedProperties.keySet()) {
            if (!val.layoutClassName.equals(layout.getClass().getName())) continue;
            layoutValues.add(val);
        }
        for (LayoutProperty property : layout.getProperties()) {
            for (LayoutPropertyKey l : layoutValues) {
                if (!property.getCanonicalName().equalsIgnoreCase(l.name) && !property.getProperty().getName().equalsIgnoreCase(l.name)) continue;
                try {
                    property.getProperty().setValue(this.savedProperties.get(l));
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        if (this.selectedLayout != null) {
            this.saveProperties(this.selectedLayout);
            writer.writeStartElement("selectedlayoutbuilder");
            writer.writeAttribute("class", this.selectedLayout.getBuilder().getClass().getName());
            writer.writeEndElement();
        }
        writer.writeStartElement("properties");
        for (Map.Entry<LayoutPropertyKey, Object> entry : this.savedProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            writer.writeStartElement("property");
            writer.writeAttribute("layout", entry.getKey().layoutClassName);
            writer.writeAttribute("property", entry.getKey().name);
            writer.writeAttribute("class", entry.getValue().getClass().getName());
            writer.writeCharacters(Serialization.getValueAsText((Object)entry.getValue()));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void readXML(XMLStreamReader reader) throws XMLStreamException {
        boolean end = false;
        LayoutPropertyKey key = null;
        String valueClassStr = null;
        String selectedLayoutBuilderClass = null;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if ("property".equalsIgnoreCase(name)) {
                    key = new LayoutPropertyKey(reader.getAttributeValue(null, "property"), reader.getAttributeValue(null, "layout"));
                    valueClassStr = reader.getAttributeValue(null, "class");
                    continue;
                }
                if (!"selectedlayoutbuilder".equalsIgnoreCase(name)) continue;
                selectedLayoutBuilderClass = reader.getAttributeValue(null, "class");
                continue;
            }
            if (eventType.equals(4)) {
                Object value;
                if (key == null || reader.isWhiteSpace() || (value = this.parse(valueClassStr, reader.getText())) == null) continue;
                this.savedProperties.put(key, value);
                continue;
            }
            if (!eventType.equals(2)) continue;
            key = null;
            if (!"layoutmodel".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        if (selectedLayoutBuilderClass != null) {
            for (LayoutBuilder builder : Lookup.getDefault().lookupAll(LayoutBuilder.class)) {
                if (!builder.getClass().getName().equals(selectedLayoutBuilderClass)) continue;
                this.setSelectedLayout(builder.buildLayout());
                break;
            }
        }
    }

    private Object parse(String classStr, String str) {
        return Serialization.readValueFromText((String)str, (String)classStr);
    }

    private static class LayoutPropertyKey {
        private final String name;
        private final String layoutClassName;
        private volatile int hashCode = 0;

        public LayoutPropertyKey(String name, String layoutClassName) {
            this.name = name;
            this.layoutClassName = layoutClassName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LayoutPropertyKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            LayoutPropertyKey s = (LayoutPropertyKey)obj;
            return s.layoutClassName.equals(this.layoutClassName) && s.name.equals(this.name);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 7;
                hash += 53 * this.layoutClassName.hashCode();
                this.hashCode = hash += 53 * this.name.hashCode();
            }
            return this.hashCode;
        }
    }
}

