/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import javax.swing.Icon;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.plugin.manipulators.general.AddEdgeToGraph;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.plugin.manipulators.nodes.ui.LinkNodesUI;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LinkNodes
extends BasicNodesManipulator {
    private static boolean directed;
    private static GraphModel graphModel;
    private Node[] nodes;
    private Node sourceNode;

    public void setup(Node[] nodes, Node clickedNode) {
        this.nodes = nodes;
        this.sourceNode = clickedNode;
        GraphModel currentGraphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        if (graphModel != currentGraphModel) {
            directed = currentGraphModel.isDirected() || currentGraphModel.isMixed();
            graphModel = currentGraphModel;
        }
    }

    public void execute() {
        if (this.nodes.length > 1) {
            GraphElementsController gec = (GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class);
            gec.createEdges(this.sourceNode, this.nodes, directed);
        } else {
            AddEdgeToGraph manipulator = new AddEdgeToGraph();
            manipulator.setSource(this.sourceNode);
            DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)manipulator);
        }
    }

    public String getName() {
        return NbBundle.getMessage(LinkNodes.class, (String)"LinkNodes.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(LinkNodes.class, (String)"LinkNodes.description");
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return this.nodes.length > 1 ? new LinkNodesUI() : null;
    }

    public int getType() {
        return 500;
    }

    public int getPosition() {
        return 100;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/edge.png", (boolean)true);
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(Node sourceNode) {
        this.sourceNode = sourceNode;
    }

    public boolean isDirected() {
        return directed;
    }

    public void setDirected(boolean directed) {
        LinkNodes.directed = directed;
    }
}

