/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.screenshot;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gephi.lib.validation.Multiple4NumberValidator;
import org.gephi.visualization.screenshot.ScreenshotMaker;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ScreenshotSettingsPanel
extends JPanel {
    private JComboBox antiAliasingCombo;
    private JCheckBox autoSaveCheckBox;
    private JTextField heightTextField;
    private JPanel imagePanel;
    private JLabel labelAntiAliasing;
    private JLabel labelHeight;
    private JLabel labelWidth;
    private JButton selectDirectoryButton;
    private JTextField widthTextField;

    public ScreenshotSettingsPanel() {
        this.initComponents();
        this.autoSaveCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ScreenshotSettingsPanel.this.selectDirectoryButton.setEnabled(ScreenshotSettingsPanel.this.autoSaveCheckBox.isSelected());
            }
        });
    }

    public static ValidationPanel createValidationPanel(ScreenshotSettingsPanel innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        if (innerPanel == null) {
            innerPanel = new ScreenshotSettingsPanel();
        }
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((JTextComponent)innerPanel.widthTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, new Multiple4NumberValidator()});
        group.add((JTextComponent)innerPanel.heightTextField, new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, new Multiple4NumberValidator()});
        return validationPanel;
    }

    public void setup(final ScreenshotMaker screenshotMaker) {
        this.autoSaveCheckBox.setSelected(screenshotMaker.isAutoSave());
        this.selectDirectoryButton.setEnabled(this.autoSaveCheckBox.isSelected());
        this.widthTextField.setText(String.valueOf(screenshotMaker.getWidth()));
        this.heightTextField.setText(String.valueOf(screenshotMaker.getHeight()));
        switch (screenshotMaker.getAntiAliasing()) {
            case 0: {
                this.antiAliasingCombo.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.antiAliasingCombo.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.antiAliasingCombo.setSelectedIndex(2);
                break;
            }
            case 8: {
                this.antiAliasingCombo.setSelectedIndex(3);
                break;
            }
            case 16: {
                this.antiAliasingCombo.setSelectedIndex(4);
                break;
            }
            default: {
                this.antiAliasingCombo.setSelectedIndex(4);
            }
        }
        this.selectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(screenshotMaker.getDefaultDirectory());
                fileChooser.setFileSelectionMode(1);
                int result = fileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
                if (result == 0) {
                    screenshotMaker.setDefaultDirectory(fileChooser.getSelectedFile());
                }
            }
        });
    }

    public void unsetup(ScreenshotMaker screenshotMaker) {
        screenshotMaker.setAutoSave(this.autoSaveCheckBox.isSelected());
        screenshotMaker.setWidth(Integer.parseInt(this.widthTextField.getText()));
        screenshotMaker.setHeight(Integer.parseInt(this.heightTextField.getText()));
        switch (this.antiAliasingCombo.getSelectedIndex()) {
            case 0: {
                screenshotMaker.setAntiAliasing(0);
                break;
            }
            case 1: {
                screenshotMaker.setAntiAliasing(2);
                break;
            }
            case 2: {
                screenshotMaker.setAntiAliasing(4);
                break;
            }
            case 3: {
                screenshotMaker.setAntiAliasing(8);
                break;
            }
            case 4: {
                screenshotMaker.setAntiAliasing(16);
                break;
            }
            default: {
                screenshotMaker.setAntiAliasing(0);
            }
        }
    }

    private void initComponents() {
        this.imagePanel = new JPanel();
        this.labelHeight = new JLabel();
        this.labelWidth = new JLabel();
        this.widthTextField = new JTextField();
        this.labelAntiAliasing = new JLabel();
        this.antiAliasingCombo = new JComboBox();
        this.heightTextField = new JTextField();
        this.autoSaveCheckBox = new JCheckBox();
        this.selectDirectoryButton = new JButton();
        this.imagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.labelHeight.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelHeight.text"));
        this.labelWidth.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelWidth.text"));
        this.widthTextField.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.widthTextField.text"));
        this.labelAntiAliasing.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.labelAntiAliasing.text"));
        this.antiAliasingCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"0x", "2x", "4x", "8x", "16x"}));
        this.heightTextField.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.heightTextField.text"));
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addContainerGap().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.labelWidth).addGap(3, 3, 3).addComponent(this.widthTextField, -2, 58, -2).addGap(18, 18, 18).addComponent(this.labelHeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightTextField, -2, 58, -2)).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.labelAntiAliasing).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.antiAliasingCombo, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addContainerGap().addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelWidth).addComponent(this.widthTextField, -2, 20, -2).addComponent(this.labelHeight).addComponent(this.heightTextField, -2, 20, -2)).addGap(18, 18, 18).addGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelAntiAliasing).addComponent(this.antiAliasingCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.autoSaveCheckBox.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.autoSaveCheckBox.text"));
        this.selectDirectoryButton.setText(NbBundle.getMessage(ScreenshotSettingsPanel.class, (String)"ScreenshotSettingsPanel.selectDirectoryButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imagePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.autoSaveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectDirectoryButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.imagePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoSaveCheckBox).addComponent(this.selectDirectoryButton, -2, 23, -2)).addContainerGap(21, Short.MAX_VALUE)));
    }
}

