/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import org.jetbrains.annotations.NotNull;

public final class InlineClassRepresentation<Type extends SimpleTypeMarker>
extends ValueClassRepresentation<Type> {
    @NotNull
    private final Name underlyingPropertyName;
    @NotNull
    private final Type underlyingType;

    public InlineClassRepresentation(@NotNull Name underlyingPropertyName, @NotNull Type underlyingType) {
        Intrinsics.checkNotNullParameter((Object)underlyingPropertyName, (String)"underlyingPropertyName");
        Intrinsics.checkNotNullParameter(underlyingType, (String)"underlyingType");
        super(null);
        this.underlyingPropertyName = underlyingPropertyName;
        this.underlyingType = underlyingType;
    }

    @NotNull
    public final Name getUnderlyingPropertyName() {
        return this.underlyingPropertyName;
    }

    @NotNull
    public final Type getUnderlyingType() {
        return this.underlyingType;
    }

    @Override
    @NotNull
    public List<Pair<Name, Type>> getUnderlyingPropertyNamesToTypes() {
        return CollectionsKt.listOf((Object)TuplesKt.to((Object)this.underlyingPropertyName, this.underlyingType));
    }

    @NotNull
    public String toString() {
        return "InlineClassRepresentation(underlyingPropertyName=" + this.underlyingPropertyName + ", underlyingType=" + this.underlyingType + ')';
    }
}

