/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceVariable
extends LightTypeParameter {
    private final PsiElement myContext;
    private boolean myThrownBound;
    private final Map<InferenceBound, List<PsiType>> myBounds = new EnumMap<InferenceBound, List<PsiType>>(InferenceBound.class);
    private final String myName;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.getDelegate();
    }

    InferenceVariable(PsiElement context, PsiTypeParameter parameter, String name) {
        super(parameter);
        this.myName = name;
        this.myContext = context;
        TypeConversionUtil.markAsFreshVariable(this, context);
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    @Override
    public PsiClassType @NotNull [] getExtendsListTypes() {
        ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            if (!(type2 instanceof PsiClassType)) continue;
            result2.add((PsiClassType)type2);
        }
        PsiClassType[] psiClassTypeArray = result2.toArray(PsiClassType.EMPTY_ARRAY);
        if (psiClassTypeArray == null) {
            InferenceVariable.$$$reportNull$$$0(0);
        }
        return psiClassTypeArray;
    }

    public static void addBound(PsiType inferenceVariableType, PsiType boundType, InferenceBound inferenceBound, InferenceSession session2) {
        InferenceVariable variable2 = session2.getInferenceVariable(inferenceVariableType);
        if (variable2 != null) {
            variable2.addBound(boundType, inferenceBound, session2.myIncorporationPhase);
        }
    }

    boolean addBound(PsiType classType, InferenceBound inferenceBound, @Nullable InferenceIncorporationPhase incorporationPhase) {
        if (PsiUtil.resolveClassInClassTypeOnly(classType) == this) {
            return false;
        }
        List bounds = this.myBounds.computeIfAbsent(inferenceBound, __ -> new ArrayList());
        if (classType == null) {
            classType = PsiType.NULL;
        }
        if (incorporationPhase == null || !bounds.contains(classType)) {
            bounds.add(classType);
            if (incorporationPhase != null) {
                incorporationPhase.addBound(this, classType, inferenceBound);
            }
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session2) {
        LinkedHashSet<InferenceVariable> dependencies2 = new LinkedHashSet<InferenceVariable>();
        this.collectBoundDependencies(session2, dependencies2);
        this.collectTransitiveDependencies(session2, dependencies2, dependencies2);
        if (!session2.hasCapture(this) && dependencies2.isEmpty()) {
            return dependencies2;
        }
        if (!session2.hasCapture(this)) {
            return dependencies2;
        }
        dependencies2.removeIf(variable2 -> !session2.hasCapture((InferenceVariable)variable2));
        session2.collectCaptureDependencies(this, dependencies2);
        return dependencies2;
    }

    private void collectTransitiveDependencies(InferenceSession session2, Set<? extends InferenceVariable> dependencies2, Set<? super InferenceVariable> rootDependencies) {
        LinkedHashSet newDependencies = new LinkedHashSet();
        for (InferenceVariable inferenceVariable : dependencies2) {
            inferenceVariable.collectBoundDependencies(session2, newDependencies);
        }
        newDependencies.removeAll(rootDependencies);
        newDependencies.remove(this);
        if (!newDependencies.isEmpty()) {
            rootDependencies.addAll(newDependencies);
            this.collectTransitiveDependencies(session2, newDependencies, rootDependencies);
        }
    }

    private void collectBoundDependencies(InferenceSession session2, Set<? super InferenceVariable> dependencies2) {
        for (Collection collection : this.myBounds.values()) {
            if (collection == null) continue;
            for (PsiType bound : collection) {
                session2.collectDependencies(bound, dependencies2);
            }
        }
    }

    boolean isThrownBound() {
        return this.myThrownBound;
    }

    public void setThrownBound() {
        this.myThrownBound = true;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            InferenceVariable.$$$reportNull$$$0(1);
        }
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
            if (psiClass == null) continue;
            if (this.getManager().areElementsEquivalent(baseClass, psiClass)) {
                return true;
            }
            if (!checkDeep || !psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return super.isInheritor(baseClass, checkDeep);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Override
    public boolean useDelegateToSubstitute() {
        return false;
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }

    @Override
    public PsiTypeParameterListOwner getOwner() {
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    PsiElement getCallContext() {
        return this.myContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceVariable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceVariable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

