/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructSignature;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtils;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExport;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\u00020\u001a*\u00020\nH\u0002J\u0014\u0010\u001b\u001a\u00020\r*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelToJsStatements;", "", "namer", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "declareNewNamespace", "Lkotlin/Function1;", "", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;Lkotlin/jvm/functions/Function1;)V", "namespaceToRefMap", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "generateDeclarationExport", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "namespace", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "esModules", "", "generateModuleExport", "module", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "internalModuleName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "bindToThis", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "generateInnerClassAssignment", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClass;", "outerClass", "backend.js"})
public final class ExportModelToJsStatements {
    @NotNull
    private final IrNamer namer;
    @NotNull
    private final Function1<String, String> declareNewNamespace;
    @NotNull
    private final Map<String, JsNameRef> namespaceToRefMap;

    public ExportModelToJsStatements(@NotNull IrNamer namer, @NotNull Function1<? super String, String> declareNewNamespace) {
        Intrinsics.checkNotNullParameter(namer, "namer");
        Intrinsics.checkNotNullParameter(declareNewNamespace, "declareNewNamespace");
        this.namer = namer;
        this.declareNewNamespace = declareNewNamespace;
        this.namespaceToRefMap = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> generateModuleExport(@NotNull ExportedModule module2, @NotNull JsName internalModuleName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(internalModuleName, "internalModuleName");
        Iterable $this$flatMap$iv = module2.getDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ExportedDeclaration it = (ExportedDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.generateDeclarationExport(it, new JsNameRef(internalModuleName), false);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> generateDeclarationExport(@NotNull ExportedDeclaration declaration, @Nullable JsExpression namespace, boolean esModules) {
        List<JsStatement> list2;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        ExportedDeclaration exportedDeclaration = declaration;
        if (exportedDeclaration instanceof ExportedNamespace) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            String newNamespace;
            if (!(namespace != null)) {
                boolean $i$a$-require-ExportModelToJsStatements$generateDeclarationExport$22 = false;
                String $i$a$-require-ExportModelToJsStatements$generateDeclarationExport$22 = "Only namespaced namespaces are allowed";
                throw new IllegalArgumentException($i$a$-require-ExportModelToJsStatements$generateDeclarationExport$22.toString());
            }
            List statements = new ArrayList();
            String[] stringArray = new String[]{"."};
            List elements = StringsKt.split$default((CharSequence)((ExportedNamespace)declaration).getName(), stringArray, false, 0, 6, null);
            String currentNamespace = "";
            JsExpression currentRef = null;
            currentRef = namespace;
            for (String element : elements) {
                JsNameRef jsNameRef;
                newNamespace = currentNamespace + '$' + element;
                Map<String, JsNameRef> $this$getOrPut$iv = this.namespaceToRefMap;
                boolean $i$f$getOrPut = false;
                JsNameRef value$iv = $this$getOrPut$iv.get(newNamespace);
                if (value$iv == null) {
                    boolean bl = false;
                    JsName varName = new JsName(this.declareNewNamespace.invoke(newNamespace), false);
                    JsExpression namespaceRef = JsAstUtilsKt.jsElementAccess(element, currentRef);
                    ((Collection)statements).add(new JsVars(new JsVars.JsVar(varName, JsAstUtils.INSTANCE.or(namespaceRef, JsAstUtilsKt.jsAssignment(namespaceRef, new JsObjectLiteral())))));
                    JsNameRef answer$iv = new JsNameRef(varName);
                    $this$getOrPut$iv.put(newNamespace, answer$iv);
                    jsNameRef = answer$iv;
                } else {
                    jsNameRef = value$iv;
                }
                JsNameRef newNameSpaceRef = jsNameRef;
                currentRef = newNameSpaceRef;
                currentNamespace = newNamespace;
            }
            Iterable iterable = ((ExportedNamespace)declaration).getDeclarations();
            Collection collection = statements;
            boolean $i$f$flatMap = false;
            newNamespace = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ExportedDeclaration it = (ExportedDeclaration)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.generateDeclarationExport(it, currentRef, esModules);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list2 = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
        } else if (exportedDeclaration instanceof ExportedFunction) {
            JsName name = this.namer.getNameForStaticDeclaration(((ExportedFunction)declaration).getIr());
            list2 = esModules ? CollectionsKt.listOf(new JsExport(name, new JsName(((ExportedFunction)declaration).getName(), false))) : (namespace != null ? CollectionsKt.listOf(JsAstUtilsKt.jsAssignment(JsAstUtilsKt.jsElementAccess(((ExportedFunction)declaration).getName(), namespace), new JsNameRef(name)).makeStmt()) : CollectionsKt.emptyList());
        } else if (exportedDeclaration instanceof ExportedConstructor) {
            list2 = CollectionsKt.emptyList();
        } else if (exportedDeclaration instanceof ExportedConstructSignature) {
            list2 = CollectionsKt.emptyList();
        } else if (exportedDeclaration instanceof ExportedProperty) {
            JsNameRef jsNameRef;
            JsNameRef jsNameRef2;
            if (!(namespace != null)) {
                boolean $i$a$-require-ExportModelToJsStatements$generateDeclarationExport$52 = false;
                String $i$a$-require-ExportModelToJsStatements$generateDeclarationExport$52 = "Only namespaced properties are allowed";
                throw new IllegalArgumentException($i$a$-require-ExportModelToJsStatements$generateDeclarationExport$52.toString());
            }
            IrFunction irFunction2 = ((ExportedProperty)declaration).getIrGetter();
            if (irFunction2 != null) {
                IrFunction it = irFunction2;
                boolean bl = false;
                jsNameRef2 = new JsNameRef(this.namer.getNameForStaticDeclaration(it));
            } else {
                jsNameRef2 = null;
            }
            JsNameRef getter2 = jsNameRef2;
            IrFunction irFunction3 = ((ExportedProperty)declaration).getIrSetter();
            if (irFunction3 != null) {
                IrFunction it = irFunction3;
                boolean bl = false;
                jsNameRef = new JsNameRef(this.namer.getNameForStaticDeclaration(it));
            } else {
                jsNameRef = null;
            }
            JsNameRef setter2 = jsNameRef;
            list2 = CollectionsKt.listOf(JsAstUtilsKt.defineProperty(namespace, ((ExportedProperty)declaration).getName(), getter2, setter2).makeStmt());
        } else if (exportedDeclaration instanceof ErrorDeclaration) {
            list2 = CollectionsKt.emptyList();
        } else if (exportedDeclaration instanceof ExportedObject) {
            void $this$flatMapTo$iv$iv;
            if (!(namespace != null)) {
                boolean $i$a$-require-ExportModelToJsStatements$generateDeclarationExport$62 = false;
                String $i$a$-require-ExportModelToJsStatements$generateDeclarationExport$62 = "Only namespaced properties are allowed";
                throw new IllegalArgumentException($i$a$-require-ExportModelToJsStatements$generateDeclarationExport$62.toString());
            }
            JsExpression newNameSpace = JsAstUtilsKt.jsElementAccess(((ExportedObject)declaration).getName(), namespace);
            JsNameRef getter3 = new JsNameRef(this.namer.getNameForStaticDeclaration(((ExportedObject)declaration).getIrGetter()));
            Iterable $this$flatMap$iv = ((ExportedObject)declaration).getNestedClasses();
            boolean $i$f$flatMap = false;
            Iterable bl = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ExportedClass it = (ExportedClass)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = this.generateDeclarationExport(it, newNameSpace, esModules);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List staticsExport = (List)destination$iv$iv;
            list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(JsAstUtilsKt.defineProperty(namespace, ((ExportedObject)declaration).getName(), getter3, null).makeStmt()), (Iterable)staticsExport);
        } else if (exportedDeclaration instanceof ExportedRegularClass) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterTo$iv$iv2;
            void $this$filterTo$iv$iv3;
            List $this$filter$iv2;
            if (((ExportedRegularClass)declaration).isInterface()) {
                return CollectionsKt.emptyList();
            }
            JsExpression newNameSpace = namespace != null ? JsAstUtilsKt.jsElementAccess(((ExportedRegularClass)declaration).getName(), namespace) : (JsExpression)new JsNameRef(Namer.INSTANCE.getPROTOTYPE_NAME(), (JsExpression)this.namer.getNameForClass(((ExportedRegularClass)declaration).getIr()).makeRef());
            JsName name = this.namer.getNameForStaticDeclaration(((ExportedRegularClass)declaration).getIr());
            JsStatement klassExport = esModules ? (JsStatement)new JsExport(name, new JsName(((ExportedRegularClass)declaration).getName(), false)) : (namespace != null ? JsAstUtilsKt.jsAssignment(newNameSpace, new JsNameRef(name)).makeStmt() : null);
            Iterable $i$f$flatMap = ((ExportedRegularClass)declaration).getMembers();
            boolean $i$f$filter = false;
            void destination$iv$iv = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                ExportedDeclaration it = (ExportedDeclaration)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof ExportedFunction && ((ExportedFunction)it).isStatic())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List it = $this$filter$iv2 = (List)destination$iv$iv2;
            boolean bl = false;
            List<Object> list3 = !((ExportedRegularClass)declaration).getIr().isInner() ? $this$filter$iv2 : null;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            List staticFunctions = list3;
            Iterable $this$filter$iv3 = ((ExportedRegularClass)declaration).getMembers();
            boolean $i$f$filter22 = false;
            destination$iv$iv2 = $this$filter$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ExportedDeclaration it2 = (ExportedDeclaration)element$iv$iv;
                boolean bl3 = false;
                if (!(it2 instanceof ExportedProperty && ((ExportedProperty)it2).isStatic())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List enumEntries2 = (List)destination$iv$iv3;
            Iterable $i$f$filter22 = ((ExportedRegularClass)declaration).getNestedClasses();
            boolean $i$f$filter3 = false;
            destination$iv$iv3 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExportedClass it3 = (ExportedClass)element$iv$iv;
                boolean bl4 = false;
                if (!it3.getIr().isInner()) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv4;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ExportedClass it3 = (ExportedClass)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl5 = false;
                collection.add(this.generateInnerClassAssignment(it3, (ExportedClass)declaration));
            }
            List innerClassesAssignments = (List)destination$iv$iv4;
            Iterable $i$f$map22 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)staticFunctions, (Iterable)enumEntries2), (Iterable)((ExportedRegularClass)declaration).getNestedClasses());
            boolean $i$f$flatMap2 = false;
            destination$iv$iv4 = $this$flatMap$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ExportedDeclaration it4 = (ExportedDeclaration)element$iv$iv;
                boolean bl6 = false;
                Iterable list$iv$iv = this.generateDeclarationExport(it4, newNameSpace, esModules);
                CollectionsKt.addAll(destination$iv$iv5, list$iv$iv);
            }
            List staticsExport = (List)destination$iv$iv5;
            list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(klassExport), (Iterable)staticsExport), (Iterable)innerClassesAssignments);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    private final JsStatement generateInnerClassAssignment(ExportedClass $this$generateInnerClassAssignment, ExportedClass outerClass2) {
        JsStatement[] $this$filterIsInstanceAndTo$iv$iv;
        JsNameRef jsNameRef = this.namer.getNameForStaticDeclaration($this$generateInnerClassAssignment.getIr()).makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "namer.getNameForStaticDeclaration(ir).makeRef()");
        JsNameRef innerClassRef = jsNameRef;
        JsNameRef jsNameRef2 = this.namer.getNameForStaticDeclaration(outerClass2.getIr()).makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef2, "namer.getNameForStaticDe\u2026(outerClass.ir).makeRef()");
        JsNameRef outerClassRef = jsNameRef2;
        IrClass companionObject2 = AdditionalIrUtilsKt.companionObject($this$generateInnerClassAssignment.getIr());
        Iterable $this$filterIsInstanceAnd$iv = $this$generateInnerClassAssignment.getMembers();
        boolean $i$f$filterIsInstanceAnd = false;
        Iterable iterable = $this$filterIsInstanceAnd$iv;
        Collection destination$iv$iv = new SmartList();
        boolean $i$f$filterIsInstanceAndTo = false;
        for (Object t : $this$filterIsInstanceAndTo$iv$iv) {
            if (!(t instanceof ExportedFunction)) continue;
            ExportedFunction it = (ExportedFunction)t;
            boolean bl = false;
            if (!it.isStatic()) continue;
            destination$iv$iv.add(t);
        }
        Collection secondaryConstructors2 = destination$iv$iv;
        JsName bindConstructor = new JsName("__bind_constructor_", false);
        $this$filterIsInstanceAndTo$iv$iv = new JsStatement[]{new JsVars(new JsVars.JsVar(bindConstructor, this.bindToThis(innerClassRef)))};
        List<JsStatement> blockStatements = CollectionsKt.mutableListOf($this$filterIsInstanceAndTo$iv$iv);
        if (companionObject2 != null) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(companionObject2).getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "companionObject.getJsNameOrKotlinName().identifier");
            String companionName = string2;
            JsStatement jsStatement = JsAstUtilsKt.jsAssignment(new JsNameRef(companionName, (JsExpression)bindConstructor.makeRef()), new JsNameRef(companionName, (JsExpression)innerClassRef)).makeStmt();
            Intrinsics.checkNotNullExpressionValue(jsStatement, "jsAssignment(\n          \u2026             ).makeStmt()");
            blockStatements.add(jsStatement);
        }
        Iterable $this$forEach$iv = secondaryConstructors2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement assignment;
            JsNameRef currentFunRef;
            ExportedFunction exportedFunction = (ExportedFunction)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(this.namer.getNameForStaticDeclaration(exportedFunction.getIr()).makeRef(), "namer.getNameForStaticDeclaration(it.ir).makeRef()");
            Intrinsics.checkNotNullExpressionValue(JsAstUtilsKt.jsAssignment(new JsNameRef(exportedFunction.getName(), (JsExpression)bindConstructor.makeRef()), this.bindToThis(currentFunRef)).makeStmt(), "jsAssignment(\n          \u2026\n            ).makeStmt()");
            blockStatements.add(assignment);
        }
        blockStatements.add(new JsReturn(bindConstructor.makeRef()));
        Collection $this$toTypedArray$iv = blockStatements;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        JsStatement[] jsStatementArray = collection.toArray(new JsStatement[0]);
        JsStatement jsStatement = JsAstUtilsKt.defineProperty(JsAstUtilsKt.prototypeOf(outerClassRef), $this$generateInnerClassAssignment.getName(), new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(Arrays.copyOf(jsStatementArray, jsStatementArray.length)), "inner class '" + $this$generateInnerClassAssignment.getName() + "' getter"), null).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "defineProperty(\n        \u2026null\n        ).makeStmt()");
        return jsStatement;
    }

    private final JsInvocation bindToThis(JsNameRef $this$bindToThis) {
        JsExpression[] jsExpressionArray = new JsExpression[]{new JsNullLiteral(), new JsThisRef()};
        return new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)$this$bindToThis), jsExpressionArray);
    }
}

