/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.enums

@Suppress("UNCHECKED_CAST", "unused")
internal actual class EnumEntriesSerializationProxy<E : Enum<E>> actual constructor(entries: Array<E>) : Serializable {
    private val c: Class<E> = entries.javaClass.componentType!! as Class<E>

    private companion object {
        private const val serialVersionUID: Long = 0L
    }

    @OptIn(ExperimentalStdlibApi::class)
    private fun readResolve(): Any {
        return enumEntries(c.enumConstants)
    }
}
