/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.CountryPane;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CountryPaneBuilder<B extends CountryPaneBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();
    private final Country country;

    protected CountryPaneBuilder(Country country) {
        if (null == country) {
            throw new IllegalArgumentException("country cannot be null");
        }
        this.country = country;
    }

    public static final CountryPaneBuilder create(Country country) {
        return new CountryPaneBuilder(country);
    }

    public final B background(Paint paint) {
        this.properties.put("background", (Property)new SimpleObjectProperty((Object)paint));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)fill));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", (Property)new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)stroke));
        return (B)this;
    }

    public final B poiFill(Color poiFill) {
        this.properties.put("poiFill", (Property)new SimpleObjectProperty((Object)poiFill));
        return (B)this;
    }

    public final B poiStroke(Color poiStroke) {
        this.properties.put("poiStroke", (Property)new SimpleObjectProperty((Object)poiStroke));
        return (B)this;
    }

    public final B poiTextFill(Color poiTextFill) {
        this.properties.put("poiTextFill", (Property)new SimpleObjectProperty((Object)poiTextFill));
        return (B)this;
    }

    public final B poisVisible(boolean poisVisible) {
        this.properties.put("poisVisible", (Property)new SimpleBooleanProperty(poisVisible));
        return (B)this;
    }

    public final B poiTextVisible(boolean poiTextVisible) {
        this.properties.put("poiTextVisible", (Property)new SimpleBooleanProperty(poiTextVisible));
        return (B)this;
    }

    public final B pois(List<Poi> pois) {
        this.properties.put("pois", (Property)new SimpleObjectProperty(pois));
        return (B)this;
    }

    public final B heatmapVisible(boolean heatmapVisible) {
        this.properties.put("heatmapVisible", (Property)new SimpleBooleanProperty(heatmapVisible));
        return (B)this;
    }

    public final B heatmapSpots(List<Point> heatmapSpots) {
        this.properties.put("heatmapSpots", (Property)new SimpleObjectProperty(heatmapSpots));
        return (B)this;
    }

    public final B heatmapColorMapping(Mapping heatmapColorMapping) {
        this.properties.put("heatmapColorMapping", (Property)new SimpleObjectProperty((Object)heatmapColorMapping));
        return (B)this;
    }

    public final B heatmapSpotRadius(double heatmapSpotRadius) {
        this.properties.put("heatmapSpotRadius", (Property)new SimpleDoubleProperty(heatmapSpotRadius));
        return (B)this;
    }

    public final B heatmapFadeColors(boolean heatmapFadeColors) {
        this.properties.put("heatmapFadeColors", (Property)new SimpleBooleanProperty(heatmapFadeColors));
        return (B)this;
    }

    public final B heatmapOpacityDistribution(OpacityDistribution heatmapOpacityDistribution) {
        this.properties.put("heatmapOpacityDistribution", (Property)new SimpleObjectProperty((Object)heatmapOpacityDistribution));
        return (B)this;
    }

    public final B heatmapOpacity(double heatmapOpacity) {
        this.properties.put("heatmapOpacity", (Property)new SimpleDoubleProperty(heatmapOpacity));
        return (B)this;
    }

    public final B connections(List<Connection> connections) {
        this.properties.put("connections", (Property)new SimpleObjectProperty(connections));
        return (B)this;
    }

    public final B overlayVisible(boolean overlayVisible) {
        this.properties.put("overlayVisible", (Property)new SimpleBooleanProperty(overlayVisible));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxheight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxheight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final CountryPane build() {
        CountryPane countryPane = new CountryPane(this.country);
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                countryPane.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                countryPane.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                countryPane.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                countryPane.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                countryPane.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                countryPane.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                countryPane.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                countryPane.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                countryPane.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                countryPane.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                countryPane.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                countryPane.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                countryPane.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                countryPane.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                countryPane.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                countryPane.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                countryPane.setBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fill".equals(key)) {
                countryPane.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stroke".equals(key)) {
                countryPane.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lineWidth".equals(key)) {
                countryPane.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiFill".equals(key)) {
                countryPane.setPoiFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiStroke".equals(key)) {
                countryPane.setPoiStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiTextFill".equals(key)) {
                countryPane.setPoiTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poisVisible".equals(key)) {
                countryPane.setPoisVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiTextVisible".equals(key)) {
                countryPane.setPoiTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pois".equals(key)) {
                countryPane.addPois((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapVisible".equals(key)) {
                countryPane.setHeatmapVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapSpots".equals(key)) {
                countryPane.setHeatmapSpots((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapColorMapping".equals(key)) {
                countryPane.setHeatmapColorMapping((Mapping)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapSpotRadius".equals(key)) {
                countryPane.setHeatmapSpotRadius(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapFadeColors".equals(key)) {
                countryPane.setHeatmapFadeColors(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapOpacityDistribution".equals(key)) {
                countryPane.setHeatmapOpacityDistribution((OpacityDistribution)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("heatmapOpacity".equals(key)) {
                countryPane.setHeatmapOpacity(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("connections".equals(key)) {
                countryPane.setConnections((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"overlayVisible".equals(key)) continue;
            countryPane.setOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
        }
        return countryPane;
    }
}

