/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.colors.ColorSkin;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolboxfx.GradientLookup;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class ColorTileSkin
extends TileSkin {
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Text text;
    private Rectangle barBackground;
    private Rectangle bar;
    private GradientLookup gradientLookup;

    public ColorTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.gradientLookup = new GradientLookup();
        if (this.tile.getSections().isEmpty()) {
            this.tile.setSections(new Section(0.0, 0.25, ColorSkin.GREEN), new Section(0.25, 0.5, ColorSkin.YELLOW), new Section(0.5, 0.75, ColorSkin.ORANGE), new Section(0.75, 1.0, ColorSkin.RED));
        }
        this.tile.setBackgroundColor(((Section)this.tile.getSections().get(0)).getColor());
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, (this.tile.getValue() - this.minValue) / this.range * 100.0));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(new Node[]{this.upperUnitText, this.fractionLine, this.unitText});
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(new Node[]{this.valueText, this.unitFlow});
        this.valueUnitFlow.setAlignment(Pos.CENTER);
        this.valueUnitFlow.setMouseTransparent(true);
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill((Paint)this.tile.getTextColor());
        this.barBackground = new Rectangle();
        this.barBackground.setFill((Paint)this.tile.getBarBackgroundColor());
        this.bar = new Rectangle();
        this.bar.setFill((Paint)this.tile.getForegroundColor());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.valueUnitFlow, this.text, this.barBackground, this.bar});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueUnitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        } else if (TileEvt.SECTION.getName().equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        double percentage = VALUE / this.tile.getRange();
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(percentage));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, percentage));
        }
        if (this.tile.isFillWithGradient()) {
            this.tile.setBackgroundColor(this.gradientLookup.getColorAt(percentage));
        } else {
            for (Section section : this.tile.getSections()) {
                if (!section.contains(percentage)) continue;
                this.tile.setBackgroundColor(section.getColor());
                break;
            }
        }
        this.resizeDynamicText();
        this.bar.setWidth(this.size * 0.9 * percentage);
    }

    public void layoutChildren(double X, double Y, double W, double H) {
        super.layoutChildren(X, Y, W, H);
        this.resize();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.3 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.48;
        this.valueText.setFont(Fonts.latoBold(fontSize));
        double correctedFontSize = fontSize;
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            correctedFontSize = Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        double fontFactor = correctedFontSize / fontSize;
        maxWidth = this.size * 0.275;
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.24 : this.size * 0.2;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize * fontFactor));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.24 : this.size * 0.2;
        this.unitText.setFont(Fonts.latoRegular(fontSize * fontFactor));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.valueUnitFlow.relocate(this.size * 0.05, (this.height - this.valueUnitFlow.getLayoutBounds().getHeight()) * 0.5);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        fontSize = this.size * 0.06;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.1);
    }

    @Override
    protected void resize() {
        super.resize();
        this.resizeDynamicText();
        this.resizeStaticText();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, (this.height - this.valueUnitFlow.getLayoutBounds().getHeight()) * 0.5);
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.unitFlow.getWidth() * 0.1);
        this.fractionLine.setStartY(this.unitFlow.getLayoutBounds().getHeight() * 0.5);
        this.fractionLine.setEndX(this.unitFlow.getWidth() * 0.8);
        this.fractionLine.setEndY(this.unitFlow.getLayoutBounds().getHeight() * 0.5);
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
        this.barBackground.relocate(this.size * 0.05, this.height * 0.85);
        this.barBackground.setWidth(this.size * 0.9);
        this.barBackground.setHeight(this.size * 0.02);
        this.barBackground.setArcWidth(this.size * 0.02);
        this.barBackground.setArcHeight(this.size * 0.02);
        this.bar.relocate(this.size * 0.05, this.height * 0.85);
        this.bar.setHeight(this.size * 0.02);
        this.bar.setArcWidth(this.size * 0.02);
        this.bar.setArcHeight(this.size * 0.02);
        this.bar.setWidth(this.size * 0.9 * this.tile.getCurrentValue() / this.tile.getRange());
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue())));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue())));
        }
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode((Node)this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode((Node)this.fractionLine, false);
        }
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.upperUnitText.setFill((Paint)this.tile.getUnitColor());
        this.fractionLine.setStroke((Paint)this.tile.getUnitColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        if (this.tile.isFillWithGradient() && !this.tile.getGradientStops().isEmpty()) {
            this.gradientLookup.setStops(this.tile.getGradientStops());
        }
        this.barBackground.setFill((Paint)this.tile.getBarBackgroundColor());
        this.bar.setFill((Paint)this.tile.getForegroundColor());
    }
}

