/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyDoubleProperty;

public class DoubleProperty
extends ReadOnlyDoubleProperty {
    protected ReadOnlyDoubleProperty propertyBoundTo = null;
    protected boolean bound = false;

    public DoubleProperty() {
        this((Object)null, (String)null, 0.0);
    }

    public DoubleProperty(double value) {
        this((Object)null, (String)null, value);
    }

    public DoubleProperty(String name, double value) {
        this((Object)null, name, value);
    }

    public DoubleProperty(Object bean, String name, double value) {
        super(bean, name, value);
    }

    public void setValue(Double value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(double value) {
        this.setValue(value);
    }

    protected void setValue(Double value, DoubleProperty property) {
        this.willChange((Double)this.value, value);
        Double oldValue = (Double)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, (Double)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Double)this.getInitialValue());
    }

    public void setInitialValue(Double initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyDoubleProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(DoubleProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(DoubleProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

