/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.Closeable;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.action.ExecuteMonitorRequest;
import org.opensearch.alerting.action.ExecuteMonitorResponse;
import org.opensearch.alerting.model.MonitorRunResult;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.TransportExecuteMonitorActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.alerting.util.DocLevelMonitorQueries;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.authuser.User;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BG\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lorg/opensearch/alerting/transport/TransportExecuteMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/alerting/action/ExecuteMonitorRequest;", "Lorg/opensearch/alerting/action/ExecuteMonitorResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "runner", "Lorg/opensearch/alerting/MonitorRunnerService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "docLevelMonitorQueries", "Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/alerting/MonitorRunnerService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/common/xcontent/NamedXContentRegistry;Lorg/opensearch/alerting/util/DocLevelMonitorQueries;Lorg/opensearch/common/settings/Settings;)V", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "kotlin.jvm.PlatformType", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "execMonitorRequest", "actionListener", "Lorg/opensearch/action/ActionListener;", "opensearch-alerting"})
public final class TransportExecuteMonitorAction
extends HandledTransportAction<ExecuteMonitorRequest, ExecuteMonitorResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final MonitorRunnerService runner;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final DocLevelMonitorQueries docLevelMonitorQueries;
    @NotNull
    private final Settings settings;
    private volatile TimeValue indexTimeout;

    @Inject
    public TransportExecuteMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull MonitorRunnerService runner, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry, @NotNull DocLevelMonitorQueries docLevelMonitorQueries, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorQueries, (String)"docLevelMonitorQueries");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opendistro/alerting/monitor/execute", transportService, actionFilters, ExecuteMonitorRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.runner = runner;
        this.xContentRegistry = xContentRegistry;
        this.docLevelMonitorQueries = docLevelMonitorQueries;
        this.settings = settings;
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull ExecuteMonitorRequest execMonitorRequest, @NotNull ActionListener<ExecuteMonitorResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)execMonitorRequest), (String)"execMonitorRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        TransportExecuteMonitorActionKt.access$getLog$p().debug("User and roles string from thread context: " + userStr);
        User user = User.parse((String)userStr);
        AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            Unit unit;
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
            boolean bl = false;
            Function1 executeMonitor2 = (Function1)new Function1<Monitor, Unit>(this, execMonitorRequest, actionListener){
                final /* synthetic */ TransportExecuteMonitorAction this$0;
                final /* synthetic */ ExecuteMonitorRequest $execMonitorRequest;
                final /* synthetic */ ActionListener<ExecuteMonitorResponse> $actionListener;
                {
                    this.this$0 = $receiver;
                    this.$execMonitorRequest = $execMonitorRequest;
                    this.$actionListener = $actionListener;
                    super(1);
                }

                public final void invoke(@NotNull Monitor monitor) {
                    Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
                    BuildersKt.launch$default((CoroutineScope)TransportExecuteMonitorAction.access$getRunner$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(monitor, this.$execMonitorRequest, this.this$0, this.$actionListener, null){
                        int label;
                        final /* synthetic */ Monitor $monitor;
                        final /* synthetic */ ExecuteMonitorRequest $execMonitorRequest;
                        final /* synthetic */ TransportExecuteMonitorAction this$0;
                        final /* synthetic */ ActionListener<ExecuteMonitorResponse> $actionListener;
                        {
                            this.$monitor = $monitor;
                            this.$execMonitorRequest = $execMonitorRequest;
                            this.this$0 = $receiver;
                            this.$actionListener = $actionListener;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var2_3 = this.$monitor.getSchedule().getPeriodEndingAt(Instant.ofEpochMilli(this.$execMonitorRequest.getRequestEnd().getMillis()));
                                    periodStart = (Instant)var2_3.component1();
                                    periodEnd = (Instant)var2_3.component2();
                                    this.label = 1;
                                    v0 = TransportExecuteMonitorAction.access$getRunner$p(this.this$0).runJob((ScheduledJob)this.$monitor, periodStart, periodEnd, this.$execMonitorRequest.getDryrun(), (Continuation)this);
                                    ** if (v0 != var6_2) goto lbl14
lbl13:
                                    // 1 sources

                                    return var6_2;
lbl14:
                                    // 1 sources

                                    ** GOTO lbl20
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl20:
                                    // 2 sources

                                    monitorRunResult = (MonitorRunResult)v0;
                                    this.label = 2;
                                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, monitorRunResult, null){
                                        int label;
                                        final /* synthetic */ ActionListener<ExecuteMonitorResponse> $actionListener;
                                        final /* synthetic */ MonitorRunResult<?> $monitorRunResult;
                                        {
                                            this.$actionListener = $actionListener;
                                            this.$monitorRunResult = $monitorRunResult;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.$actionListener.onResponse((Object)((Object)new ExecuteMonitorResponse(this.$monitorRunResult)));
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    ** if (v1 != var6_2) goto lbl25
lbl24:
                                    // 1 sources

                                    return var6_2;
lbl25:
                                    // 1 sources

                                    ** GOTO lbl42
                                }
                                case 2: {
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        ** GOTO lbl42
                                    }
                                    catch (Exception e) {
                                        TransportExecuteMonitorActionKt.access$getLog$p().error("Unexpected error running monitor", (Throwable)e);
                                        this.label = 3;
                                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actionListener, e, null){
                                            int label;
                                            final /* synthetic */ ActionListener<ExecuteMonitorResponse> $actionListener;
                                            final /* synthetic */ Exception $e;
                                            {
                                                this.$actionListener = $actionListener;
                                                this.$e = $e;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(this.$e));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl42
                                    }
                                }
                                case 3: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl42:
                                    // 4 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            };
            if (execMonitorRequest.getMonitorId() != null) {
                GetRequest getRequest = new GetRequest(".opendistro-alerting-config").id(execMonitorRequest.getMonitorId());
                this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, this, (Function1<? super Monitor, Unit>)executeMonitor2){
                    final /* synthetic */ ActionListener<ExecuteMonitorResponse> $actionListener;
                    final /* synthetic */ TransportExecuteMonitorAction this$0;
                    final /* synthetic */ Function1<Monitor, Unit> $executeMonitor;
                    {
                        this.$actionListener = $actionListener;
                        this.this$0 = $receiver;
                        this.$executeMonitor = $executeMonitor;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(@NotNull GetResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        if (!response2.isExists()) {
                            this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Can't find monitor with id: " + response2.getId(), RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        if (!response2.isSourceEmpty()) {
                            Closeable closeable = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.this$0.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response2.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                            Function1<Monitor, Unit> function1 = this.$executeMonitor;
                            Throwable throwable = null;
                            try {
                                XContentParser xcp = (XContentParser)closeable;
                                boolean bl = false;
                                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                                String string = response2.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                                Monitor monitor = (Monitor)ScheduledJob.Companion.parse(xcp, string, response2.getVersion());
                                function1.invoke((Object)monitor);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
                unit = Unit.INSTANCE;
            } else {
                Monitor monitor;
                Monitor monitor2;
                boolean bl2;
                User user2 = user;
                CharSequence charSequence = (CharSequence)(user2 == null ? null : user2.getName());
                boolean bl3 = bl2 = charSequence == null || charSequence.length() == 0;
                if (bl2) {
                    monitor2 = execMonitorRequest.getMonitor();
                    if (monitor2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.alerting.model.Monitor");
                    }
                } else if (!bl2) {
                    Monitor monitor3 = execMonitorRequest.getMonitor();
                    if (monitor3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.opensearch.commons.alerting.model.Monitor");
                    }
                    monitor2 = Monitor.copy$default((Monitor)monitor3, null, (long)0L, null, (boolean)false, null, null, null, null, (User)user, (int)0, null, null, null, null, null, (int)32511, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((monitor = monitor2).getMonitorType() == Monitor.MonitorType.DOC_LEVEL_MONITOR) {
                    Unit unit2;
                    try {
                        unit2 = BuildersKt.launch$default((CoroutineScope)TransportExecuteMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, monitor, (Function1<? super Monitor, Unit>)executeMonitor2, null){
                            int label;
                            final /* synthetic */ TransportExecuteMonitorAction this$0;
                            final /* synthetic */ Monitor $monitor;
                            final /* synthetic */ Function1<Monitor, Unit> $executeMonitor;
                            {
                                this.this$0 = $receiver;
                                this.$monitor = $monitor;
                                this.$executeMonitor = $executeMonitor;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        if (TransportExecuteMonitorAction.access$getDocLevelMonitorQueries$p(this.this$0).docLevelQueryIndexExists()) ** GOTO lbl15
                                        this.label = 1;
                                        v0 = TransportExecuteMonitorAction.access$getDocLevelMonitorQueries$p(this.this$0).initDocLevelQueryIndex(this.$monitor.getDataSources(), (Continuation<? super Boolean>)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl14
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl14:
                                        // 2 sources

                                        TransportExecuteMonitorActionKt.access$getLog$p().info("Central Percolation index .opensearch-alerting-queries created");
lbl15:
                                        // 2 sources

                                        v1 = TransportExecuteMonitorAction.access$getDocLevelMonitorQueries$p(this.this$0);
                                        v2 = this.$monitor.getId();
                                        var2_3 = TransportExecuteMonitorAction.access$getIndexTimeout$p(this.this$0);
                                        Intrinsics.checkNotNullExpressionValue((Object)var2_3, (String)"indexTimeout");
                                        this.label = 2;
                                        v3 = v1.indexDocLevelQueries(this.$monitor, v2, WriteRequest.RefreshPolicy.IMMEDIATE, var2_3, (Continuation<? super Unit>)((Continuation)this));
                                        if (v3 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl27
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
lbl27:
                                        // 2 sources

                                        TransportExecuteMonitorActionKt.access$getLog$p().info("Queries inserted into Percolate index .opensearch-alerting-queries");
                                        this.$executeMonitor.invoke((Object)this.$monitor);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                    catch (Exception t) {
                        actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                        unit2 = Unit.INSTANCE;
                    }
                    unit = unit2;
                } else {
                    executeMonitor2.invoke((Object)monitor);
                    unit = Unit.INSTANCE;
                }
            }
            Unit unit3 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ MonitorRunnerService access$getRunner$p(TransportExecuteMonitorAction $this) {
        return $this.runner;
    }

    public static final /* synthetic */ DocLevelMonitorQueries access$getDocLevelMonitorQueries$p(TransportExecuteMonitorAction $this) {
        return $this.docLevelMonitorQueries;
    }

    public static final /* synthetic */ TimeValue access$getIndexTimeout$p(TransportExecuteMonitorAction $this) {
        return $this.indexTimeout;
    }
}

