/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.client.AdminClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/core/ScheduledJobIndices;", "", "client", "Lorg/opensearch/client/AdminClient;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/client/AdminClient;Lorg/opensearch/cluster/service/ClusterService;)V", "initScheduledJobIndex", "", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/admin/indices/create/CreateIndexResponse;", "scheduledJobIndexExists", "", "scheduledJobIndexHealth", "Lorg/opensearch/cluster/health/ClusterIndexHealth;", "Companion", "alerting-core"})
public final class ScheduledJobIndices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AdminClient client;
    @NotNull
    private final ClusterService clusterService;

    public ScheduledJobIndices(@NotNull AdminClient client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
    }

    public final void initScheduledJobIndex(@NotNull ActionListener<CreateIndexResponse> actionListener) {
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.scheduledJobIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opendistro-alerting-config").mapping(Companion.scheduledJobMappings()).settings(Settings.builder().put("index.hidden", true).build());
            this.client.indices().create(indexRequest, actionListener);
        }
    }

    public final boolean scheduledJobIndexExists() {
        ClusterState clusterState = this.clusterService.state();
        return clusterState.getRoutingTable().hasIndex(".opendistro-alerting-config");
    }

    @Nullable
    public final ClusterIndexHealth scheduledJobIndexHealth() {
        ClusterIndexHealth indexHealth = null;
        if (this.scheduledJobIndexExists()) {
            IndexRoutingTable indexRoutingTable = this.clusterService.state().getRoutingTable().index(".opendistro-alerting-config");
            IndexMetadata indexMetaData = this.clusterService.state().metadata().index(".opendistro-alerting-config");
            indexHealth = new ClusterIndexHealth(indexMetaData, indexRoutingTable);
        }
        return indexHealth;
    }

    @JvmStatic
    @NotNull
    public static final String scheduledJobMappings() {
        return Companion.scheduledJobMappings();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/alerting/core/ScheduledJobIndices$Companion;", "", "()V", "scheduledJobMappings", "", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String scheduledJobMappings() {
            URL uRL = ScheduledJobIndices.class.getClassLoader().getResource("mappings/scheduled-jobs.json");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"ScheduledJobIndices::cla\u2026ngs/scheduled-jobs.json\")");
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            return new String(byArray, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

