/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.rest.RestRequest;

public class IndexAnomalyDetectorRequest
extends ActionRequest {
    private String detectorID;
    private long seqNo;
    private long primaryTerm;
    private WriteRequest.RefreshPolicy refreshPolicy;
    private AnomalyDetector detector;
    private RestRequest.Method method;
    private TimeValue requestTimeout;
    private Integer maxSingleEntityAnomalyDetectors;
    private Integer maxMultiEntityAnomalyDetectors;
    private Integer maxAnomalyFeatures;

    public IndexAnomalyDetectorRequest(StreamInput in) throws IOException {
        super(in);
        this.detectorID = in.readString();
        this.seqNo = in.readLong();
        this.primaryTerm = in.readLong();
        this.refreshPolicy = (WriteRequest.RefreshPolicy)in.readEnum(WriteRequest.RefreshPolicy.class);
        this.detector = new AnomalyDetector(in);
        this.method = (RestRequest.Method)in.readEnum(RestRequest.Method.class);
        this.requestTimeout = in.readTimeValue();
        this.maxSingleEntityAnomalyDetectors = in.readInt();
        this.maxMultiEntityAnomalyDetectors = in.readInt();
        this.maxAnomalyFeatures = in.readInt();
    }

    public IndexAnomalyDetectorRequest(String detectorID, long seqNo, long primaryTerm, WriteRequest.RefreshPolicy refreshPolicy, AnomalyDetector detector, RestRequest.Method method, TimeValue requestTimeout, Integer maxSingleEntityAnomalyDetectors, Integer maxMultiEntityAnomalyDetectors, Integer maxAnomalyFeatures) {
        this.detectorID = detectorID;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.detector = detector;
        this.method = method;
        this.requestTimeout = requestTimeout;
        this.maxSingleEntityAnomalyDetectors = maxSingleEntityAnomalyDetectors;
        this.maxMultiEntityAnomalyDetectors = maxMultiEntityAnomalyDetectors;
        this.maxAnomalyFeatures = maxAnomalyFeatures;
    }

    public String getDetectorID() {
        return this.detectorID;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public Integer getMaxSingleEntityAnomalyDetectors() {
        return this.maxSingleEntityAnomalyDetectors;
    }

    public Integer getMaxMultiEntityAnomalyDetectors() {
        return this.maxMultiEntityAnomalyDetectors;
    }

    public Integer getMaxAnomalyFeatures() {
        return this.maxAnomalyFeatures;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.detectorID);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeEnum((Enum)this.refreshPolicy);
        this.detector.writeTo(out);
        out.writeEnum((Enum)this.method);
        out.writeTimeValue(this.requestTimeout);
        out.writeInt(this.maxSingleEntityAnomalyDetectors.intValue());
        out.writeInt(this.maxMultiEntityAnomalyDetectors.intValue());
        out.writeInt(this.maxAnomalyFeatures.intValue());
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

