/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;

public class ADSearchHandler {
    private final Logger logger = LogManager.getLogger(ADSearchHandler.class);
    private final Client client;
    private volatile Boolean filterEnabled;

    public ADSearchHandler(Settings settings, ClusterService clusterService, Client client) {
        this.client = client;
        this.filterEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterEnabled = it;
        });
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_SEARCH);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.validateRole(request, user, (ActionListener<SearchResponse>)listener);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void validateRole(SearchRequest request, User user, ActionListener<SearchResponse> listener) {
        if (user == null || !this.filterEnabled.booleanValue()) {
            this.client.search(request, listener);
        } else {
            try {
                ParseUtils.addUserBackendRolesFilter(user, request.source());
                this.logger.debug("Filtering result by " + user.getBackendRoles());
                this.client.search(request, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }
}

