/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.destination.message;

import java.io.IOException;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyDestinationType;
import org.opensearch.commons.destination.util.Util;

public class LegacySNSMessage
extends LegacyBaseMessage {
    private final String subject;
    private final String message;
    private final String roleArn;
    private final String topicArn;
    private final String clusterName;

    private LegacySNSMessage(String destinationName, String roleArn, String topicArn, String clusterName, String subject, String message) {
        super(LegacyDestinationType.LEGACY_SNS, destinationName, message);
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        if (Strings.isNullOrEmpty((String)roleArn) || !Util.isValidIAMArn(roleArn)) {
            throw new IllegalArgumentException("Role arn is missing/invalid: " + roleArn);
        }
        if (Strings.isNullOrEmpty((String)topicArn) || !Util.isValidSNSArn(topicArn)) {
            throw new IllegalArgumentException("Topic arn is missing/invalid: " + topicArn);
        }
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        this.subject = subject;
        this.message = message;
        this.roleArn = roleArn;
        this.topicArn = topicArn;
        this.clusterName = clusterName;
    }

    public LegacySNSMessage(StreamInput streamInput) throws IOException {
        super(streamInput);
        this.subject = streamInput.readString();
        this.message = super.getMessageContent();
        this.roleArn = streamInput.readString();
        this.topicArn = streamInput.readString();
        this.clusterName = streamInput.readString();
    }

    public String toString() {
        return "DestinationType: " + this.getChannelType() + ", DestinationName: " + this.destinationName + ", RoleARn: " + this.roleArn + ", TopicArn: " + this.topicArn + ", ClusterName: " + this.clusterName + ", Subject: " + this.subject + ", Message: " + this.message;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        streamOutput.writeString(this.subject);
        streamOutput.writeString(this.message);
        streamOutput.writeString(this.roleArn);
        streamOutput.writeString(this.topicArn);
        streamOutput.writeString(this.clusterName);
    }

    public static class Builder {
        private final String destinationName;
        private String subject;
        private String message;
        private String roleArn;
        private String topicArn;
        private String clusterName;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
        }

        public Builder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withRole(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public Builder withTopicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public LegacySNSMessage build() {
            return new LegacySNSMessage(this.destinationName, this.roleArn, this.topicArn, this.clusterName, this.subject, this.message);
        }
    }
}

