/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.preprocessor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.ImputePreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.InitialSegmentPreprocessor;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.returntypes.DiVector;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class Preprocessor
implements IPreprocessor<AnomalyDescriptor> {
    public static double DEFAULT_NORMALIZATION_PRECISION = 0.001;
    public static int DEFAULT_START_NORMALIZATION = 10;
    public static int DEFAULT_STOP_NORMALIZATION = Integer.MAX_VALUE;
    public static int DEFAULT_CLIP_NORMALIZATION = 10;
    public static boolean DEFAULT_NORMALIZATION = false;
    public static boolean DEFAULT_DIFFERENCING = false;
    public static double DEFAULT_USE_IMPUTED_FRACTION = 0.5;
    public static int MINIMUM_OBSERVATIONS_FOR_EXPECTED = 100;
    protected Deviation[] deviationList;
    protected Deviation timeStampDeviation;
    protected boolean normalizeTime;
    protected boolean augmentTime;
    protected long[] previousTimeStamps;
    protected int internalTimeStamp = 0;
    protected double[][] initialValues;
    protected long[] initialTimeStamps;
    protected int startNormalization;
    protected Integer stopNormalization;
    protected int valuesSeen = 0;
    protected double[] defaultFill;
    protected double useImputedFraction = DEFAULT_USE_IMPUTED_FRACTION;
    protected int numberOfImputed;
    protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
    protected double clipFactor = DEFAULT_CLIP_NORMALIZATION;
    protected double[] lastShingledInput;
    protected double[] lastShingledPoint;
    protected TransformMethod transformMethod;
    protected int shingleSize;
    protected int dimension;
    protected int inputLength;
    protected double[] weights;
    protected ForestMode mode;
    protected Deviation dataQuality;

    public Preprocessor(Builder<?> builder) {
        CommonUtils.checkArgument((builder.transformMethod != null ? 1 : 0) != 0, (String)"transform required");
        CommonUtils.checkArgument((builder.forestMode != null ? 1 : 0) != 0, (String)" forest mode is required");
        CommonUtils.checkArgument((builder.inputLength > 0 ? 1 : 0) != 0, (String)"incorrect input length");
        CommonUtils.checkArgument((builder.shingleSize > 0 ? 1 : 0) != 0, (String)"incorrect shingle size");
        CommonUtils.checkArgument((builder.dimensions > 0 ? 1 : 0) != 0, (String)"incorrect dimensions");
        CommonUtils.checkArgument((builder.shingleSize == 1 || builder.dimensions % builder.shingleSize == 0 ? 1 : 0) != 0, (String)" shingle size should divide the dimensions");
        CommonUtils.checkArgument((builder.forestMode == ForestMode.TIME_AUGMENTED || builder.inputLength == builder.dimensions || builder.inputLength * builder.shingleSize == builder.dimensions ? 1 : 0) != 0, (String)"incorrect input size");
        CommonUtils.checkArgument((builder.forestMode != ForestMode.TIME_AUGMENTED || (builder.inputLength + 1) * builder.shingleSize == builder.dimensions ? 1 : 0) != 0, (String)"incorrect input size");
        CommonUtils.checkArgument((builder.startNormalization <= builder.stopNormalization ? 1 : 0) != 0, (String)"incorrect normalization parameters");
        CommonUtils.checkArgument((builder.startNormalization > 0 || !builder.normalizeTime ? 1 : 0) != 0, (String)" start of normalization cannot be 0");
        CommonUtils.checkArgument((builder.startNormalization > 0 || builder.transformMethod != TransformMethod.NORMALIZE && builder.transformMethod != TransformMethod.NORMALIZE_DIFFERENCE ? 1 : 0) != 0, (String)" start of normalization cannot be 0 for these transformations");
        CommonUtils.checkArgument((builder.weights == null || builder.weights.length >= builder.inputLength ? 1 : 0) != 0, (String)" incorrect weights");
        this.inputLength = builder.inputLength;
        this.dimension = builder.dimensions;
        this.shingleSize = builder.shingleSize;
        this.mode = builder.forestMode;
        this.lastShingledPoint = new double[this.dimension];
        this.transformMethod = builder.transformMethod;
        this.startNormalization = builder.startNormalization;
        this.stopNormalization = builder.stopNormalization;
        this.normalizeTime = builder.normalizeTime;
        this.weights = new double[this.inputLength + 1];
        Arrays.fill(this.weights, 1.0);
        if (builder.weights != null) {
            if (builder.weights.length == this.inputLength) {
                System.arraycopy(builder.weights, 0, this.weights, 0, this.inputLength);
                this.weights[this.inputLength] = builder.weightTime;
            } else {
                System.arraycopy(builder.weights, 0, this.weights, 0, this.inputLength + 1);
            }
        } else {
            this.weights[this.inputLength] = builder.weightTime;
        }
        this.previousTimeStamps = new long[this.shingleSize];
        this.lastShingledInput = this.inputLength == this.dimension ? new double[this.dimension] : new double[this.shingleSize * this.inputLength];
        double discount = builder.timeDecay;
        this.dataQuality = builder.dataQuality.orElse(new Deviation(discount));
        if (this.transformMethod != TransformMethod.NONE && this.transformMethod != TransformMethod.DIFFERENCE) {
            if (builder.deviations.isPresent()) {
                this.deviationList = builder.deviations.get();
            } else {
                this.deviationList = new Deviation[this.inputLength];
                for (int i = 0; i < this.inputLength; ++i) {
                    this.deviationList[i] = new Deviation(discount);
                }
            }
        }
        this.timeStampDeviation = builder.timeDeviation.orElse(new Deviation(discount));
        if (this.mode == ForestMode.STREAMING_IMPUTE) {
            this.imputationMethod = builder.imputationMethod;
            this.normalizeTime = true;
            if (this.imputationMethod == ImputationMethod.FIXED_VALUES) {
                int baseDimension = builder.dimensions / builder.shingleSize;
                CommonUtils.checkArgument((builder.fillValues != null && builder.fillValues.length == baseDimension ? 1 : 0) != 0, (String)" the number of values should match the shingled input");
                this.defaultFill = Arrays.copyOf(builder.fillValues, builder.fillValues.length);
            }
            this.useImputedFraction = builder.useImputedFraction.orElse(0.5);
        }
    }

    public static boolean requireInitialSegment(boolean normalizeTime, TransformMethod transformMethod) {
        return normalizeTime || transformMethod == TransformMethod.NORMALIZE || transformMethod == TransformMethod.NORMALIZE_DIFFERENCE;
    }

    AnomalyDescriptor initialSetup(AnomalyDescriptor description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        description.setForestMode(this.mode);
        description.setTransformMethod(this.transformMethod);
        description.setImputationMethod(this.imputationMethod);
        description.setNumberOfTrees(forest.getNumberOfTrees());
        description.setTotalUpdates(forest.getTotalUpdates());
        description.setLastAnomalyInternalTimestamp(lastAnomalyDescriptor.getInternalTimeStamp());
        description.setLastExpectedRCFPoint(lastAnomalyDescriptor.getExpectedRCFPoint());
        description.setDataConfidence(forest.getTimeDecay(), this.valuesSeen, forest.getOutputAfter(), this.dataQuality.getMean());
        description.setShingleSize(this.shingleSize);
        description.setInputLength(this.inputLength);
        description.setDimension(this.dimension);
        description.setReasonableForecast(this.internalTimeStamp > MINIMUM_OBSERVATIONS_FOR_EXPECTED && this.shingleSize * this.inputLength >= 4);
        return description;
    }

    @Override
    public AnomalyDescriptor preProcess(AnomalyDescriptor description, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] point;
        this.initialSetup(description, lastAnomalyDescriptor, forest);
        double[] inputPoint = description.getCurrentInput();
        long timestamp = description.getInputTimestamp();
        double[] scaledInput = this.getScaledInput(inputPoint, timestamp, null, 0.0);
        if (scaledInput == null) {
            return description;
        }
        if (forest.isInternalShinglingEnabled()) {
            point = forest.transformToShingledPoint(scaledInput);
        } else {
            int dimension = forest.getDimensions();
            if (scaledInput.length == dimension) {
                point = scaledInput;
            } else {
                point = new double[dimension];
                System.arraycopy(this.getLastShingledPoint(), scaledInput.length, point, 0, dimension - scaledInput.length);
                System.arraycopy(scaledInput, 0, point, dimension - scaledInput.length, scaledInput.length);
            }
        }
        description.setRCFPoint(point);
        description.setInternalTimeStamp(this.internalTimeStamp);
        description.setNumberOfNewImputes(0);
        return description;
    }

    @Override
    public AnomalyDescriptor postProcess(AnomalyDescriptor result, IRCFComputeDescriptor lastAnomalyDescriptor, RandomCutForest forest) {
        double[] point = result.getRCFPoint();
        if (point == null) {
            return result;
        }
        if (result.getAnomalyGrade() > 0.0) {
            this.addRelevantAttribution(result);
        }
        double[] inputPoint = result.getCurrentInput();
        long timestamp = result.getInputTimestamp();
        this.updateState(inputPoint, point, timestamp, this.previousTimeStamps[this.shingleSize - 1]);
        ++this.valuesSeen;
        this.dataQuality.update(1.0);
        if (forest.isInternalShinglingEnabled()) {
            int length = this.inputLength + (this.mode == ForestMode.TIME_AUGMENTED ? 1 : 0);
            double[] scaledInput = new double[length];
            System.arraycopy(point, point.length - length, scaledInput, 0, length);
            forest.update(scaledInput);
        } else {
            forest.update(point);
        }
        return result;
    }

    protected void addRelevantAttribution(AnomalyDescriptor result) {
        int base = this.dimension / this.shingleSize;
        double[] reference = result.getCurrentInput();
        double[] point = result.getRCFPoint();
        double[] newPoint = result.getExpectedRCFPoint();
        int index = result.getRelativeIndex();
        if (newPoint != null) {
            if (index < 0 && result.isStartOfAnomaly()) {
                reference = this.getShingledInput(this.shingleSize + index);
                result.setPastValues(reference);
                result.setPastTimeStamp(this.getTimeStamp(this.shingleSize - 1 + index));
            }
            if (this.mode == ForestMode.TIME_AUGMENTED) {
                int endPosition = (this.shingleSize - 1 + index + 1) * this.dimension / this.shingleSize;
                double timeGap = newPoint[endPosition - 1] - point[endPosition - 1];
                long expectedTimestamp = timeGap == 0.0 ? this.getTimeStamp(this.shingleSize - 1 + index) : this.inverseMapTime(timeGap, index);
                result.setExpectedTimeStamp(expectedTimestamp);
            }
            double[] values = this.getExpectedValue(index, reference, point, newPoint);
            result.setExpectedValues(0, values, 1.0);
        }
        int startPosition = (this.shingleSize - 1 + result.getRelativeIndex()) * base;
        DiVector attribution = result.getAttribution();
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            --base;
        }
        double[] flattenedAttribution = new double[base];
        for (int i = 0; i < base; ++i) {
            flattenedAttribution[i] = attribution.getHighLowSum(startPosition + i);
        }
        result.setRelevantAttribution(flattenedAttribution);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            result.setTimeAttribution(attribution.getHighLowSum(startPosition + base));
        }
    }

    protected long inverseMapTime(double gap, int relativePosition) {
        CommonUtils.checkArgument((this.shingleSize + relativePosition >= 0 ? 1 : 0) != 0, (String)" error");
        double factor = this.weights[this.inputLength];
        if (factor == 0.0) {
            return 0L;
        }
        if (this.normalizeTime) {
            return (long)Math.floor((double)this.previousTimeStamps[this.shingleSize - 1 + relativePosition] + this.timeStampDeviation.getMean() + 2.0 * gap * this.timeStampDeviation.getDeviation() / factor);
        }
        return (long)Math.floor(gap / factor + (double)this.previousTimeStamps[this.shingleSize - 1 + relativePosition] + this.timeStampDeviation.getMean());
    }

    public double[] getShingledInput(int index) {
        int base = this.lastShingledInput.length / this.shingleSize;
        double[] values = new double[base];
        System.arraycopy(this.lastShingledInput, index * base, values, 0, base);
        return values;
    }

    protected double[] getExpectedValue(int relativeBlockIndex, double[] reference, double[] point, double[] newPoint) {
        int base = this.dimension / this.shingleSize;
        int startPosition = (this.shingleSize - 1 + relativeBlockIndex) * base;
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            --base;
        }
        double[] values = this.invert(base, startPosition, relativeBlockIndex, newPoint);
        for (int i = 0; i < base; ++i) {
            double currentValue = reference.length == base ? reference[i] : reference[startPosition + i];
            values[i] = point[startPosition + i] == newPoint[startPosition + i] ? currentValue : values[i];
        }
        return values;
    }

    protected double[] invert(int base, int startPosition, int relativeBlockIndex, double[] newPoint) {
        double[] values = new double[base];
        for (int i = 0; i < base; ++i) {
            values[i] = this.inverseTransform(newPoint[startPosition + i], i, relativeBlockIndex);
        }
        return values;
    }

    protected double inverseTransform(double value, int index, int relativeBlockIndex) {
        if (this.transformMethod == TransformMethod.NONE) {
            return value;
        }
        if (!Preprocessor.requireInitialSegment(false, this.transformMethod)) {
            if (this.transformMethod == TransformMethod.WEIGHTED) {
                return this.weights[index] == 0.0 ? 0.0 : value / this.weights[index];
            }
            if (this.transformMethod == TransformMethod.SUBTRACT_MA) {
                return this.weights[index] == 0.0 ? 0.0 : (value + this.deviationList[index].getMean()) / this.weights[index];
            }
            double[] difference = this.getShingledInput(this.shingleSize - 1 + relativeBlockIndex);
            CommonUtils.checkArgument((this.transformMethod == TransformMethod.DIFFERENCE ? 1 : 0) != 0, (String)"incorrect configuration");
            return this.weights[index] == 0.0 ? 0.0 : (value + difference[index]) / this.weights[index];
        }
        if (this.transformMethod == TransformMethod.NORMALIZE) {
            double newValue = this.deviationList[index].getMean() + 2.0 * value * (this.deviationList[index].getDeviation() + DEFAULT_NORMALIZATION_PRECISION);
            return this.weights[index] == 0.0 ? 0.0 : newValue / this.weights[index];
        }
        CommonUtils.checkArgument((this.transformMethod == TransformMethod.NORMALIZE_DIFFERENCE ? 1 : 0) != 0, (String)"incorrect configuration");
        double[] difference = this.getShingledInput(this.shingleSize - 1 + relativeBlockIndex);
        double newValue = difference[index] + this.deviationList[index].getMean() + 2.0 * value * (this.deviationList[index].getDeviation() + DEFAULT_NORMALIZATION_PRECISION);
        return this.weights[index] == 0.0 ? 0.0 : newValue / this.weights[index];
    }

    protected double[] getScaledInput(double[] input, long timestamp, double[] defaultFactors, double defaultTimeFactor) {
        double[] scaledInput = this.transformValues(input, defaultFactors);
        if (this.mode == ForestMode.TIME_AUGMENTED) {
            scaledInput = this.augmentTime(scaledInput, timestamp, defaultTimeFactor);
        }
        return scaledInput;
    }

    protected void updateShingle(double[] inputPoint, double[] scaledPoint) {
        if (inputPoint.length == this.lastShingledInput.length) {
            this.lastShingledInput = Arrays.copyOf(inputPoint, inputPoint.length);
        } else {
            this.shiftLeft(this.lastShingledInput, inputPoint.length);
            this.copyAtEnd(this.lastShingledInput, inputPoint);
        }
        if (scaledPoint.length == this.lastShingledPoint.length) {
            this.lastShingledPoint = Arrays.copyOf(scaledPoint, scaledPoint.length);
        } else {
            this.shiftLeft(this.lastShingledPoint, scaledPoint.length);
            this.copyAtEnd(this.lastShingledPoint, scaledPoint);
        }
    }

    protected void updateTimestamps(long timestamp) {
        for (int i = 0; i < this.shingleSize - 1; ++i) {
            this.previousTimeStamps[i] = this.previousTimeStamps[i + 1];
        }
        this.previousTimeStamps[this.shingleSize - 1] = timestamp;
        ++this.internalTimeStamp;
    }

    void updateDeviation(double[] inputPoint, double[] lastShingledInput) {
        for (int i = 0; i < inputPoint.length; ++i) {
            double value = inputPoint[i];
            if (this.transformMethod == TransformMethod.DIFFERENCE || this.transformMethod == TransformMethod.NORMALIZE_DIFFERENCE) {
                value -= lastShingledInput[lastShingledInput.length - this.inputLength + i];
            }
            this.deviationList[i].update(value);
        }
    }

    protected void updateState(double[] inputPoint, double[] scaledInput, long timestamp, long previous) {
        if (this.timeStampDeviation != null) {
            this.timeStampDeviation.update(timestamp - previous);
        }
        this.updateTimestamps(timestamp);
        if (this.deviationList != null) {
            this.updateDeviation(inputPoint, this.lastShingledInput);
        }
        this.updateShingle(inputPoint, scaledInput);
    }

    protected void copyAtEnd(double[] array, double[] small) {
        CommonUtils.checkArgument((array.length > small.length ? 1 : 0) != 0, (String)" incorrect operation ");
        System.arraycopy(small, 0, array, array.length - small.length, small.length);
    }

    protected double[] copyIfNotnull(double[] array) {
        return array == null ? null : Arrays.copyOf(array, array.length);
    }

    protected void shiftLeft(double[] array, int baseDimension) {
        for (int i = 0; i < array.length - baseDimension; ++i) {
            array[i] = array[i + baseDimension];
        }
    }

    protected double normalize(double value, Deviation deviation, double factor) {
        double currentFactor;
        double d = currentFactor = factor != 0.0 ? factor : deviation.getDeviation();
        if (value - deviation.getMean() >= 2.0 * this.clipFactor * (currentFactor + DEFAULT_NORMALIZATION_PRECISION)) {
            return this.clipFactor;
        }
        if (value - deviation.getMean() < -2.0 * this.clipFactor * (currentFactor + DEFAULT_NORMALIZATION_PRECISION)) {
            return -this.clipFactor;
        }
        return (value - deviation.getMean()) / (2.0 * (currentFactor + DEFAULT_NORMALIZATION_PRECISION));
    }

    protected double[] transformValues(double[] inputPoint, double[] factors) {
        double[] input;
        block11: {
            block9: {
                block12: {
                    block10: {
                        if (this.transformMethod == TransformMethod.NONE) {
                            return inputPoint;
                        }
                        input = new double[inputPoint.length];
                        if (Preprocessor.requireInitialSegment(false, this.transformMethod)) break block9;
                        if (this.transformMethod != TransformMethod.WEIGHTED) break block10;
                        for (int i = 0; i < inputPoint.length; ++i) {
                            input[i] = inputPoint[i] * this.weights[i];
                        }
                        break block11;
                    }
                    if (this.transformMethod != TransformMethod.SUBTRACT_MA) break block12;
                    for (int i = 0; i < inputPoint.length; ++i) {
                        input[i] = this.internalTimeStamp == 0 ? 0.0 : this.weights[i] * (inputPoint[i] - this.deviationList[i].getMean());
                    }
                    break block11;
                }
                if (this.transformMethod != TransformMethod.DIFFERENCE) break block11;
                for (int i = 0; i < input.length; ++i) {
                    input[i] = this.internalTimeStamp == 0 ? 0.0 : this.weights[i] * (inputPoint[i] - this.lastShingledInput[this.lastShingledInput.length - this.inputLength + i]);
                }
                break block11;
            }
            if (this.transformMethod == TransformMethod.NORMALIZE) {
                for (int i = 0; i < input.length; ++i) {
                    input[i] = this.weights[i] * this.normalize(inputPoint[i], this.deviationList[i], factors == null ? 0.0 : factors[i]);
                }
            } else if (this.transformMethod == TransformMethod.NORMALIZE_DIFFERENCE) {
                for (int i = 0; i < input.length; ++i) {
                    double value = this.internalTimeStamp == 0 ? 0.0 : inputPoint[i] - this.lastShingledInput[this.lastShingledInput.length - this.inputLength + i];
                    input[i] = this.weights[i] * this.normalize(value, this.deviationList[i], factors == null ? 0.0 : factors[i]);
                }
            }
        }
        return input;
    }

    protected double[] augmentTime(double[] normalized, long timestamp, double timeFactor) {
        double[] scaledInput = new double[normalized.length + 1];
        System.arraycopy(normalized, 0, scaledInput, 0, normalized.length);
        if (this.valuesSeen <= 1) {
            scaledInput[normalized.length] = 0.0;
        } else {
            double timeShift = timestamp - this.previousTimeStamps[this.shingleSize - 1];
            scaledInput[normalized.length] = this.weights[this.inputLength] * (this.normalizeTime ? this.normalize(timeShift, this.timeStampDeviation, timeFactor) : timeShift);
        }
        return scaledInput;
    }

    public long[] getInitialTimeStamps() {
        return this.initialTimeStamps == null ? null : Arrays.copyOf(this.initialTimeStamps, this.initialTimeStamps.length);
    }

    public void setInitialTimeStamps(long[] values) {
        this.initialTimeStamps = values == null ? null : Arrays.copyOf(values, values.length);
    }

    public double[][] getInitialValues() {
        if (this.initialValues == null) {
            return null;
        }
        double[][] result = new double[this.initialValues.length][];
        for (int i = 0; i < this.initialValues.length; ++i) {
            result[i] = this.copyIfNotnull(this.initialValues[i]);
        }
        return result;
    }

    public void setInitialValues(double[][] values) {
        if (values == null) {
            this.initialValues = null;
        } else {
            this.initialValues = new double[values.length][];
            for (int i = 0; i < values.length; ++i) {
                this.initialValues[i] = this.copyIfNotnull(values[i]);
            }
        }
    }

    public double[] getLastShingledInput() {
        return this.copyIfNotnull(this.lastShingledInput);
    }

    public void setLastShingledInput(double[] point) {
        this.lastShingledInput = this.copyIfNotnull(point);
    }

    public void setPreviousTimeStamps(long[] values) {
        if (values == null) {
            this.numberOfImputed = this.shingleSize;
            this.previousTimeStamps = null;
        } else {
            CommonUtils.checkArgument((values.length == this.shingleSize ? 1 : 0) != 0, (String)" incorrect length ");
            this.previousTimeStamps = Arrays.copyOf(values, values.length);
            this.numberOfImputed = 0;
            for (int i = 0; i < this.previousTimeStamps.length - 1; ++i) {
                if (this.previousTimeStamps[i] != this.previousTimeStamps[i + 1]) continue;
                ++this.numberOfImputed;
            }
        }
    }

    public Deviation getTimeStampDeviation() {
        return this.timeStampDeviation;
    }

    public long[] getPreviousTimeStamps() {
        return this.previousTimeStamps == null ? null : Arrays.copyOf(this.previousTimeStamps, this.previousTimeStamps.length);
    }

    public double[] getWeights() {
        return this.copyIfNotnull(this.weights);
    }

    public void setWeights(double[] values) {
        this.weights = this.copyIfNotnull(values);
    }

    public double[] getDefaultFill() {
        return this.copyIfNotnull(this.defaultFill);
    }

    public void setDefaultFill(double[] values) {
        this.defaultFill = this.copyIfNotnull(values);
    }

    public long getTimeStamp(int index) {
        return this.previousTimeStamps[index];
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Generated
    public Deviation[] getDeviationList() {
        return this.deviationList;
    }

    @Generated
    public boolean isNormalizeTime() {
        return this.normalizeTime;
    }

    @Generated
    public boolean isAugmentTime() {
        return this.augmentTime;
    }

    @Generated
    public int getInternalTimeStamp() {
        return this.internalTimeStamp;
    }

    @Generated
    public int getStartNormalization() {
        return this.startNormalization;
    }

    @Generated
    public Integer getStopNormalization() {
        return this.stopNormalization;
    }

    @Generated
    public int getValuesSeen() {
        return this.valuesSeen;
    }

    @Generated
    public double getUseImputedFraction() {
        return this.useImputedFraction;
    }

    @Generated
    public int getNumberOfImputed() {
        return this.numberOfImputed;
    }

    @Generated
    public ImputationMethod getImputationMethod() {
        return this.imputationMethod;
    }

    @Generated
    public double getClipFactor() {
        return this.clipFactor;
    }

    @Generated
    public double[] getLastShingledPoint() {
        return this.lastShingledPoint;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Generated
    public int getShingleSize() {
        return this.shingleSize;
    }

    @Generated
    public int getDimension() {
        return this.dimension;
    }

    @Generated
    public int getInputLength() {
        return this.inputLength;
    }

    @Generated
    public ForestMode getMode() {
        return this.mode;
    }

    @Generated
    public Deviation getDataQuality() {
        return this.dataQuality;
    }

    @Generated
    public void setDeviationList(Deviation[] deviationList) {
        this.deviationList = deviationList;
    }

    @Generated
    public void setTimeStampDeviation(Deviation timeStampDeviation) {
        this.timeStampDeviation = timeStampDeviation;
    }

    @Generated
    public void setNormalizeTime(boolean normalizeTime) {
        this.normalizeTime = normalizeTime;
    }

    @Generated
    public void setAugmentTime(boolean augmentTime) {
        this.augmentTime = augmentTime;
    }

    @Generated
    public void setInternalTimeStamp(int internalTimeStamp) {
        this.internalTimeStamp = internalTimeStamp;
    }

    @Generated
    public void setStartNormalization(int startNormalization) {
        this.startNormalization = startNormalization;
    }

    @Generated
    public void setStopNormalization(Integer stopNormalization) {
        this.stopNormalization = stopNormalization;
    }

    @Generated
    public void setValuesSeen(int valuesSeen) {
        this.valuesSeen = valuesSeen;
    }

    @Generated
    public void setUseImputedFraction(double useImputedFraction) {
        this.useImputedFraction = useImputedFraction;
    }

    @Generated
    public void setNumberOfImputed(int numberOfImputed) {
        this.numberOfImputed = numberOfImputed;
    }

    @Generated
    public void setImputationMethod(ImputationMethod imputationMethod) {
        this.imputationMethod = imputationMethod;
    }

    @Generated
    public void setClipFactor(double clipFactor) {
        this.clipFactor = clipFactor;
    }

    @Generated
    public void setLastShingledPoint(double[] lastShingledPoint) {
        this.lastShingledPoint = lastShingledPoint;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setShingleSize(int shingleSize) {
        this.shingleSize = shingleSize;
    }

    @Generated
    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setInputLength(int inputLength) {
        this.inputLength = inputLength;
    }

    @Generated
    public void setMode(ForestMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setDataQuality(Deviation dataQuality) {
        this.dataQuality = dataQuality;
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int startNormalization = DEFAULT_START_NORMALIZATION;
        protected Integer stopNormalization = DEFAULT_STOP_NORMALIZATION;
        protected double timeDecay;
        protected Optional<Long> randomSeed = Optional.empty();
        protected int shingleSize = 1;
        protected double anomalyRate = 0.01;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected int inputLength;
        protected boolean normalizeTime = false;
        protected double[] fillValues = null;
        protected double[] weights = null;
        protected double weightTime = 1.0;
        protected ThresholdedRandomCutForest thresholdedRandomCutForest = null;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected Optional<Deviation[]> deviations = Optional.empty();
        protected Optional<Deviation> timeDeviation = Optional.empty();
        protected Optional<Deviation> dataQuality = Optional.empty();

        public Preprocessor build() {
            if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                return new ImputePreprocessor(this);
            }
            if (Preprocessor.requireInitialSegment(this.normalizeTime, this.transformMethod)) {
                return new InitialSegmentPreprocessor(this);
            }
            return new Preprocessor(this);
        }

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T inputLength(int inputLength) {
            this.inputLength = inputLength;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = startNormalization;
            return (T)this;
        }

        public T stopNormalization(Integer stopNormalization) {
            this.stopNormalization = stopNormalization;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = timeDecay;
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = values == null ? null : Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weights(double[] values) {
            this.weights = values == null ? null : Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = value;
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T deviations(Deviation[] deviations) {
            this.deviations = Optional.of(deviations);
            return (T)this;
        }

        public T dataQuality(Deviation dataQuality) {
            this.dataQuality = Optional.of(dataQuality);
            return (T)this;
        }

        public T timeDeviation(Deviation timeDeviation) {
            this.timeDeviation = Optional.of(timeDeviation);
            return (T)this;
        }
    }
}

