/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tJ \u0010\n\u001a\u00020\u00072\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\t0\fJ\u001a\u0010\r\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tJ\u001a\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformProcessedBucketLog;", "", "()V", "processedBuckets", "", "", "addBucket", "", "bucket", "", "addBuckets", "buckets", "", "computeBucketHash", "isNotProcessed", "", "isProcessed", "Companion", "opensearch-index-management"})
public final class TransformProcessedBucketLog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<String> processedBuckets = new HashSet();
    public static final int MAX_SIZE = 100000000;
    public static final int HEX_RADIX = 16;

    public final void addBuckets(@NotNull List<? extends Map<String, ? extends Object>> buckets) {
        Intrinsics.checkNotNullParameter(buckets, (String)"buckets");
        Iterable $this$forEach$iv = buckets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            this.addBucket(it);
        }
    }

    public final void addBucket(@NotNull Map<String, ? extends Object> bucket) {
        Intrinsics.checkNotNullParameter(bucket, (String)"bucket");
        if (this.processedBuckets.size() >= 100000000) {
            return;
        }
        this.processedBuckets.add(this.computeBucketHash(bucket));
    }

    public final boolean isProcessed(@NotNull Map<String, ? extends Object> bucket) {
        Intrinsics.checkNotNullParameter(bucket, (String)"bucket");
        return this.processedBuckets.contains(this.computeBucketHash(bucket));
    }

    public final boolean isNotProcessed(@NotNull Map<String, ? extends Object> bucket) {
        Intrinsics.checkNotNullParameter(bucket, (String)"bucket");
        return !this.isProcessed(bucket);
    }

    @NotNull
    public final String computeBucketHash(@NotNull Map<String, ? extends Object> bucket) {
        Intrinsics.checkNotNullParameter(bucket, (String)"bucket");
        MessageDigest md5Crypt = MessageDigest.getInstance("MD5");
        Iterable $this$sortedBy$iv = bucket.entrySet();
        boolean $i$f$sortedBy = false;
        Object object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        List it = object;
        boolean bl = false;
        Iterable $this$forEach$iv = it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            byte[] byArray2;
            String string;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            if (entry.getValue() == null) {
                string = "null";
                byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                byArray = byArray2;
            } else {
                string = entry.getValue().toString();
                byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                byArray = byArray2;
            }
            md5Crypt.update(byArray);
        }
        object = new BigInteger(1, md5Crypt.digest()).toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"BigInteger(1, md5Crypt.d\u2026st()).toString(HEX_RADIX)");
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformProcessedBucketLog$Companion;", "", "()V", "HEX_RADIX", "", "MAX_SIZE", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

