/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.MLModelConfig;

public class TextEmbeddingModelConfig
extends MLModelConfig {
    public static final String PARSE_FIELD_NAME = FunctionName.TEXT_EMBEDDING.name();
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(TextEmbeddingModelConfig.class, new ParseField(PARSE_FIELD_NAME, new String[0]), it -> TextEmbeddingModelConfig.parse(it));
    public static final String EMBEDDING_DIMENSION_FIELD = "embedding_dimension";
    public static final String FRAMEWORK_TYPE_FIELD = "framework_type";
    private Integer embeddingDimension;
    private FrameworkType frameworkType;

    public TextEmbeddingModelConfig(String modelType, Integer embeddingDimension, FrameworkType frameworkType, String allConfig) {
        super(modelType, allConfig);
        if (embeddingDimension == null) {
            throw new IllegalArgumentException("embedding dimension is null");
        }
        if (frameworkType == null) {
            throw new IllegalArgumentException("framework type is null");
        }
        this.embeddingDimension = embeddingDimension;
        this.frameworkType = frameworkType;
    }

    public static TextEmbeddingModelConfig parse(XContentParser parser) throws IOException {
        String modelType = null;
        Integer embeddingDimension = null;
        FrameworkType frameworkType = null;
        String allConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_type": {
                    modelType = parser.text();
                    continue block12;
                }
                case "embedding_dimension": {
                    embeddingDimension = parser.intValue();
                    continue block12;
                }
                case "framework_type": {
                    frameworkType = FrameworkType.from(parser.text().toUpperCase(Locale.ROOT));
                    continue block12;
                }
                case "all_config": {
                    allConfig = parser.text();
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return new TextEmbeddingModelConfig(modelType, embeddingDimension, frameworkType, allConfig);
    }

    public String getWriteableName() {
        return PARSE_FIELD_NAME;
    }

    public TextEmbeddingModelConfig(StreamInput in) throws IOException {
        super(in);
        this.embeddingDimension = in.readInt();
        this.frameworkType = (FrameworkType)in.readEnum(FrameworkType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.embeddingDimension.intValue());
        out.writeEnum((Enum)this.frameworkType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelType != null) {
            builder.field("model_type", this.modelType);
        }
        if (this.embeddingDimension != null) {
            builder.field(EMBEDDING_DIMENSION_FIELD, this.embeddingDimension);
        }
        if (this.frameworkType != null) {
            builder.field(FRAMEWORK_TYPE_FIELD, (Object)this.frameworkType);
        }
        if (this.allConfig != null) {
            builder.field("all_config", this.allConfig);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static TextEmbeddingModelConfigBuilder builder() {
        return new TextEmbeddingModelConfigBuilder();
    }

    @Generated
    public TextEmbeddingModelConfigBuilder toBuilder() {
        return new TextEmbeddingModelConfigBuilder().modelType(this.modelType).embeddingDimension(this.embeddingDimension).frameworkType(this.frameworkType).allConfig(this.allConfig);
    }

    @Generated
    public void setEmbeddingDimension(Integer embeddingDimension) {
        this.embeddingDimension = embeddingDimension;
    }

    @Generated
    public void setFrameworkType(FrameworkType frameworkType) {
        this.frameworkType = frameworkType;
    }

    @Generated
    public Integer getEmbeddingDimension() {
        return this.embeddingDimension;
    }

    @Generated
    public FrameworkType getFrameworkType() {
        return this.frameworkType;
    }

    public static enum FrameworkType {
        HUGGINGFACE_TRANSFORMERS,
        SENTENCE_TRANSFORMERS;


        public static FrameworkType from(String value) {
            try {
                return FrameworkType.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong framework type");
            }
        }
    }

    @Generated
    public static class TextEmbeddingModelConfigBuilder {
        @Generated
        private String modelType;
        @Generated
        private Integer embeddingDimension;
        @Generated
        private FrameworkType frameworkType;
        @Generated
        private String allConfig;

        @Generated
        TextEmbeddingModelConfigBuilder() {
        }

        @Generated
        public TextEmbeddingModelConfigBuilder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder embeddingDimension(Integer embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder frameworkType(FrameworkType frameworkType) {
            this.frameworkType = frameworkType;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfigBuilder allConfig(String allConfig) {
            this.allConfig = allConfig;
            return this;
        }

        @Generated
        public TextEmbeddingModelConfig build() {
            return new TextEmbeddingModelConfig(this.modelType, this.embeddingDimension, this.frameworkType, this.allConfig);
        }

        @Generated
        public String toString() {
            return "TextEmbeddingModelConfig.TextEmbeddingModelConfigBuilder(modelType=" + this.modelType + ", embeddingDimension=" + this.embeddingDimension + ", frameworkType=" + this.frameworkType + ", allConfig=" + this.allConfig + ")";
        }
    }
}

