/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.metrics2.MetricsJsonBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DataNodePeerMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(DataNodePeerMetrics.class);
    private final MutableRollingAverages sendPacketDownstreamRollingAverages;
    private final String name;
    private static final long LOW_THRESHOLD_MS = 5L;
    private static final long MIN_OUTLIER_DETECTION_NODES = 10L;
    private final OutlierDetector slowNodeDetector;
    private final long minOutlierDetectionSamples;

    public DataNodePeerMetrics(String name, Configuration conf) {
        this.name = name;
        this.minOutlierDetectionSamples = conf.getLong("dfs.datanode.peer.metrics.min.outlier.detection.samples", 1000L);
        this.slowNodeDetector = new OutlierDetector(10L, 5L);
        this.sendPacketDownstreamRollingAverages = new MutableRollingAverages("Time");
    }

    public String name() {
        return this.name;
    }

    long getMinOutlierDetectionSamples() {
        return this.minOutlierDetectionSamples;
    }

    public static DataNodePeerMetrics create(String dnName, Configuration conf) {
        String name = "DataNodePeerActivity-" + (dnName.isEmpty() ? "UndefinedDataNodeName" + ThreadLocalRandom.current().nextInt() : dnName.replace(':', '-'));
        return new DataNodePeerMetrics(name, conf);
    }

    public void addSendPacketDownstream(String peerAddr, long elapsedMs) {
        this.sendPacketDownstreamRollingAverages.add(peerAddr, elapsedMs);
    }

    public String dumpSendPacketDownstreamAvgInfoAsJson() {
        MetricsJsonBuilder builder = new MetricsJsonBuilder(null);
        this.sendPacketDownstreamRollingAverages.snapshot((MetricsRecordBuilder)builder, true);
        return builder.toString();
    }

    public void collectThreadLocalStates() {
        this.sendPacketDownstreamRollingAverages.collectThreadLocalStates();
    }

    public Map<String, Double> getOutliers() {
        Map stats = this.sendPacketDownstreamRollingAverages.getStats(this.minOutlierDetectionSamples);
        LOG.trace("DataNodePeerMetrics: Got stats: {}", (Object)stats);
        return this.slowNodeDetector.getOutliers(stats);
    }

    public MutableRollingAverages getSendPacketDownstreamRollingAverages() {
        return this.sendPacketDownstreamRollingAverages;
    }
}

