/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.jwt.keybyoidc;

import com.amazon.dlic.auth.http.jwt.keybyoidc.AuthenticatorUnavailableException;
import com.amazon.dlic.auth.http.jwt.keybyoidc.KeySetProvider;
import com.amazon.dlic.auth.http.jwt.oidc.json.OpenIdProviderConfiguration;
import com.amazon.dlic.util.SettingsBasedSSLConfigurator;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.DefaultObjectMapper;

public class KeySetRetriever
implements KeySetProvider {
    private static final Logger log = LogManager.getLogger(KeySetRetriever.class);
    private static final long CACHE_STATUS_LOG_INTERVAL_MS = 3600000L;
    private String openIdConnectEndpoint;
    private SettingsBasedSSLConfigurator.SSLConfig sslConfig;
    private int requestTimeoutMs = 10000;
    private CacheConfig cacheConfig;
    private HttpCacheStorage oidcHttpCacheStorage;
    private int oidcCacheHits = 0;
    private int oidcCacheMisses = 0;
    private int oidcCacheHitsValidated = 0;
    private int oidcCacheModuleResponses = 0;
    private long oidcRequests = 0L;
    private long lastCacheStatusLog = 0L;

    KeySetRetriever(String openIdConnectEndpoint, SettingsBasedSSLConfigurator.SSLConfig sslConfig, boolean useCacheForOidConnectEndpoint) {
        this.openIdConnectEndpoint = openIdConnectEndpoint;
        this.sslConfig = sslConfig;
        if (useCacheForOidConnectEndpoint) {
            this.cacheConfig = CacheConfig.custom().setMaxCacheEntries(10).setMaxObjectSize(0x100000L).build();
            this.oidcHttpCacheStorage = new BasicHttpCacheStorage(this.cacheConfig);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonWebKeys get() throws AuthenticatorUnavailableException {
        String uri = this.getJwksUri();
        try (CloseableHttpClient httpClient = this.createHttpClient(null);){
            JsonWebKeys jsonWebKeys;
            block16: {
                HttpGet httpGet = new HttpGet(uri);
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                httpGet.setConfig(requestConfig);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try {
                    JsonWebKeys keySet;
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() < 200 || statusLine.getStatusCode() >= 300) {
                        throw new AuthenticatorUnavailableException("Error while getting " + uri + ": " + statusLine);
                    }
                    HttpEntity httpEntity = response.getEntity();
                    if (httpEntity == null) {
                        throw new AuthenticatorUnavailableException("Error while getting " + uri + ": Empty response entity");
                    }
                    jsonWebKeys = keySet = JwkUtils.readJwkSet((InputStream)httpEntity.getContent());
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonWebKeys;
        }
        catch (IOException e) {
            throw new AuthenticatorUnavailableException("Error while getting " + uri + ": " + e, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String getJwksUri() throws AuthenticatorUnavailableException {
        try (CloseableHttpClient httpClient = this.createHttpClient(this.oidcHttpCacheStorage);){
            String string;
            block18: {
                HttpGet httpGet = new HttpGet(this.openIdConnectEndpoint);
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                httpGet.setConfig(requestConfig);
                HttpCacheContext httpContext = null;
                if (this.oidcHttpCacheStorage != null) {
                    httpContext = new HttpCacheContext();
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpContext);
                try {
                    StatusLine statusLine;
                    if (httpContext != null) {
                        this.logCacheResponseStatus(httpContext);
                    }
                    if ((statusLine = response.getStatusLine()).getStatusCode() < 200 || statusLine.getStatusCode() >= 300) {
                        throw new AuthenticatorUnavailableException("Error while getting " + this.openIdConnectEndpoint + ": " + statusLine);
                    }
                    HttpEntity httpEntity = response.getEntity();
                    if (httpEntity == null) {
                        throw new AuthenticatorUnavailableException("Error while getting " + this.openIdConnectEndpoint + ": Empty response entity");
                    }
                    OpenIdProviderConfiguration parsedEntity = (OpenIdProviderConfiguration)DefaultObjectMapper.objectMapper.readValue(httpEntity.getContent(), OpenIdProviderConfiguration.class);
                    string = parsedEntity.getJwksUri();
                    if (response == null) break block18;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new AuthenticatorUnavailableException("Error while getting " + this.openIdConnectEndpoint + ": " + e, e);
        }
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(int httpTimeoutMs) {
        this.requestTimeoutMs = httpTimeoutMs;
    }

    private void logCacheResponseStatus(HttpCacheContext httpContext) {
        ++this.oidcRequests;
        switch (httpContext.getCacheResponseStatus()) {
            case CACHE_HIT: {
                ++this.oidcCacheHits;
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                ++this.oidcCacheModuleResponses;
                break;
            }
            case CACHE_MISS: {
                ++this.oidcCacheMisses;
                break;
            }
            case VALIDATED: {
                ++this.oidcCacheHitsValidated;
            }
        }
        long now = System.currentTimeMillis();
        if (this.oidcRequests >= 2L && now - this.lastCacheStatusLog > 3600000L) {
            log.info("Cache status for KeySetRetriever:\noidcCacheHits: {}\noidcCacheHitsValidated: {}\noidcCacheModuleResponses: {}\noidcCacheMisses: {}", (Object)this.oidcCacheHits, (Object)this.oidcCacheHitsValidated, (Object)this.oidcCacheModuleResponses, (Object)this.oidcCacheMisses);
            this.lastCacheStatusLog = now;
        }
    }

    private CloseableHttpClient createHttpClient(HttpCacheStorage httpCacheStorage) {
        Object builder = httpCacheStorage != null ? CachingHttpClients.custom().setCacheConfig(this.cacheConfig).setHttpCacheStorage(httpCacheStorage) : HttpClients.custom();
        builder.useSystemProperties();
        if (this.sslConfig != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslConfig.toSSLConnectionSocketFactory());
        }
        return builder.build();
    }

    public int getOidcCacheHits() {
        return this.oidcCacheHits;
    }

    public int getOidcCacheMisses() {
        return this.oidcCacheMisses;
    }

    public int getOidcCacheHitsValidated() {
        return this.oidcCacheHitsValidated;
    }

    public int getOidcCacheModuleResponses() {
        return this.oidcCacheModuleResponses;
    }
}

