/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.planner.Planner;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.optimizer.LogicalPlanOptimizer;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.sql.antlr.SQLSyntaxParser;
import org.opensearch.sql.sql.domain.SQLQueryRequest;
import org.opensearch.sql.sql.parser.AstBuilder;

public class SQLService {
    private final SQLSyntaxParser parser;
    private final Analyzer analyzer;
    private final ExecutionEngine executionEngine;
    private final BuiltinFunctionRepository repository;

    public void execute(SQLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.executionEngine.execute(this.plan(this.analyze(this.parse(request.getQuery()))), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void execute(PhysicalPlan plan, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.executionEngine.execute(plan, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void explain(PhysicalPlan plan, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.executionEngine.explain(plan, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public UnresolvedPlan parse(String query) {
        ParseTree cst = this.parser.parse(query);
        return (UnresolvedPlan)cst.accept((ParseTreeVisitor)new AstBuilder(query));
    }

    public LogicalPlan analyze(UnresolvedPlan ast) {
        return this.analyzer.analyze(ast, new AnalysisContext());
    }

    public PhysicalPlan plan(LogicalPlan logicalPlan) {
        return new Planner(LogicalPlanOptimizer.create((DSL)new DSL(this.repository))).plan(logicalPlan);
    }

    @Generated
    public SQLService(SQLSyntaxParser parser, Analyzer analyzer, ExecutionEngine executionEngine, BuiltinFunctionRepository repository) {
        this.parser = parser;
        this.analyzer = analyzer;
        this.executionEngine = executionEngine;
        this.repository = repository;
    }
}

