/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.catalog.CatalogService;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.expression.DSL;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.planner.Planner;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.optimizer.LogicalPlanOptimizer;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.ppl.antlr.PPLSyntaxParser;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.ppl.parser.AstBuilder;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.utils.PPLQueryDataAnonymizer;
import org.opensearch.sql.ppl.utils.UnresolvedPlanHelper;

public class PPLService {
    private final PPLSyntaxParser parser;
    private final ExecutionEngine openSearchExecutionEngine;
    private final BuiltinFunctionRepository repository;
    private final CatalogService catalogService;
    private final PPLQueryDataAnonymizer anonymizer = new PPLQueryDataAnonymizer();
    private static final Logger LOG = LogManager.getLogger();

    public void execute(PPLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.openSearchExecutionEngine.execute(this.plan(request), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void explain(PPLQueryRequest request, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.openSearchExecutionEngine.explain(this.plan(request), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private PhysicalPlan plan(PPLQueryRequest request) {
        ParseTree cst = this.parser.parse(request.getRequest());
        UnresolvedPlan ast = (UnresolvedPlan)cst.accept((ParseTreeVisitor)new AstBuilder(new AstExpressionBuilder(), request.getRequest()));
        LOG.info("[{}] Incoming request {}", (Object)QueryContext.getRequestId(), (Object)this.anonymizer.anonymizeData(ast));
        LogicalPlan logicalPlan = new Analyzer(new ExpressionAnalyzer(this.repository), this.catalogService, this.repository).analyze(UnresolvedPlanHelper.addSelectAll(ast), new AnalysisContext());
        return new Planner(LogicalPlanOptimizer.create((DSL)new DSL(this.repository))).plan(logicalPlan);
    }

    @Generated
    public PPLService(PPLSyntaxParser parser, ExecutionEngine openSearchExecutionEngine, BuiltinFunctionRepository repository, CatalogService catalogService) {
        this.parser = parser;
        this.openSearchExecutionEngine = openSearchExecutionEngine;
        this.repository = repository;
        this.catalogService = catalogService;
    }
}

