/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.ConditionEndStyle;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileIfDown
extends AbstractFtile {
    private final Ftile thenBlock;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final Ftile optionalStop;
    private final ConditionEndStyle conditionEndStyle;

    @Override
    public Collection<Ftile> getMyChildren() {
        if (this.optionalStop == null) {
            return Arrays.asList(this.thenBlock, this.diamond1, this.diamond2);
        }
        return Arrays.asList(this.thenBlock, this.diamond1, this.diamond2, this.optionalStop);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>(this.thenBlock.getSwimlanes());
        result.add(this.getSwimlaneIn());
        return result;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        if (this.optionalStop == null) {
            return this.getSwimlaneIn();
        }
        return this.thenBlock.getSwimlaneOut();
    }

    private FtileIfDown(Ftile thenBlock, Ftile diamond1, Ftile diamond2, Ftile optionalStop, ConditionEndStyle conditionEndStyle) {
        super(thenBlock.skinParam());
        this.thenBlock = thenBlock;
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
        this.optionalStop = optionalStop;
        this.conditionEndStyle = conditionEndStyle;
    }

    public static Ftile create(Ftile diamond1, Ftile diamond2, Swimlane swimlane, Ftile thenBlock, Rainbow arrowColor, ConditionEndStyle conditionEndStyle, FtileFactory ftileFactory, Ftile optionalStop, Rainbow elseColor) {
        elseColor = elseColor.withDefault(arrowColor);
        FtileIfDown result = new FtileIfDown(thenBlock, diamond1, optionalStop == null ? diamond2 : new FtileEmpty(ftileFactory.skinParam()), optionalStop, conditionEndStyle);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        FtileIfDown ftileIfDown = result;
        Objects.requireNonNull(ftileIfDown);
        conns.add(ftileIfDown.new ConnectionIn(thenBlock.getInLinkRendering().getRainbow(arrowColor)));
        boolean hasPointOut1 = thenBlock.calculateDimension(ftileFactory.getStringBounder()).hasPointOut();
        if (optionalStop == null) {
            if (hasPointOut1) {
                if (conditionEndStyle == ConditionEndStyle.DIAMOND) {
                    if (swimlane != null && swimlane.isSmallerThanAllOthers(thenBlock.getSwimlanes())) {
                        FtileIfDown ftileIfDown2 = result;
                        Objects.requireNonNull(ftileIfDown2);
                        conns.add(ftileIfDown2.new ConnectionElse1(elseColor));
                        if (diamond1 instanceof FtileDiamondInside) {
                            ((FtileDiamondInside)diamond1).swapEastWest();
                        }
                    } else {
                        FtileIfDown ftileIfDown3 = result;
                        Objects.requireNonNull(ftileIfDown3);
                        conns.add(ftileIfDown3.new ConnectionElse2(elseColor));
                    }
                } else if (conditionEndStyle == ConditionEndStyle.HLINE) {
                    FtileIfDown ftileIfDown4 = result;
                    Objects.requireNonNull(ftileIfDown4);
                    conns.add(ftileIfDown4.new ConnectionElseHline(elseColor));
                    FtileIfDown ftileIfDown5 = result;
                    Objects.requireNonNull(ftileIfDown5);
                    conns.add(ftileIfDown5.new ConnectionHline(elseColor));
                }
            } else {
                FtileIfDown ftileIfDown6 = result;
                Objects.requireNonNull(ftileIfDown6);
                conns.add(ftileIfDown6.new ConnectionElseNoDiamond(elseColor));
            }
        } else {
            FtileIfDown ftileIfDown7 = result;
            Objects.requireNonNull(ftileIfDown7);
            conns.add(ftileIfDown7.new ConnectionHorizontal(elseColor));
        }
        FtileIfDown ftileIfDown8 = result;
        Objects.requireNonNull(ftileIfDown8);
        conns.add(ftileIfDown8.new ConnectionOut(thenBlock.getOutLinkRendering().getRainbow(arrowColor)));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateForThen(stringBounder)).draw(this.thenBlock);
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        if (this.optionalStop == null) {
            ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
        } else {
            ug.apply(this.getTranslateOptionalStop(stringBounder)).draw(this.optionalStop);
        }
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry geoDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry geoThen = this.thenBlock.calculateDimension(stringBounder);
        FtileGeometry geoDiamond2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry geo = geoDiamond1.appendBottom(geoThen).appendBottom(geoDiamond2);
        double height = geo.getHeight() + 36.0 + Math.max(12.0, this.getSouthLabelHeight(stringBounder));
        double width = geo.getWidth() + 12.0;
        if (this.optionalStop != null) {
            width += this.optionalStop.calculateDimension(stringBounder).getWidth() + this.getAdditionalWidth(stringBounder);
        }
        FtileGeometry result = new FtileGeometry(width, height, geo.getLeft(), geoDiamond1.getInY(), height);
        if (!geoThen.hasPointOut() && this.optionalStop != null) {
            return result.withoutPointOut();
        }
        return result;
    }

    private double getAdditionalWidth(StringBounder stringBounder) {
        FtileGeometry dimStop = this.optionalStop.calculateDimension(stringBounder);
        double val1 = this.getEastLabelWidth(stringBounder);
        double stopWidth = dimStop.getWidth();
        return Math.max(stopWidth, val1 + stopWidth / 2.0);
    }

    private double getSouthLabelHeight(StringBounder stringBounder) {
        if (this.diamond1 instanceof FtileDiamondInside) {
            return ((FtileDiamondInside)this.diamond1).getSouthLabelHeight(stringBounder);
        }
        if (this.diamond1 instanceof FtileDiamond) {
            return ((FtileDiamond)this.diamond1).getSouthLabelHeight(stringBounder);
        }
        return 0.0;
    }

    private double getEastLabelWidth(StringBounder stringBounder) {
        if (this.diamond1 instanceof FtileDiamondInside) {
            return ((FtileDiamondInside)this.diamond1).getEastLabelWidth(stringBounder);
        }
        if (this.diamond1 instanceof FtileDiamond) {
            return ((FtileDiamond)this.diamond1).getEastLabelWidth(stringBounder);
        }
        return 0.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.thenBlock) {
            return this.getTranslateForThen(stringBounder);
        }
        if (child == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        if (child == this.optionalStop) {
            return this.getTranslateOptionalStop(stringBounder);
        }
        if (child == this.diamond2) {
            return this.getTranslateDiamond2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForThen(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimThen = this.thenBlock.calculateDimension(stringBounder);
        double y = dimDiamond1.getHeight() + (dimTotal.getHeight() - dimDiamond1.getHeight() - dimDiamond2.getHeight() - dimThen.getHeight()) / 2.0;
        double x = dimTotal.getLeft() - dimThen.getLeft();
        return new UTranslate(x, y);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double y1 = 0.0;
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, 0.0);
    }

    private UTranslate getTranslateOptionalStop(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dimStop = this.optionalStop.calculateDimension(stringBounder);
        double labelNorth = dimDiamond1.getInY();
        double y1 = labelNorth + (dimDiamond1.getHeight() - labelNorth - dimStop.getHeight()) / 2.0;
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft() + dimDiamond1.getWidth() + this.getAdditionalWidth(stringBounder);
        return new UTranslate(x1, y1);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimension(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - dimDiamond2.getHeight();
        double x2 = dimTotal.getLeft() - dimDiamond2.getLeft();
        return new UTranslate(x2, y2);
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow arrowColor) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.thenBlock);
            this.arrowColor = arrowColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateForThen(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.arrowColor, FtileIfDown.this.skinParam().arrows().asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.arrowColor, FtileIfDown.this.skinParam().arrows().asToDown());
            XPoint2D mp1a = translate1.getTranslated(p1);
            XPoint2D mp2b = translate2.getTranslated(p2);
            double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionElse1
    extends AbstractConnection {
        private final Rainbow endInlinkColor;

        public ConnectionElse1(Rainbow endInlinkColor) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.diamond2);
            this.endInlinkColor = endInlinkColor;
        }

        protected XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = FtileIfDown.this.diamond1.calculateDimension(stringBounder);
            double x = 0.0;
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(0.0, dimDiamond1.getInY() + half));
        }

        protected XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond2 = FtileIfDown.this.diamond2.calculateDimension(stringBounder);
            double x = 0.0;
            double half = (dimDiamond2.getOutY() - dimDiamond2.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(new XPoint2D(0.0, dimDiamond2.getInY() + half));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            if (!FtileIfDown.this.calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            double t11 = FtileIfDown.this.getTranslateForThen(stringBounder).getDx();
            double xmin = Math.min(x1 - 12.0, FtileIfDown.this.getTranslateForThen(stringBounder).getDx());
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.endInlinkColor, FtileIfDown.this.skinParam().arrows().asToRight()).emphasizeDirection(Direction.DOWN);
            snake.addPoint(x1, y1);
            snake.addPoint(xmin, y1);
            snake.addPoint(xmin, y2);
            snake.addPoint(x2, y2);
            ug.apply(new UTranslate(x2, y2 - 12.0)).draw(new UEmpty(5.0, 12.0));
            ug.draw(snake);
        }
    }

    class ConnectionElse2
    extends AbstractConnection {
        private final Rainbow endInlinkColor;

        public ConnectionElse2(Rainbow endInlinkColor) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.diamond2);
            this.endInlinkColor = endInlinkColor;
        }

        protected XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = FtileIfDown.this.diamond1.calculateDimension(stringBounder);
            double x = dimDiamond1.getWidth();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(x, dimDiamond1.getInY() + half));
        }

        protected XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond2 = FtileIfDown.this.diamond2.calculateDimension(stringBounder);
            double x = dimDiamond2.getWidth();
            double half = (dimDiamond2.getOutY() - dimDiamond2.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(new XPoint2D(x, dimDiamond2.getInY() + half));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            if (!FtileIfDown.this.calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            FtileGeometry thenGeom = FtileIfDown.this.thenBlock.calculateDimension(stringBounder);
            double xmax = Math.max(x1 + 12.0, FtileIfDown.this.getTranslateForThen(stringBounder).getDx() + thenGeom.getWidth());
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.endInlinkColor, FtileIfDown.this.skinParam().arrows().asToLeft()).emphasizeDirection(Direction.DOWN);
            snake.addPoint(x1, y1);
            snake.addPoint(xmax, y1);
            snake.addPoint(xmax, y2);
            snake.addPoint(x2, y2);
            ug.apply(new UTranslate(x2, y2 - 12.0)).draw(new UEmpty(5.0, 12.0));
            ug.draw(snake);
        }
    }

    class ConnectionElseHline
    extends ConnectionElse2 {
        private final Rainbow endInlinkColor;

        public ConnectionElseHline(Rainbow endInlinkColor) {
            super(endInlinkColor);
            this.endInlinkColor = endInlinkColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            if (!FtileIfDown.this.calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            XPoint2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            FtileGeometry thenGeom = FtileIfDown.this.thenBlock.calculateDimension(stringBounder);
            double xmax = Math.max(x1 + 12.0, FtileIfDown.this.getTranslateForThen(stringBounder).getDx() + thenGeom.getWidth());
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.endInlinkColor, FtileIfDown.this.skinParam().arrows().asToDown());
            snake.addPoint(x1, y1);
            snake.addPoint(xmax, y1);
            snake.addPoint(xmax, y2);
            ug.apply(new UTranslate(xmax, y2 - 12.0)).draw(new UEmpty(5.0, 12.0));
            ug.draw(snake);
        }
    }

    class ConnectionHline
    extends AbstractConnection {
        private final Rainbow endInlinkColor;

        public ConnectionHline(Rainbow endInlinkColor) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.diamond2);
            this.endInlinkColor = endInlinkColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = FtileIfDown.this.diamond1.calculateDimension(stringBounder);
            double x = dimDiamond1.getWidth();
            double half = (dimDiamond1.getOutY() - dimDiamond1.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(new XPoint2D(x, dimDiamond1.getInY() + half));
        }

        protected XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond2 = FtileIfDown.this.diamond2.calculateDimension(stringBounder);
            double x = dimDiamond2.getWidth();
            double half = (dimDiamond2.getOutY() - dimDiamond2.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(new XPoint2D(x, dimDiamond2.getInY() + half));
        }

        protected XPoint2D getP3(StringBounder stringBounder) {
            FtileGeometry dimDiamond2 = FtileIfDown.this.diamond2.calculateDimension(stringBounder);
            double x = dimDiamond2.getWidth();
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(new XPoint2D(x, dimDiamond2.getOutY()));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            if (!FtileIfDown.this.calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            XPoint2D p2 = this.getP2(stringBounder);
            XPoint2D p3 = this.getP3(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            double x3 = p3.getX();
            double y3 = p3.getY();
            FtileGeometry thenGeom = FtileIfDown.this.thenBlock.calculateDimension(stringBounder);
            double xmax = Math.max(x1 + 12.0, FtileIfDown.this.getTranslateForThen(stringBounder).getDx() + thenGeom.getWidth());
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.endInlinkColor).withMerge(MergeStrategy.NONE);
            snake.addPoint(xmax, y2);
            snake.addPoint(x2, y2);
            snake.addPoint(x3, y3);
            ug.draw(snake);
        }
    }

    class ConnectionElseNoDiamond
    extends ConnectionElse2 {
        public ConnectionElseNoDiamond(Rainbow endInlinkColor) {
            super(endInlinkColor);
        }

        @Override
        protected XPoint2D getP2(StringBounder stringBounder) {
            return FtileIfDown.this.calculateDimension(stringBounder).getPointOut();
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionHorizontal(Rainbow color) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.optionalStop);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.color, FtileIfDown.this.skinParam().arrows().asToRight());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(dimDiamond1.getWidth(), (dimDiamond1.getInY() + dimDiamond1.getOutY()) / 2.0);
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(p);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimStop = this.getFtile2().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(0.0, ((XDimension2D)dimStop).getHeight() / 2.0);
            return FtileIfDown.this.getTranslateOptionalStop(stringBounder).getTranslated(p);
        }
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionOut(Rainbow arrowColor) {
            super(FtileIfDown.this.thenBlock, FtileIfDown.this.diamond2);
            this.arrowColor = arrowColor;
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateForThen(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        private XPoint2D getP2hline(StringBounder stringBounder) {
            FtileGeometry dimDiamond2 = this.getFtile2().calculateDimension(stringBounder);
            double x = dimDiamond2.getWidth();
            double half = (dimDiamond2.getOutY() - dimDiamond2.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(new XPoint2D(x, dimDiamond2.getInY() + half));
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            if (!this.getFtile1().calculateDimension(ug.getStringBounder()).hasPointOut()) {
                return;
            }
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.arrowColor, FtileIfDown.this.skinParam().arrows().asToDown());
            snake.addPoint(this.getP1(stringBounder));
            if (FtileIfDown.this.conditionEndStyle == ConditionEndStyle.DIAMOND) {
                snake.addPoint(this.getP2(stringBounder));
            } else if (FtileIfDown.this.conditionEndStyle == ConditionEndStyle.HLINE) {
                snake.addPoint(this.getP2hline(stringBounder));
            }
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            if (!this.getFtile1().calculateDimension(ug.getStringBounder()).hasPointOut()) {
                return;
            }
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfDown.this.skinParam(), this.arrowColor, FtileIfDown.this.skinParam().arrows().asToDown());
            XPoint2D mp1a = translate1.getTranslated(p1);
            XPoint2D mp2b = translate2.getTranslated(p2);
            double middle = (mp1a.getY() + mp2b.getY()) / 2.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }
}

