/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.creole.Neutron;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class SheetBlock2
extends AbstractTextBlock
implements TextBlock,
Atom,
WithPorts {
    private final SheetBlock1 block;
    private final UStroke defaultStroke;
    private final Stencil stencil;

    public SheetBlock2 enlargeMe(final double delta1, final double delta2) {
        Stencil newStencil = new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return SheetBlock2.this.stencil.getStartingX(stringBounder, y) - delta1;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return SheetBlock2.this.stencil.getEndingX(stringBounder, y) + delta2;
            }
        };
        return new SheetBlock2(this.block, newStencil, this.defaultStroke);
    }

    public SheetBlock2(SheetBlock1 block, Stencil stencil, UStroke defaultStroke) {
        this.block = block;
        this.stencil = Objects.requireNonNull(stencil);
        this.defaultStroke = defaultStroke;
    }

    private HorizontalAlignment getHorizontalAlignment() {
        return this.block.getHorizontalAlignment();
    }

    public String toString() {
        return this.block.toString();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.stencil != null) {
            ug = UGraphicStencil.create(ug, this.stencil, this.defaultStroke);
        }
        if (this.getHorizontalAlignment() == HorizontalAlignment.CENTER && this.block.getMinimumWidth() > 0.0) {
            double width = this.calculateDimension(ug.getStringBounder()).getWidth();
            double dx = (this.block.getMinimumWidth() - width) / 2.0;
            ug = ug.apply(UTranslate.dx(dx));
        }
        this.block.drawU(ug);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.block.getInnerPosition(member, stringBounder, strategy);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return new Ports();
    }

    @Override
    public List<Neutron> getNeutrons() {
        throw new UnsupportedOperationException();
    }
}

