/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.style.WithStyle;

public abstract class AbstractMessage
extends AbstractEvent
implements EventWithDeactivate,
WithStyle {
    private Stereotype stereotype;
    private final Display label;
    private final ArrowConfiguration arrowConfiguration;
    private final Set<LifeEventType> lifeEventsType = EnumSet.noneOf(LifeEventType.class);
    private Url url;
    private final String messageNumber;
    private boolean parallel = false;
    private AbstractMessage parallelBrother;
    private final StyleBuilder styleBuilder;
    private List<Note> noteOnMessages = new ArrayList<Note>();
    private boolean firstIsActivate = false;
    private final Set<Participant> noActivationAuthorized2 = new HashSet<Participant>();
    private double posYendLevel;
    private double posYstartLevel;
    private String anchor;
    private String anchor1;
    private String anchor2;

    public void getStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final Style[] getUsedStyles() {
        Style style = this.getStyleSignature().getMergedStyle(this.styleBuilder);
        if (style != null && this.arrowConfiguration.getColor() != null) {
            style = style.eventuallyOverride(PName.LineColor, this.arrowConfiguration.getColor());
        }
        return new Style[]{style};
    }

    @Override
    public StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.sequenceDiagram, SName.arrow).withTOBECHANGED(this.stereotype);
    }

    public AbstractMessage(StyleBuilder styleBuilder, Display label, ArrowConfiguration arrowConfiguration, String messageNumber) {
        this.styleBuilder = styleBuilder;
        this.url = null;
        this.label = label;
        this.arrowConfiguration = arrowConfiguration;
        this.messageNumber = messageNumber;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public void goParallel() {
        this.parallel = true;
    }

    public void setParallelBrother(AbstractMessage brother) {
        this.parallelBrother = brother;
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }

    @Override
    public final Url getUrl() {
        if (this.url == null) {
            for (Note n : this.noteOnMessages) {
                if (n.getUrl() == null) continue;
                return n.getUrl();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        for (Note n : this.noteOnMessages) {
            if (!n.hasUrl()) continue;
            return true;
        }
        if (this.label != null && this.label.hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    @Override
    public final boolean addLifeEvent(LifeEvent lifeEvent) {
        lifeEvent.setMessage(this);
        this.lifeEventsType.add(lifeEvent.getType());
        if (this.lifeEventsType.size() == 1 && this.isActivate()) {
            this.firstIsActivate = true;
        }
        if (lifeEvent.getType() == LifeEventType.ACTIVATE && this.noActivationAuthorized2.contains(lifeEvent.getParticipant())) {
            return false;
        }
        if (lifeEvent.getType() == LifeEventType.DEACTIVATE || lifeEvent.getType() == LifeEventType.DESTROY) {
            this.noActivationAuthorized2.add(lifeEvent.getParticipant());
        }
        return true;
    }

    public final boolean isCreate() {
        return this.lifeEventsType.contains((Object)LifeEventType.CREATE);
    }

    @Deprecated
    public boolean isActivate() {
        return this.lifeEventsType.contains((Object)LifeEventType.ACTIVATE);
    }

    @Deprecated
    public boolean isDeactivate() {
        return this.lifeEventsType.contains((Object)LifeEventType.DEACTIVATE);
    }

    public boolean isDestroy() {
        return this.lifeEventsType.contains((Object)LifeEventType.DESTROY);
    }

    @Deprecated
    private boolean isDeactivateOrDestroy() {
        return this.isDeactivate() || this.isDestroy();
    }

    public final boolean isActivateAndDeactive() {
        return this.firstIsActivate && this.isDeactivateOrDestroy();
    }

    public final Display getLabel() {
        return this.label;
    }

    public final Display getLabelNumbered() {
        if (this.getMessageNumber() == null) {
            return this.getLabel();
        }
        Display result = Display.empty();
        result = result.add(new MessageNumber(this.getMessageNumber()));
        result = result.addAll(this.getLabel());
        return result;
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    public final List<Note> getNoteOnMessages() {
        return this.noteOnMessages;
    }

    public final void setNote(Note note) {
        if (note.getPosition() != NotePosition.LEFT && note.getPosition() != NotePosition.RIGHT && note.getPosition() != NotePosition.BOTTOM && note.getPosition() != NotePosition.TOP) {
            throw new IllegalArgumentException();
        }
        note = note.withPosition(this.overrideNotePosition(note.getPosition()));
        this.noteOnMessages.add(note);
    }

    protected NotePosition overrideNotePosition(NotePosition notePosition) {
        return notePosition;
    }

    public final String getMessageNumber() {
        return this.messageNumber;
    }

    public abstract boolean compatibleForCreate(Participant var1);

    public abstract boolean isSelfMessage();

    public double getPosYstartLevel() {
        return this.posYstartLevel;
    }

    public void setPosYstartLevel(double posYstartLevel) {
        this.posYstartLevel = posYstartLevel;
    }

    @Override
    public void setPosYendLevel(double posYendLevel) {
        this.posYendLevel = posYendLevel;
    }

    @Override
    public double getPosYendLevel() {
        return this.posYendLevel;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
        if (anchor != null && anchor.startsWith("{")) {
            throw new IllegalArgumentException(anchor);
        }
    }

    public void setPart1Anchor(String anchor) {
        this.anchor1 = anchor;
    }

    public void setPart2Anchor(String anchor) {
        this.anchor2 = anchor;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String getPart1Anchor() {
        return this.anchor1;
    }

    public String getPart2Anchor() {
        return this.anchor2;
    }

    public abstract Participant getParticipant1();

    public abstract Participant getParticipant2();
}

