/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.utils.MathUtils;

public class SequenceDiagramArea {
    private final double sequenceWidth;
    private final double sequenceHeight;
    private double headerWidth;
    private double headerHeight;
    private double headerMargin;
    private double titleWidth;
    private double titleHeight;
    private double captionWidth;
    private double captionHeight;
    private double footerWidth;
    private double footerHeight;
    private double footerMargin;
    private double legendWidth;
    private double legendHeight;
    private boolean isLegendTop;
    private HorizontalAlignment legendHorizontalAlignment;

    public void setLegend(XDimension2D dimLegend, boolean isLegendTop, HorizontalAlignment horizontalAlignment) {
        this.legendHorizontalAlignment = horizontalAlignment;
        this.legendWidth = dimLegend.getWidth();
        this.legendHeight = dimLegend.getHeight();
        this.isLegendTop = isLegendTop;
    }

    public double getLegendWidth() {
        return this.legendWidth;
    }

    public boolean hasLegend() {
        return this.legendHeight > 0.0 && this.legendWidth > 0.0;
    }

    public double getLegendX() {
        if (this.legendHorizontalAlignment == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (this.legendHorizontalAlignment == HorizontalAlignment.RIGHT) {
            return Math.max(0.0, this.getWidth() - this.legendWidth);
        }
        return Math.max(0.0, this.getWidth() - this.legendWidth) / 2.0;
    }

    public SequenceDiagramArea(double width, double height) {
        this.sequenceWidth = width;
        this.sequenceHeight = height;
    }

    public void setTitleArea(double width, double height) {
        this.titleWidth = width;
        this.titleHeight = height;
    }

    private void setCaptionArea(double width, double height) {
        this.captionWidth = width;
        this.captionHeight = height;
    }

    public void setCaptionArea(XDimension2D dim) {
        this.setCaptionArea(dim.getWidth(), dim.getHeight());
    }

    public void setHeaderArea(double headerWidth, double headerHeight, double headerMargin) {
        this.headerWidth = headerWidth;
        this.headerHeight = headerHeight;
        this.headerMargin = headerMargin;
    }

    public void setFooterArea(double footerWidth, double footerHeight, double footerMargin) {
        this.footerWidth = footerWidth;
        this.footerHeight = footerHeight;
        this.footerMargin = footerMargin;
    }

    public double getWidth() {
        return MathUtils.max(this.sequenceWidth, this.headerWidth, this.titleWidth, this.footerWidth, this.captionWidth);
    }

    public double getHeight() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.footerHeight + this.captionHeight + this.legendHeight;
    }

    public double getFooterY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.captionHeight + this.legendHeight;
    }

    public double getCaptionY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.legendHeight;
    }

    public double getLegendY() {
        if (this.isLegendTop) {
            return this.titleHeight + this.headerHeight + this.headerMargin;
        }
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight;
    }

    public double getTitleX() {
        return (this.getWidth() - this.titleWidth) / 2.0;
    }

    public double getTitleY() {
        return this.headerHeight + this.headerMargin;
    }

    public double getHeaderHeightMargin() {
        return this.headerHeight + this.headerMargin;
    }

    public double getCaptionX() {
        return (this.getWidth() - this.captionWidth) / 2.0;
    }

    public double getSequenceAreaX() {
        return (this.getWidth() - this.sequenceWidth) / 2.0;
    }

    public double getSequenceAreaY() {
        if (this.isLegendTop) {
            return this.getTitleY() + this.titleHeight + this.legendHeight;
        }
        return this.getTitleY() + this.titleHeight;
    }

    public double getHeaderY() {
        return 0.0;
    }

    public double getFooterX(HorizontalAlignment align) {
        if (align == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.footerWidth;
        }
        if (align == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.footerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public double getHeaderX(HorizontalAlignment align) {
        if (align == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.headerWidth;
        }
        if (align == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.headerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public void initFooter(PngTitler pngTitler, StringBounder stringBounder) {
        XDimension2D dim = pngTitler.getTextDimension(stringBounder);
        if (dim != null) {
            this.setFooterArea(dim.getWidth(), dim.getHeight(), 0.0);
        }
    }

    public void initHeader(PngTitler pngTitler, StringBounder stringBounder) {
        XDimension2D dim = pngTitler.getTextDimension(stringBounder);
        if (dim != null) {
            this.setHeaderArea(dim.getWidth(), dim.getHeight(), 0.0);
        }
    }
}

