/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPolygonG2d
extends DriverShadowedG2d
implements UDriver<UPolygon, Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverPolygonG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UPolygon shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        GeneralPath path = new GeneralPath();
        HColor back = param.getBackcolor();
        XPoint2D last = null;
        for (XPoint2D pt : shape.getPoints()) {
            double xp = pt.getX() + x;
            double yp = pt.getY() + y;
            this.visible.ensureVisible(xp, yp);
            if (last == null) {
                path.moveTo((float)xp, (float)yp);
            } else {
                path.lineTo((float)xp, (float)yp);
            }
            last = new XPoint2D(xp, yp);
        }
        if (last != null) {
            path.closePath();
        }
        if (shape.getDeltaShadow() != 0.0) {
            if (back.isTransparent()) {
                this.drawOnlyLineShadowSpecial(g2d, path, shape.getDeltaShadow(), this.dpiFactor);
            } else {
                this.drawShadow(g2d, path, shape.getDeltaShadow(), this.dpiFactor);
            }
        }
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            char policy = gr.getPolicy();
            GradientPaint paint = policy == '|' ? new GradientPaint((float)x, (float)(y + shape.getHeight()) / 2.0f, gr.getColor1().toColor(mapper), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()) / 2.0f, gr.getColor2().toColor(mapper)) : (policy == '\\' ? new GradientPaint((float)x, (float)(y + shape.getHeight()), gr.getColor1().toColor(mapper), (float)(x + shape.getWidth()), (float)y, gr.getColor2().toColor(mapper)) : (policy == '-' ? new GradientPaint((float)(x + shape.getWidth()) / 2.0f, (float)y, gr.getColor1().toColor(mapper), (float)(x + shape.getWidth()) / 2.0f, (float)(y + shape.getHeight()), gr.getColor2().toColor(mapper)) : new GradientPaint((float)x, (float)y, gr.getColor1().toColor(mapper), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()), gr.getColor2().toColor(mapper))));
            g2d.setPaint(paint);
            g2d.fill(path);
        } else if (!back.isTransparent()) {
            g2d.setColor(back.toColor(mapper));
            DriverRectangleG2d.managePattern(param, g2d);
            g2d.fill(path);
        }
        if (!param.getColor().isTransparent()) {
            g2d.setColor(param.getColor().toColor(mapper));
            DriverLineG2d.manageStroke(param, g2d);
            g2d.draw(path);
        }
    }
}

