/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;
import net.sourceforge.plantuml.wire.WArrowDirection;
import net.sourceforge.plantuml.wire.WLinkType;

public class WLinkHorizontal {
    private final UTranslate start;
    private final double destination;
    private final WLinkType type;
    private final WArrowDirection direction;
    private final HColor color;
    private final Display label;
    private final ISkinParam skinParam;

    public WLinkHorizontal(ISkinParam skinParam, UTranslate start, double destination, WLinkType type, WArrowDirection direction, HColor color, Display label) {
        this.start = start;
        this.destination = destination;
        this.skinParam = skinParam;
        this.direction = direction;
        this.type = type;
        this.label = label;
        this.color = color == null ? this.getBlack() : color;
    }

    private HColor getBlack() {
        return HColors.BLACK.withDark(HColors.WHITE);
    }

    private HColor getWhite() {
        return HColors.WHITE.withDark(HColors.BLACK);
    }

    private TextBlock getTextBlock() {
        FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.sansSerif(10)).changeColor(this.color);
        return this.label.create(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
    }

    public void drawMe(UGraphic ug) {
        ug = ug.apply(this.color);
        TextBlock textBlock = this.getTextBlock();
        XDimension2D dimText = textBlock.calculateDimension(ug.getStringBounder());
        UGraphic ugText = ug.apply(this.start);
        double len = this.destination - this.start.getDx();
        if (this.type == WLinkType.NORMAL) {
            ug = ug.apply(this.color.bg());
            this.drawNormalArrow(ug);
            ugText = ugText.apply(UTranslate.dy(-dimText.getHeight() / 2.0));
        } else if (this.type == WLinkType.BUS) {
            ug = ug.apply(this.getWhite().bg());
            this.drawBusArrow(ug);
            ugText = ugText.apply(UTranslate.dy((20.0 - dimText.getHeight()) / 2.0 - 5.0));
        }
        if (dimText.getHeight() > 0.0) {
            switch (this.direction) {
                case NORMAL: {
                    ugText = ugText.apply(UTranslate.dx(4.0));
                    break;
                }
                case REVERSE: {
                    ugText = ugText.apply(UTranslate.dx(len - dimText.getWidth() - 4.0));
                    break;
                }
                default: {
                    ugText = ugText.apply(UTranslate.dx((len - dimText.getWidth()) / 2.0));
                }
            }
            if (this.type == WLinkType.NORMAL) {
                ugText.apply(this.getWhite()).apply(this.getWhite().bg()).draw(new URectangle(dimText));
            }
            textBlock.drawU(ugText);
        }
    }

    private void drawBusArrow(UGraphic ug) {
        double dx = this.destination - this.start.getDx() - 2.0;
        UPath path = new UPath();
        if (this.direction == WArrowDirection.NONE) {
            path.moveTo(0.0, 0.0);
            path.lineTo(dx, 0.0);
            path.lineTo(dx, 10.0);
            path.lineTo(0.0, 10.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dx(1.0))).draw(path);
        }
        if (this.direction == WArrowDirection.NORMAL) {
            path.moveTo(0.0, 0.0);
            path.lineTo(dx - 15.0, 0.0);
            path.lineTo(dx - 15.0, -5.0);
            path.lineTo(dx, 5.0);
            path.lineTo(dx - 15.0, 15.0);
            path.lineTo(dx - 15.0, 10.0);
            path.lineTo(0.0, 10.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dx(1.0))).draw(path);
        }
        if (this.direction == WArrowDirection.BOTH) {
            path.moveTo(0.0, 5.0);
            path.lineTo(15.0, -5.0);
            path.lineTo(15.0, 0.0);
            path.lineTo(dx - 15.0, 0.0);
            path.lineTo(dx - 15.0, -5.0);
            path.lineTo(dx, 5.0);
            path.lineTo(dx - 15.0, 15.0);
            path.lineTo(dx - 15.0, 10.0);
            path.lineTo(15.0, 10.0);
            path.lineTo(15.0, 15.0);
            path.lineTo(0.0, 5.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dx(1.0))).draw(path);
        }
        if (this.direction == WArrowDirection.REVERSE) {
            path.moveTo(0.0, 5.0);
            path.lineTo(15.0, -5.0);
            path.lineTo(15.0, 0.0);
            path.lineTo(dx, 0.0);
            path.lineTo(dx, 10.0);
            path.lineTo(15.0, 10.0);
            path.lineTo(15.0, 15.0);
            path.lineTo(0.0, 5.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dx(1.0))).draw(path);
        }
    }

    private void drawNormalArrow(UGraphic ug) {
        UPath path;
        double dx = this.destination - this.start.getDx() - 2.0;
        if (this.direction == WArrowDirection.BOTH || this.direction == WArrowDirection.NORMAL) {
            path = new UPath();
            path.moveTo(0.0, 0.0);
            path.lineTo(-5.0, -5.0);
            path.lineTo(-5.0, 5.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dx(dx))).draw(path);
        }
        if (this.direction == WArrowDirection.BOTH || this.direction == WArrowDirection.REVERSE) {
            path = new UPath();
            path.moveTo(0.0, 0.0);
            path.lineTo(5.0, -5.0);
            path.lineTo(5.0, 5.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dx(1.0))).draw(path);
        }
        ug.apply(this.start.compose(UTranslate.dx(1.0))).draw(ULine.hline(dx));
    }
}

