/* aptd-client.c generated by valac 0.56.3, the Vala compiler
 * generated from aptd-client.vala, do not modify */

/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "locale-plug.h"
#include <gio/gio.h>
#include <glib-object.h>

#define APTD_DBUS_NAME "org.debian.apt"
#define APTD_DBUS_PATH "/org/debian/apt"

typedef GDBusProxy AptdServiceProxy;
typedef GDBusProxyClass AptdServiceProxyClass;
typedef struct _AptdServiceInstallPackagesReadyData AptdServiceInstallPackagesReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AptdServiceRemovePackagesReadyData AptdServiceRemovePackagesReadyData;
typedef struct _AptdServiceQuitReadyData AptdServiceQuitReadyData;
enum  {
	APTD_TRANSACTION_SERVICE_FINISHED_SIGNAL,
	APTD_TRANSACTION_SERVICE_PROPERTY_CHANGED_SIGNAL,
	APTD_TRANSACTION_SERVICE_NUM_SIGNALS
};
static guint aptd_transaction_service_signals[APTD_TRANSACTION_SERVICE_NUM_SIGNALS] = {0};
typedef GDBusProxy AptdTransactionServiceProxy;
typedef GDBusProxyClass AptdTransactionServiceProxyClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	APTD_PROXY_0_PROPERTY,
	APTD_PROXY_NUM_PROPERTIES
};
static GParamSpec* aptd_proxy_properties[APTD_PROXY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AptdProxyInstallPackagesData AptdProxyInstallPackagesData;
typedef struct _AptdProxyRemovePackagesData AptdProxyRemovePackagesData;
typedef struct _AptdProxyQuitData AptdProxyQuitData;
enum  {
	APTD_TRANSACTION_PROXY_0_PROPERTY,
	APTD_TRANSACTION_PROXY_NUM_PROPERTIES
};
static GParamSpec* aptd_transaction_proxy_properties[APTD_TRANSACTION_PROXY_NUM_PROPERTIES];
typedef struct _Block5Data Block5Data;
enum  {
	APTD_TRANSACTION_PROXY_FINISHED_SIGNAL,
	APTD_TRANSACTION_PROXY_PROPERTY_CHANGED_SIGNAL,
	APTD_TRANSACTION_PROXY_NUM_SIGNALS
};
static guint aptd_transaction_proxy_signals[APTD_TRANSACTION_PROXY_NUM_SIGNALS] = {0};

struct _AptdServiceInstallPackagesReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** packages;
	gint packages_length1;
};

struct _AptdServiceRemovePackagesReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** packages;
	gint packages_length1;
};

struct _AptdServiceQuitReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _AptdProxyPrivate {
	AptdService* _aptd_service;
};

struct _AptdProxyInstallPackagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AptdProxy* self;
	gchar** packages;
	gint packages_length1;
	gchar* result;
	gchar* res;
	AptdService* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_;
};

struct _AptdProxyRemovePackagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AptdProxy* self;
	gchar** packages;
	gint packages_length1;
	gchar* result;
	gchar* res;
	AptdService* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_;
};

struct _AptdProxyQuitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AptdProxy* self;
	AptdService* _tmp0_;
	GError* _inner_error0_;
};

struct _AptdTransactionProxyPrivate {
	AptdTransactionService* _aptd_service;
};

struct _Block5Data {
	int _ref_count_;
	AptdTransactionProxy* self;
	gchar* transaction_id;
};

static gint AptdProxy_private_offset;
static gpointer aptd_proxy_parent_class = NULL;
static gint AptdTransactionProxy_private_offset;
static gpointer aptd_transaction_proxy_parent_class = NULL;

static GType aptd_service_get_type_once (void);
static void aptd_service_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void aptd_service_proxy_install_packages_async (AptdService* self,
                                                gchar** packages,
                                                gint packages_length1,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gchar* aptd_service_proxy_install_packages_finish (AptdService* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static void aptd_service_proxy_remove_packages_async (AptdService* self,
                                               gchar** packages,
                                               gint packages_length1,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gchar* aptd_service_proxy_remove_packages_finish (AptdService* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void aptd_service_proxy_quit_async (AptdService* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void aptd_service_proxy_quit_finish (AptdService* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static void aptd_service_proxy_aptd_service_interface_init (AptdServiceIface* iface);
static void _dbus_aptd_service_install_packages (AptdService* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_aptd_service_install_packages_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void _dbus_aptd_service_remove_packages (AptdService* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_aptd_service_remove_packages_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_);
static void _dbus_aptd_service_quit (AptdService* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation);
static void _dbus_aptd_service_quit_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_);
static void aptd_service_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* aptd_service_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean aptd_service_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _aptd_service_unregister_object (gpointer user_data);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GType aptd_transaction_service_get_type_once (void);
static void aptd_transaction_service_proxy_g_signal (GDBusProxy* proxy,
                                              const gchar* sender_name,
                                              const gchar* signal_name,
                                              GVariant* parameters);
static void _dbus_handle_aptd_transaction_service_finished (AptdTransactionService* self,
                                                     GVariant* parameters);
static void _dbus_handle_aptd_transaction_service_property_changed (AptdTransactionService* self,
                                                             GVariant* parameters);
static void aptd_transaction_service_proxy_run (AptdTransactionService* self,
                                         GError** error);
static void aptd_transaction_service_proxy_simulate (AptdTransactionService* self,
                                              GError** error);
static void aptd_transaction_service_proxy_cancel (AptdTransactionService* self,
                                            GError** error);
static void aptd_transaction_service_proxy_aptd_transaction_service_interface_init (AptdTransactionServiceIface* iface);
static void _dbus_aptd_transaction_service_run (AptdTransactionService* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_aptd_transaction_service_simulate (AptdTransactionService* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_aptd_transaction_service_cancel (AptdTransactionService* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void aptd_transaction_service_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* aptd_transaction_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static gboolean aptd_transaction_service_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _dbus_aptd_transaction_service_finished (GObject* _sender,
                                              const gchar* exit_state,
                                              gpointer* _data);
static void _dbus_aptd_transaction_service_property_changed (GObject* _sender,
                                                      const gchar* property,
                                                      GVariant* val,
                                                      gpointer* _data);
static void _aptd_transaction_service_unregister_object (gpointer user_data);
static void aptd_proxy_install_packages_data_free (gpointer _data);
static gboolean aptd_proxy_install_packages_co (AptdProxyInstallPackagesData* _data_);
static void aptd_proxy_install_packages_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void aptd_proxy_remove_packages_data_free (gpointer _data);
static gboolean aptd_proxy_remove_packages_co (AptdProxyRemovePackagesData* _data_);
static void aptd_proxy_remove_packages_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void aptd_proxy_quit_data_free (gpointer _data);
static gboolean aptd_proxy_quit_co (AptdProxyQuitData* _data_);
static void aptd_proxy_quit_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_);
static void aptd_proxy_finalize (GObject * obj);
static GType aptd_proxy_get_type_once (void);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda16_ (Block5Data* _data5_,
                  const gchar* exit_state);
static void ___lambda16__aptd_transaction_service_finished (AptdTransactionService* _sender,
                                                     const gchar* exit_state,
                                                     gpointer self);
static void __lambda17_ (AptdTransactionProxy* self,
                  const gchar* prop,
                  GVariant* variant);
static void ___lambda17__aptd_transaction_service_property_changed (AptdTransactionService* _sender,
                                                             const gchar* property,
                                                             GVariant* val,
                                                             gpointer self);
static void aptd_transaction_proxy_finalize (GObject * obj);
static GType aptd_transaction_proxy_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _aptd_service_dbus_arg_info_install_packages_packages = {-1, "packages", "as", NULL};
static const GDBusArgInfo _aptd_service_dbus_arg_info_install_packages_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _aptd_service_dbus_arg_info_install_packages_in[] = {&_aptd_service_dbus_arg_info_install_packages_packages, NULL};
static const GDBusArgInfo * const _aptd_service_dbus_arg_info_install_packages_out[] = {&_aptd_service_dbus_arg_info_install_packages_result, NULL};
static const GDBusMethodInfo _aptd_service_dbus_method_info_install_packages = {-1, "InstallPackages", (GDBusArgInfo **) (&_aptd_service_dbus_arg_info_install_packages_in), (GDBusArgInfo **) (&_aptd_service_dbus_arg_info_install_packages_out), NULL};
static const GDBusArgInfo _aptd_service_dbus_arg_info_remove_packages_packages = {-1, "packages", "as", NULL};
static const GDBusArgInfo _aptd_service_dbus_arg_info_remove_packages_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _aptd_service_dbus_arg_info_remove_packages_in[] = {&_aptd_service_dbus_arg_info_remove_packages_packages, NULL};
static const GDBusArgInfo * const _aptd_service_dbus_arg_info_remove_packages_out[] = {&_aptd_service_dbus_arg_info_remove_packages_result, NULL};
static const GDBusMethodInfo _aptd_service_dbus_method_info_remove_packages = {-1, "RemovePackages", (GDBusArgInfo **) (&_aptd_service_dbus_arg_info_remove_packages_in), (GDBusArgInfo **) (&_aptd_service_dbus_arg_info_remove_packages_out), NULL};
static const GDBusArgInfo * const _aptd_service_dbus_arg_info_quit_in[] = {NULL};
static const GDBusArgInfo * const _aptd_service_dbus_arg_info_quit_out[] = {NULL};
static const GDBusMethodInfo _aptd_service_dbus_method_info_quit = {-1, "Quit", (GDBusArgInfo **) (&_aptd_service_dbus_arg_info_quit_in), (GDBusArgInfo **) (&_aptd_service_dbus_arg_info_quit_out), NULL};
static const GDBusMethodInfo * const _aptd_service_dbus_method_info[] = {&_aptd_service_dbus_method_info_install_packages, &_aptd_service_dbus_method_info_remove_packages, &_aptd_service_dbus_method_info_quit, NULL};
static const GDBusSignalInfo * const _aptd_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _aptd_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _aptd_service_dbus_interface_info = {-1, "org.debian.apt", (GDBusMethodInfo **) (&_aptd_service_dbus_method_info), (GDBusSignalInfo **) (&_aptd_service_dbus_signal_info), (GDBusPropertyInfo **) (&_aptd_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _aptd_service_dbus_interface_vtable = {aptd_service_dbus_interface_method_call, aptd_service_dbus_interface_get_property, aptd_service_dbus_interface_set_property};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_run_in[] = {NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_run_out[] = {NULL};
static const GDBusMethodInfo _aptd_transaction_service_dbus_method_info_run = {-1, "Run", (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_run_in), (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_run_out), NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_simulate_in[] = {NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_simulate_out[] = {NULL};
static const GDBusMethodInfo _aptd_transaction_service_dbus_method_info_simulate = {-1, "Simulate", (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_simulate_in), (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_simulate_out), NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _aptd_transaction_service_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_cancel_out), NULL};
static const GDBusMethodInfo * const _aptd_transaction_service_dbus_method_info[] = {&_aptd_transaction_service_dbus_method_info_run, &_aptd_transaction_service_dbus_method_info_simulate, &_aptd_transaction_service_dbus_method_info_cancel, NULL};
static const GDBusArgInfo _aptd_transaction_service_dbus_arg_info_finished_exit_state = {-1, "exit_state", "s", NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_finished[] = {&_aptd_transaction_service_dbus_arg_info_finished_exit_state, NULL};
static const GDBusSignalInfo _aptd_transaction_service_dbus_signal_info_finished = {-1, "Finished", (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_finished), NULL};
static const GDBusArgInfo _aptd_transaction_service_dbus_arg_info_property_changed_property = {-1, "property", "s", NULL};
static const GDBusArgInfo _aptd_transaction_service_dbus_arg_info_property_changed_val = {-1, "val", "v", NULL};
static const GDBusArgInfo * const _aptd_transaction_service_dbus_arg_info_property_changed[] = {&_aptd_transaction_service_dbus_arg_info_property_changed_property, &_aptd_transaction_service_dbus_arg_info_property_changed_val, NULL};
static const GDBusSignalInfo _aptd_transaction_service_dbus_signal_info_property_changed = {-1, "PropertyChanged", (GDBusArgInfo **) (&_aptd_transaction_service_dbus_arg_info_property_changed), NULL};
static const GDBusSignalInfo * const _aptd_transaction_service_dbus_signal_info[] = {&_aptd_transaction_service_dbus_signal_info_finished, &_aptd_transaction_service_dbus_signal_info_property_changed, NULL};
static const GDBusPropertyInfo * const _aptd_transaction_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _aptd_transaction_service_dbus_interface_info = {-1, "org.debian.apt.transaction", (GDBusMethodInfo **) (&_aptd_transaction_service_dbus_method_info), (GDBusSignalInfo **) (&_aptd_transaction_service_dbus_signal_info), (GDBusPropertyInfo **) (&_aptd_transaction_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _aptd_transaction_service_dbus_interface_vtable = {aptd_transaction_service_dbus_interface_method_call, aptd_transaction_service_dbus_interface_get_property, aptd_transaction_service_dbus_interface_set_property};

void
aptd_service_install_packages (AptdService* self,
                               gchar** packages,
                               gint packages_length1,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	AptdServiceIface* _iface_;
	_iface_ = APTD_SERVICE_GET_INTERFACE (self);
	if (_iface_->install_packages) {
		_iface_->install_packages (self, packages, packages_length1, _callback_, _user_data_);
	}
}

gchar*
aptd_service_install_packages_finish (AptdService* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	AptdServiceIface* _iface_;
	_iface_ = APTD_SERVICE_GET_INTERFACE (self);
	if (_iface_->install_packages_finish) {
		return _iface_->install_packages_finish (self, _res_, error);
	}
	return NULL;
}

void
aptd_service_remove_packages (AptdService* self,
                              gchar** packages,
                              gint packages_length1,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	AptdServiceIface* _iface_;
	_iface_ = APTD_SERVICE_GET_INTERFACE (self);
	if (_iface_->remove_packages) {
		_iface_->remove_packages (self, packages, packages_length1, _callback_, _user_data_);
	}
}

gchar*
aptd_service_remove_packages_finish (AptdService* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	AptdServiceIface* _iface_;
	_iface_ = APTD_SERVICE_GET_INTERFACE (self);
	if (_iface_->remove_packages_finish) {
		return _iface_->remove_packages_finish (self, _res_, error);
	}
	return NULL;
}

void
aptd_service_quit (AptdService* self,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	AptdServiceIface* _iface_;
	_iface_ = APTD_SERVICE_GET_INTERFACE (self);
	if (_iface_->quit) {
		_iface_->quit (self, _callback_, _user_data_);
	}
}

void
aptd_service_quit_finish (AptdService* self,
                          GAsyncResult* _res_,
                          GError** error)
{
	AptdServiceIface* _iface_;
	_iface_ = APTD_SERVICE_GET_INTERFACE (self);
	if (_iface_->quit_finish) {
		_iface_->quit_finish (self, _res_, error);
	}
}

static void
aptd_service_default_init (AptdServiceIface * iface,
                           gpointer iface_data)
{
}

/**
* Expose a subset of org.debian.apt interfaces -- only what's needed by applications lens.
*/
static GType
aptd_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AptdServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aptd_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType aptd_service_type_id;
	aptd_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "AptdService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (aptd_service_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (aptd_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) aptd_service_proxy_get_type);
	g_type_set_qdata (aptd_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.debian.apt");
	g_type_set_qdata (aptd_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_aptd_service_dbus_interface_info));
	g_type_set_qdata (aptd_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) aptd_service_register_object);
	return aptd_service_type_id;
}

GType
aptd_service_get_type (void)
{
	static volatile gsize aptd_service_type_id__once = 0;
	if (g_once_init_enter (&aptd_service_type_id__once)) {
		GType aptd_service_type_id;
		aptd_service_type_id = aptd_service_get_type_once ();
		g_once_init_leave (&aptd_service_type_id__once, aptd_service_type_id);
	}
	return aptd_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AptdServiceProxy, aptd_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_APTD_SERVICE, aptd_service_proxy_aptd_service_interface_init) )
static void
aptd_service_proxy_class_init (AptdServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = aptd_service_proxy_g_signal;
}

static void
aptd_service_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
aptd_service_proxy_init (AptdServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_aptd_service_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
aptd_service_proxy_install_packages_async (AptdService* self,
                                           gchar** packages,
                                           gint packages_length1,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.debian.apt", "InstallPackages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = packages;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("as"));
	for (_tmp24_ = 0; _tmp24_ < packages_length1; _tmp24_++) {
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string (*_tmp22_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp23_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static gchar*
aptd_service_proxy_install_packages_finish (AptdService* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp25_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp25_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	g_object_unref (_reply_message);
	return _result;
}

static void
aptd_service_proxy_remove_packages_async (AptdService* self,
                                          gchar** packages,
                                          gint packages_length1,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp26_;
	GVariantBuilder _tmp27_;
	gint _tmp28_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.debian.apt", "RemovePackages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp26_ = packages;
	g_variant_builder_init (&_tmp27_, G_VARIANT_TYPE ("as"));
	for (_tmp28_ = 0; _tmp28_ < packages_length1; _tmp28_++) {
		g_variant_builder_add_value (&_tmp27_, g_variant_new_string (*_tmp26_));
		_tmp26_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp27_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static gchar*
aptd_service_proxy_remove_packages_finish (AptdService* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp29_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp29_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	g_object_unref (_reply_message);
	return _result;
}

static void
aptd_service_proxy_quit_async (AptdService* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.debian.apt", "Quit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
aptd_service_proxy_quit_finish (AptdService* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
aptd_service_proxy_aptd_service_interface_init (AptdServiceIface* iface)
{
	iface->install_packages = aptd_service_proxy_install_packages_async;
	iface->install_packages_finish = aptd_service_proxy_install_packages_finish;
	iface->remove_packages = aptd_service_proxy_remove_packages_async;
	iface->remove_packages_finish = aptd_service_proxy_remove_packages_finish;
	iface->quit = aptd_service_proxy_quit_async;
	iface->quit_finish = aptd_service_proxy_quit_finish;
}

static void
_dbus_aptd_service_install_packages (AptdService* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AptdServiceInstallPackagesReadyData* _ready_data;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length;
	gint _tmp31__size;
	gint _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AptdServiceInstallPackagesReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	_ready_data->packages_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	_ready_data->packages = _tmp31_;
	g_variant_unref (_tmp30_);
	aptd_service_install_packages (self, _ready_data->packages, _ready_data->packages_length1, (GAsyncReadyCallback) _dbus_aptd_service_install_packages_ready, _ready_data);
	_error:
	;
}

static void
_dbus_aptd_service_install_packages_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	AptdServiceInstallPackagesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = aptd_service_install_packages_finish ((AptdService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->packages = (_vala_array_free (_ready_data->packages, _ready_data->packages_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (AptdServiceInstallPackagesReadyData, _ready_data);
}

static void
_dbus_aptd_service_remove_packages (AptdService* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AptdServiceRemovePackagesReadyData* _ready_data;
	GVariant* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length;
	gint _tmp35__size;
	gint _tmp35__length1;
	GVariantIter _tmp36_;
	GVariant* _tmp37_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AptdServiceRemovePackagesReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp35_ = g_new (gchar*, 5);
	_tmp35__length = 0;
	_tmp35__size = 4;
	_tmp35__length1 = 0;
	g_variant_iter_init (&_tmp36_, _tmp34_);
	for (; (_tmp37_ = g_variant_iter_next_value (&_tmp36_)) != NULL; _tmp35__length1++) {
		if (_tmp35__size == _tmp35__length) {
			_tmp35__size = 2 * _tmp35__size;
			_tmp35_ = g_renew (gchar*, _tmp35_, _tmp35__size + 1);
		}
		_tmp35_[_tmp35__length++] = g_variant_dup_string (_tmp37_, NULL);
		g_variant_unref (_tmp37_);
	}
	_ready_data->packages_length1 = _tmp35__length1;
	_tmp35_[_tmp35__length] = NULL;
	_ready_data->packages = _tmp35_;
	g_variant_unref (_tmp34_);
	aptd_service_remove_packages (self, _ready_data->packages, _ready_data->packages_length1, (GAsyncReadyCallback) _dbus_aptd_service_remove_packages_ready, _ready_data);
	_error:
	;
}

static void
_dbus_aptd_service_remove_packages_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_)
{
	AptdServiceRemovePackagesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = aptd_service_remove_packages_finish ((AptdService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->packages = (_vala_array_free (_ready_data->packages, _ready_data->packages_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (AptdServiceRemovePackagesReadyData, _ready_data);
}

static void
_dbus_aptd_service_quit (AptdService* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	AptdServiceQuitReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (AptdServiceQuitReadyData);
	_ready_data->_invocation_ = invocation;
	aptd_service_quit (self, (GAsyncReadyCallback) _dbus_aptd_service_quit_ready, _ready_data);
}

static void
_dbus_aptd_service_quit_ready (GObject * source_object,
                               GAsyncResult * _res_,
                               gpointer _user_data_)
{
	AptdServiceQuitReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	aptd_service_quit_finish ((AptdService*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (AptdServiceQuitReadyData, _ready_data);
}

static void
aptd_service_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "InstallPackages") == 0) {
		_dbus_aptd_service_install_packages (object, parameters, invocation);
	} else if (strcmp (method_name, "RemovePackages") == 0) {
		_dbus_aptd_service_remove_packages (object, parameters, invocation);
	} else if (strcmp (method_name, "Quit") == 0) {
		_dbus_aptd_service_quit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
aptd_service_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
aptd_service_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
aptd_service_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_aptd_service_dbus_interface_info), &_aptd_service_dbus_interface_vtable, data, _aptd_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_aptd_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
aptd_transaction_service_run (AptdTransactionService* self,
                              GError** error)
{
	AptdTransactionServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = APTD_TRANSACTION_SERVICE_GET_INTERFACE (self);
	if (_iface_->run) {
		_iface_->run (self, error);
	}
}

void
aptd_transaction_service_simulate (AptdTransactionService* self,
                                   GError** error)
{
	AptdTransactionServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = APTD_TRANSACTION_SERVICE_GET_INTERFACE (self);
	if (_iface_->simulate) {
		_iface_->simulate (self, error);
	}
}

void
aptd_transaction_service_cancel (AptdTransactionService* self,
                                 GError** error)
{
	AptdTransactionServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = APTD_TRANSACTION_SERVICE_GET_INTERFACE (self);
	if (_iface_->cancel) {
		_iface_->cancel (self, error);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}

static void
aptd_transaction_service_default_init (AptdTransactionServiceIface * iface,
                                       gpointer iface_data)
{
	aptd_transaction_service_signals[APTD_TRANSACTION_SERVICE_FINISHED_SIGNAL] = g_signal_new ("finished", TYPE_APTD_TRANSACTION_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	aptd_transaction_service_signals[APTD_TRANSACTION_SERVICE_PROPERTY_CHANGED_SIGNAL] = g_signal_new ("property-changed", TYPE_APTD_TRANSACTION_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
}

static GType
aptd_transaction_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AptdTransactionServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aptd_transaction_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType aptd_transaction_service_type_id;
	aptd_transaction_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "AptdTransactionService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (aptd_transaction_service_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (aptd_transaction_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) aptd_transaction_service_proxy_get_type);
	g_type_set_qdata (aptd_transaction_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.debian.apt.transaction");
	g_type_set_qdata (aptd_transaction_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_aptd_transaction_service_dbus_interface_info));
	g_type_set_qdata (aptd_transaction_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) aptd_transaction_service_register_object);
	return aptd_transaction_service_type_id;
}

GType
aptd_transaction_service_get_type (void)
{
	static volatile gsize aptd_transaction_service_type_id__once = 0;
	if (g_once_init_enter (&aptd_transaction_service_type_id__once)) {
		GType aptd_transaction_service_type_id;
		aptd_transaction_service_type_id = aptd_transaction_service_get_type_once ();
		g_once_init_leave (&aptd_transaction_service_type_id__once, aptd_transaction_service_type_id);
	}
	return aptd_transaction_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AptdTransactionServiceProxy, aptd_transaction_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_APTD_TRANSACTION_SERVICE, aptd_transaction_service_proxy_aptd_transaction_service_interface_init) )
static void
aptd_transaction_service_proxy_class_init (AptdTransactionServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = aptd_transaction_service_proxy_g_signal;
}

static void
_dbus_handle_aptd_transaction_service_finished (AptdTransactionService* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* exit_state = NULL;
	GVariant* _tmp38_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp38_ = g_variant_iter_next_value (&_arguments_iter);
	exit_state = g_variant_dup_string (_tmp38_, NULL);
	g_variant_unref (_tmp38_);
	g_signal_emit_by_name (self, "finished", exit_state);
	_g_free0 (exit_state);
}

static void
_dbus_handle_aptd_transaction_service_property_changed (AptdTransactionService* self,
                                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* property = NULL;
	GVariant* _tmp39_;
	GVariant* val = NULL;
	GVariant* _tmp40_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	property = g_variant_dup_string (_tmp39_, NULL);
	g_variant_unref (_tmp39_);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	val = g_variant_get_variant (_tmp40_);
	g_variant_unref (_tmp40_);
	g_signal_emit_by_name (self, "property-changed", property, val);
	_g_free0 (property);
	_g_variant_unref0 (val);
}

static void
aptd_transaction_service_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters)
{
	if (strcmp (signal_name, "Finished") == 0) {
		_dbus_handle_aptd_transaction_service_finished ((AptdTransactionService*) proxy, parameters);
	} else if (strcmp (signal_name, "PropertyChanged") == 0) {
		_dbus_handle_aptd_transaction_service_property_changed ((AptdTransactionService*) proxy, parameters);
	}
}

static void
aptd_transaction_service_proxy_init (AptdTransactionServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_aptd_transaction_service_dbus_interface_info));
}

static void
aptd_transaction_service_proxy_run (AptdTransactionService* self,
                                    GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.debian.apt.transaction", "Run");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
aptd_transaction_service_proxy_simulate (AptdTransactionService* self,
                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.debian.apt.transaction", "Simulate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
aptd_transaction_service_proxy_cancel (AptdTransactionService* self,
                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.debian.apt.transaction", "Cancel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
aptd_transaction_service_proxy_aptd_transaction_service_interface_init (AptdTransactionServiceIface* iface)
{
	iface->run = aptd_transaction_service_proxy_run;
	iface->simulate = aptd_transaction_service_proxy_simulate;
	iface->cancel = aptd_transaction_service_proxy_cancel;
}

static void
_dbus_aptd_transaction_service_run (AptdTransactionService* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	aptd_transaction_service_run (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_aptd_transaction_service_simulate (AptdTransactionService* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	aptd_transaction_service_simulate (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_aptd_transaction_service_cancel (AptdTransactionService* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	aptd_transaction_service_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
aptd_transaction_service_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Run") == 0) {
		_dbus_aptd_transaction_service_run (object, parameters, invocation);
	} else if (strcmp (method_name, "Simulate") == 0) {
		_dbus_aptd_transaction_service_simulate (object, parameters, invocation);
	} else if (strcmp (method_name, "Cancel") == 0) {
		_dbus_aptd_transaction_service_cancel (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
aptd_transaction_service_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
aptd_transaction_service_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_aptd_transaction_service_finished (GObject* _sender,
                                         const gchar* exit_state,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (exit_state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.debian.apt.transaction", "Finished", _arguments, NULL);
}

static void
_dbus_aptd_transaction_service_property_changed (GObject* _sender,
                                                 const gchar* property,
                                                 GVariant* val,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (property));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_variant (val));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.debian.apt.transaction", "PropertyChanged", _arguments, NULL);
}

guint
aptd_transaction_service_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_aptd_transaction_service_dbus_interface_info), &_aptd_transaction_service_dbus_interface_vtable, data, _aptd_transaction_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "finished", (GCallback) _dbus_aptd_transaction_service_finished, data);
	g_signal_connect (object, "property-changed", (GCallback) _dbus_aptd_transaction_service_property_changed, data);
	return result;
}

static void
_aptd_transaction_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_aptd_transaction_service_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_aptd_transaction_service_property_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
aptd_proxy_get_instance_private (AptdProxy* self)
{
	return G_STRUCT_MEMBER_P (self, AptdProxy_private_offset);
}

void
aptd_proxy_connect_to_aptd (AptdProxy* self,
                            GError** error)
{
	AptdService* _tmp0_ = NULL;
	AptdService* _tmp1_;
	AptdService* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = (AptdService*) g_initable_new (TYPE_APTD_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", APTD_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", APTD_DBUS_PATH, "g-interface-name", "org.debian.apt", NULL);
	_tmp0_ = (AptdService*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->_aptd_service);
	self->priv->_aptd_service = _tmp2_;
	_g_object_unref0 (_tmp0_);
}

static void
aptd_proxy_install_packages_data_free (gpointer _data)
{
	AptdProxyInstallPackagesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AptdProxyInstallPackagesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
aptd_proxy_install_packages (AptdProxy* self,
                             gchar** packages,
                             gint packages_length1,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	AptdProxyInstallPackagesData* _data_;
	AptdProxy* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AptdProxyInstallPackagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, aptd_proxy_install_packages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->packages = packages;
	_data_->packages_length1 = packages_length1;
	aptd_proxy_install_packages_co (_data_);
}

gchar*
aptd_proxy_install_packages_finish (AptdProxy* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	gchar* result;
	AptdProxyInstallPackagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
aptd_proxy_install_packages_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	AptdProxyInstallPackagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	aptd_proxy_install_packages_co (_data_);
}

static gboolean
aptd_proxy_install_packages_co (AptdProxyInstallPackagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_aptd_service;
	_data_->_state_ = 1;
	aptd_service_install_packages (_data_->_tmp0_, _data_->packages, (gint) _data_->packages_length1, aptd_proxy_install_packages_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = aptd_service_install_packages_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->res = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->res;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
aptd_proxy_remove_packages_data_free (gpointer _data)
{
	AptdProxyRemovePackagesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AptdProxyRemovePackagesData, _data_);
}

void
aptd_proxy_remove_packages (AptdProxy* self,
                            gchar** packages,
                            gint packages_length1,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	AptdProxyRemovePackagesData* _data_;
	AptdProxy* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AptdProxyRemovePackagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, aptd_proxy_remove_packages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->packages = packages;
	_data_->packages_length1 = packages_length1;
	aptd_proxy_remove_packages_co (_data_);
}

gchar*
aptd_proxy_remove_packages_finish (AptdProxy* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	gchar* result;
	AptdProxyRemovePackagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
aptd_proxy_remove_packages_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	AptdProxyRemovePackagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	aptd_proxy_remove_packages_co (_data_);
}

static gboolean
aptd_proxy_remove_packages_co (AptdProxyRemovePackagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_aptd_service;
	_data_->_state_ = 1;
	aptd_service_remove_packages (_data_->_tmp0_, _data_->packages, (gint) _data_->packages_length1, aptd_proxy_remove_packages_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = aptd_service_remove_packages_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->res = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->res;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
aptd_proxy_quit_data_free (gpointer _data)
{
	AptdProxyQuitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AptdProxyQuitData, _data_);
}

void
aptd_proxy_quit (AptdProxy* self,
                 GAsyncReadyCallback _callback_,
                 gpointer _user_data_)
{
	AptdProxyQuitData* _data_;
	AptdProxy* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AptdProxyQuitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, aptd_proxy_quit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	aptd_proxy_quit_co (_data_);
}

void
aptd_proxy_quit_finish (AptdProxy* self,
                        GAsyncResult* _res_,
                        GError** error)
{
	AptdProxyQuitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
aptd_proxy_quit_ready (GObject* source_object,
                       GAsyncResult* _res_,
                       gpointer _user_data_)
{
	AptdProxyQuitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	aptd_proxy_quit_co (_data_);
}

static gboolean
aptd_proxy_quit_co (AptdProxyQuitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_aptd_service;
	_data_->_state_ = 1;
	aptd_service_quit (_data_->_tmp0_, aptd_proxy_quit_ready, _data_);
	return FALSE;
	_state_1:
	aptd_service_quit_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

AptdProxy*
aptd_proxy_construct (GType object_type)
{
	AptdProxy * self = NULL;
	self = (AptdProxy*) g_object_new (object_type, NULL);
	return self;
}

AptdProxy*
aptd_proxy_new (void)
{
	return aptd_proxy_construct (TYPE_APTD_PROXY);
}

static void
aptd_proxy_class_init (AptdProxyClass * klass,
                       gpointer klass_data)
{
	aptd_proxy_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AptdProxy_private_offset);
	G_OBJECT_CLASS (klass)->finalize = aptd_proxy_finalize;
}

static void
aptd_proxy_instance_init (AptdProxy * self,
                          gpointer klass)
{
	self->priv = aptd_proxy_get_instance_private (self);
}

static void
aptd_proxy_finalize (GObject * obj)
{
	AptdProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APTD_PROXY, AptdProxy);
	_g_object_unref0 (self->priv->_aptd_service);
	G_OBJECT_CLASS (aptd_proxy_parent_class)->finalize (obj);
}

static GType
aptd_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AptdProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aptd_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AptdProxy), 0, (GInstanceInitFunc) aptd_proxy_instance_init, NULL };
	GType aptd_proxy_type_id;
	aptd_proxy_type_id = g_type_register_static (G_TYPE_OBJECT, "AptdProxy", &g_define_type_info, 0);
	AptdProxy_private_offset = g_type_add_instance_private (aptd_proxy_type_id, sizeof (AptdProxyPrivate));
	return aptd_proxy_type_id;
}

GType
aptd_proxy_get_type (void)
{
	static volatile gsize aptd_proxy_type_id__once = 0;
	if (g_once_init_enter (&aptd_proxy_type_id__once)) {
		GType aptd_proxy_type_id;
		aptd_proxy_type_id = aptd_proxy_get_type_once ();
		g_once_init_leave (&aptd_proxy_type_id__once, aptd_proxy_type_id);
	}
	return aptd_proxy_type_id__once;
}

static inline gpointer
aptd_transaction_proxy_get_instance_private (AptdTransactionProxy* self)
{
	return G_STRUCT_MEMBER_P (self, AptdTransactionProxy_private_offset);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		AptdTransactionProxy* self;
		self = _data5_->self;
		_g_free0 (_data5_->transaction_id);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda16_ (Block5Data* _data5_,
             const gchar* exit_state)
{
	AptdTransactionProxy* self;
	self = _data5_->self;
	g_return_if_fail (exit_state != NULL);
	g_debug ("aptd-client.vala:72: aptd transaction finished: %s\n", exit_state);
	g_signal_emit (self, aptd_transaction_proxy_signals[APTD_TRANSACTION_PROXY_FINISHED_SIGNAL], 0, _data5_->transaction_id);
}

static void
___lambda16__aptd_transaction_service_finished (AptdTransactionService* _sender,
                                                const gchar* exit_state,
                                                gpointer self)
{
	__lambda16_ (self, exit_state);
}

static void
__lambda17_ (AptdTransactionProxy* self,
             const gchar* prop,
             GVariant* variant)
{
	g_return_if_fail (prop != NULL);
	g_return_if_fail (variant != NULL);
	g_signal_emit (self, aptd_transaction_proxy_signals[APTD_TRANSACTION_PROXY_PROPERTY_CHANGED_SIGNAL], 0, prop, variant);
}

static void
___lambda17__aptd_transaction_service_property_changed (AptdTransactionService* _sender,
                                                        const gchar* property,
                                                        GVariant* val,
                                                        gpointer self)
{
	__lambda17_ ((AptdTransactionProxy*) self, property, val);
}

void
aptd_transaction_proxy_connect_to_aptd (AptdTransactionProxy* self,
                                        const gchar* transaction_id,
                                        GError** error)
{
	Block5Data* _data5_;
	gchar* _tmp0_;
	AptdTransactionService* _tmp1_ = NULL;
	AptdTransactionService* _tmp2_;
	AptdTransactionService* _tmp3_;
	AptdTransactionService* _tmp4_;
	AptdTransactionService* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transaction_id != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_strdup (transaction_id);
	_g_free0 (_data5_->transaction_id);
	_data5_->transaction_id = _tmp0_;
	_tmp2_ = (AptdTransactionService*) g_initable_new (TYPE_APTD_TRANSACTION_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", APTD_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data5_->transaction_id, "g-interface-name", "org.debian.apt.transaction", NULL);
	_tmp1_ = (AptdTransactionService*) _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->_aptd_service);
	self->priv->_aptd_service = _tmp3_;
	_tmp4_ = self->priv->_aptd_service;
	g_signal_connect_data (_tmp4_, "finished", (GCallback) ___lambda16__aptd_transaction_service_finished, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp5_ = self->priv->_aptd_service;
	g_signal_connect_object (_tmp5_, "property-changed", (GCallback) ___lambda17__aptd_transaction_service_property_changed, self, 0);
	_g_object_unref0 (_tmp1_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

void
aptd_transaction_proxy_simulate (AptdTransactionProxy* self,
                                 GError** error)
{
	AptdTransactionService* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_aptd_service;
	aptd_transaction_service_simulate (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
aptd_transaction_proxy_run (AptdTransactionProxy* self,
                            GError** error)
{
	AptdTransactionService* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_aptd_service;
	aptd_transaction_service_run (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
aptd_transaction_proxy_cancel (AptdTransactionProxy* self,
                               GError** error)
{
	AptdTransactionService* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_aptd_service;
	aptd_transaction_service_cancel (_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

AptdTransactionProxy*
aptd_transaction_proxy_construct (GType object_type)
{
	AptdTransactionProxy * self = NULL;
	self = (AptdTransactionProxy*) g_object_new (object_type, NULL);
	return self;
}

AptdTransactionProxy*
aptd_transaction_proxy_new (void)
{
	return aptd_transaction_proxy_construct (TYPE_APTD_TRANSACTION_PROXY);
}

static void
aptd_transaction_proxy_class_init (AptdTransactionProxyClass * klass,
                                   gpointer klass_data)
{
	aptd_transaction_proxy_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AptdTransactionProxy_private_offset);
	G_OBJECT_CLASS (klass)->finalize = aptd_transaction_proxy_finalize;
	aptd_transaction_proxy_signals[APTD_TRANSACTION_PROXY_FINISHED_SIGNAL] = g_signal_new ("finished", TYPE_APTD_TRANSACTION_PROXY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	aptd_transaction_proxy_signals[APTD_TRANSACTION_PROXY_PROPERTY_CHANGED_SIGNAL] = g_signal_new ("property-changed", TYPE_APTD_TRANSACTION_PROXY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
}

static void
aptd_transaction_proxy_instance_init (AptdTransactionProxy * self,
                                      gpointer klass)
{
	self->priv = aptd_transaction_proxy_get_instance_private (self);
}

static void
aptd_transaction_proxy_finalize (GObject * obj)
{
	AptdTransactionProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APTD_TRANSACTION_PROXY, AptdTransactionProxy);
	_g_object_unref0 (self->priv->_aptd_service);
	G_OBJECT_CLASS (aptd_transaction_proxy_parent_class)->finalize (obj);
}

static GType
aptd_transaction_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AptdTransactionProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aptd_transaction_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AptdTransactionProxy), 0, (GInstanceInitFunc) aptd_transaction_proxy_instance_init, NULL };
	GType aptd_transaction_proxy_type_id;
	aptd_transaction_proxy_type_id = g_type_register_static (G_TYPE_OBJECT, "AptdTransactionProxy", &g_define_type_info, 0);
	AptdTransactionProxy_private_offset = g_type_add_instance_private (aptd_transaction_proxy_type_id, sizeof (AptdTransactionProxyPrivate));
	return aptd_transaction_proxy_type_id;
}

GType
aptd_transaction_proxy_get_type (void)
{
	static volatile gsize aptd_transaction_proxy_type_id__once = 0;
	if (g_once_init_enter (&aptd_transaction_proxy_type_id__once)) {
		GType aptd_transaction_proxy_type_id;
		aptd_transaction_proxy_type_id = aptd_transaction_proxy_get_type_once ();
		g_once_init_leave (&aptd_transaction_proxy_type_id__once, aptd_transaction_proxy_type_id);
	}
	return aptd_transaction_proxy_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

