/*
 * Copyright (C) 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
/**
 * **IMPORTANT** this module should not depend on `vscode-languageserver` only protocol and types
 */
import lsp from 'vscode-languageserver-protocol';
import tslib from 'typescript/lib/tsserverlibrary.js';
var tsp = tslib.server.protocol;
export { tslib, tsp };
export var TypeScriptRenameRequest;
(function (TypeScriptRenameRequest) {
    TypeScriptRenameRequest.type = new lsp.RequestType('_typescript.rename');
})(TypeScriptRenameRequest = TypeScriptRenameRequest || (TypeScriptRenameRequest = {}));
export class KindModifiers {
}
KindModifiers.optional = 'optional';
KindModifiers.deprecated = 'deprecated';
KindModifiers.dtsFile = '.d.ts';
KindModifiers.tsFile = '.ts';
KindModifiers.tsxFile = '.tsx';
KindModifiers.jsFile = '.js';
KindModifiers.jsxFile = '.jsx';
KindModifiers.jsonFile = '.json';
KindModifiers.fileExtensionKindModifiers = [
    KindModifiers.dtsFile,
    KindModifiers.tsFile,
    KindModifiers.tsxFile,
    KindModifiers.jsFile,
    KindModifiers.jsxFile,
    KindModifiers.jsonFile,
];
const SYMBOL_DISPLAY_PART_KIND_MAP = {
    aliasName: 0,
    className: 1,
    enumName: 2,
    fieldName: 3,
    interfaceName: 4,
    keyword: 5,
    lineBreak: 6,
    numericLiteral: 7,
    stringLiteral: 8,
    localName: 9,
    methodName: 10,
    moduleName: 11,
    operator: 12,
    parameterName: 13,
    propertyName: 14,
    punctuation: 15,
    space: 16,
    text: 17,
    typeParameterName: 18,
    enumMemberName: 19,
    functionName: 20,
    regularExpressionLiteral: 21,
    link: 22,
    linkName: 23,
    linkText: 24,
};
export function toSymbolDisplayPartKind(kind) {
    return SYMBOL_DISPLAY_PART_KIND_MAP[kind];
}
//# sourceMappingURL=ts-protocol.js.map